/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms;

import com.google.common.base.Optional;
import com.vmware.opsmgmt.client.extension.alarms.AlarmDefinition;
import com.vmware.opsmgmt.client.extension.alarms.PropertyFacade;
import com.vmware.opsmgmt.client.extension.alarms.details.AlarmDetails;
import com.vmware.opsmgmt.client.extension.alarms.monitortype.AlarmMonitorType;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmDefWizardInfo;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmDefWizardSpec;
import com.vmware.vim.binding.vim.alarm.Alarm;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;

public class AlarmsPropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final String ALARM_DEFINITIONS = "alarmDefinitions";
    private static final String ALARM_DETAILS = "alarmDetails";
    private static final String ALARM_MONITOR_TYPES = "alarmMonitorTypes";
    private static final String H5_ALARM_WIZARD_INFO = "h5AlarmWizardInfo";
    private final PropertyFacade _propertyFacade;

    public AlarmsPropertyProviderAdapter(DataServiceExtensionRegistry registry, PropertyFacade propertyFacade) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{registry});
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this._propertyFacade = propertyFacade;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = "*";
        ti.properties = new String[]{ALARM_DEFINITIONS};
        TypeInfo ti2 = new TypeInfo();
        ti2.type = Alarm.class.getSimpleName();
        ti2.properties = new String[]{ALARM_DETAILS};
        TypeInfo t3 = new TypeInfo();
        t3.type = "*";
        t3.properties = new String[]{ALARM_MONITOR_TYPES};
        TypeInfo t4 = new TypeInfo();
        t4.type = "*";
        t4.properties = new String[]{H5_ALARM_WIZARD_INFO};
        return new TypeInfo[]{ti, ti2, t3, t4};
    }

    public ResultSet getProperties(PropertyRequestSpec propRequestSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propRequestSpec});
        Object[] objects = propRequestSpec.objects;
        PropertySpec[] properties = propRequestSpec.properties;
        if (objects == null || objects.length == 0 || properties == null || properties.length == 0) {
            return null;
        }
        ResultSet result = new ResultSet();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        ArrayList<MethodFault> faults = new ArrayList<MethodFault>();
        for (Object obj : objects) {
            try {
                Optional<AlarmDetails> alarmDetails;
                ResultItem ri;
                if (this.isPropertyRequested(ALARM_DEFINITIONS, properties)) {
                    List<AlarmDefinition> alarmDefs = this._propertyFacade.createAlarmDefinitions(obj);
                    ri = this.createAlarmDefResult(obj, alarmDefs);
                    resultItems.add(ri);
                }
                if (this.isPropertyRequested(ALARM_DETAILS, properties) && (alarmDetails = this._propertyFacade.createAlarmDetails(obj)).isPresent()) {
                    ri = this.createAlarmDetailsResult(obj, (AlarmDetails)alarmDetails.get());
                    resultItems.add(ri);
                }
                if (this.isPropertyRequested(ALARM_MONITOR_TYPES, properties)) {
                    List<AlarmMonitorType> monitorTypeInfos = this._propertyFacade.createAlarmMonitorTypeInfo(obj);
                    ri = this.createAlarmMonitorTypesResult(obj, monitorTypeInfos);
                    resultItems.add(ri);
                }
                if (!this.isPropertyRequested(H5_ALARM_WIZARD_INFO, properties)) continue;
                AlarmDefWizardSpec spec = (AlarmDefWizardSpec)((Object)this.getParameters(H5_ALARM_WIZARD_INFO, properties));
                Validate.notNull((Object)((Object)spec));
                AlarmDefWizardInfo alarmDefWizardInfo = this._propertyFacade.createAlarmWizardInfo(obj, spec);
                ResultItem ri2 = this.createAlarmWizardInfoResult(obj, alarmDefWizardInfo);
                resultItems.add(ri2);
            }
            catch (Exception e) {
                faults.add(MixedUtil.getMethodFault((Throwable)e));
            }
        }
        if (!faults.isEmpty()) {
            result.error = new CompositeException(faults);
        }
        result.items = resultItems.toArray(new ResultItem[0]);
        return result;
    }

    private ResultItem createAlarmDetailsResult(Object obj, AlarmDetails alarmDetails) {
        return this.createResultItem(obj, alarmDetails, ALARM_DETAILS);
    }

    private ResultItem createAlarmDefResult(Object obj, List<AlarmDefinition> alarmDefs) {
        return this.createResultItem(obj, alarmDefs, ALARM_DEFINITIONS);
    }

    private ResultItem createAlarmMonitorTypesResult(Object obj, List<AlarmMonitorType> monitorTypeInfos) {
        return this.createResultItem(obj, monitorTypeInfos, ALARM_MONITOR_TYPES);
    }

    private ResultItem createAlarmWizardInfoResult(Object obj, AlarmDefWizardInfo wizardInfo) {
        return this.createResultItem(obj, (Object)wizardInfo, H5_ALARM_WIZARD_INFO);
    }

    private ResultItem createResultItem(Object obj, Object objValue, String propertyName) {
        PropertyValue pv = new PropertyValue();
        pv.resourceObject = obj;
        pv.propertyName = propertyName;
        pv.value = objValue;
        ResultItem ri = new ResultItem();
        ri.resourceObject = obj;
        ri.properties = new PropertyValue[]{pv};
        return ri;
    }

    private boolean isPropertyRequested(String property, PropertySpec[] properties) {
        for (PropertySpec pSpec : properties) {
            for (String p : pSpec.propertyNames) {
                if (!property.equals(p)) continue;
                return true;
            }
        }
        return false;
    }

    private <T> T getParameters(String property, PropertySpec[] properties) {
        for (PropertySpec pSpec : properties) {
            for (String propertyName : pSpec.propertyNames) {
                if (!property.equals(propertyName)) continue;
                Validate.notEmpty((Object[])pSpec.parameters);
                for (ParameterSpec paramSpec : pSpec.parameters) {
                    if (!paramSpec.propertyName.equals(property) || paramSpec.parameter == null) continue;
                    return (T)paramSpec.parameter;
                }
            }
        }
        return null;
    }
}

