/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.definition.actions;

import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionConfigDescription;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionWrapper;
import com.vmware.vim.binding.vim.action.SendEmailAction;
import com.vmware.vim.binding.vim.alarm.AlarmTriggeringAction;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.List;

public class SendMailActionWrapper
extends ActionWrapper {
    public static final String TO_LIST = "toList";
    public static final String CC_LIST = "ccList";
    public static final String SUBJECT = "subject";
    public static final String BODY = "body";

    public SendMailActionWrapper(AlarmTriggeringAction action) {
        super(action, "Alarm.AlarmHelper.SendEmail");
    }

    @Override
    public List<ActionConfigDescription> getConfiguration() {
        ArrayList<ActionConfigDescription> configs = new ArrayList<ActionConfigDescription>();
        SendEmailAction sendEmailAction = (SendEmailAction)this._action.action;
        ActionConfigDescription toList = new ActionConfigDescription(TO_LIST, Localization.getString("actions.email.toList"), sendEmailAction.toList, sendEmailAction.toList);
        configs.add(toList);
        if (!StringUtil.isNullOrEmpty((String)sendEmailAction.ccList)) {
            ActionConfigDescription ccList = new ActionConfigDescription(CC_LIST, Localization.getString("actions.email.ccList"), sendEmailAction.ccList, sendEmailAction.ccList);
            configs.add(ccList);
        }
        if (!StringUtil.isNullOrEmpty((String)sendEmailAction.subject)) {
            ActionConfigDescription subject = new ActionConfigDescription(SUBJECT, Localization.getString("actions.email.subject"), sendEmailAction.subject, sendEmailAction.subject);
            configs.add(subject);
        }
        if (!StringUtil.isNullOrEmpty((String)sendEmailAction.body)) {
            ActionConfigDescription body = new ActionConfigDescription(BODY, Localization.getString("actions.email.body"), sendEmailAction.body, sendEmailAction.body);
            configs.add(body);
        }
        return configs;
    }

    @Override
    public void setConfiguration(List<ActionConfigDescription> conf) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{conf});
        SendEmailAction mailAction = (SendEmailAction)this._action.action;
        for (ActionConfigDescription descr : conf) {
            String propName;
            switch (propName = descr.getName()) {
                case "toList": {
                    mailAction.toList = descr.getValue().toString();
                    break;
                }
                case "ccList": {
                    mailAction.ccList = descr.getValue().toString();
                    break;
                }
                case "body": {
                    mailAction.body = descr.getValue().toString();
                    break;
                }
                case "subject": {
                    mailAction.subject = descr.getValue().toString();
                }
            }
        }
    }

    @Override
    public String getConfigString() {
        String configString = ((SendEmailAction)this._action.action).toList;
        return configString == null ? "" : configString;
    }

    @Override
    public void setConfigString(String config) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{config});
        SendEmailAction sendMailAction = (SendEmailAction)this._action.action;
        sendMailAction.toList = config;
        if (sendMailAction.ccList == null) {
            sendMailAction.ccList = "";
        }
        if (sendMailAction.subject == null) {
            sendMailAction.subject = "";
        }
        if (sendMailAction.body == null) {
            sendMailAction.body = "";
        }
    }

    @Override
    public String validateConfigString(String config) {
        String[] emails;
        if (StringUtil.isNullOrEmpty((String)config)) {
            return Localization.getString("sendMailActionWrapper.error.configure.email");
        }
        String separator = ";";
        if (config.lastIndexOf(",") != -1) {
            separator = ",";
        }
        for (String email : emails = config.split(separator)) {
            boolean valid = true;
            if (valid) continue;
            String msg = Localization.getFormattedString("sendMailActionWrapper.error.invalid.email", new String[]{email});
            return msg;
        }
        return "";
    }

    @Override
    public boolean supportsConfiguration() {
        return true;
    }

    @Override
    protected String validateConfigurationInternal() {
        return this.validateConfigString(this._action.action.toString());
    }
}

