/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.monitortype;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.opsmgmt.client.extension.alarms.AlarmsUtil;
import com.vmware.opsmgmt.client.extension.alarms.monitortype.AlarmMonitorType;
import com.vmware.opsmgmt.client.extension.alarms.monitortype.AlarmObjectMonitorTypesInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MonitorTypeInfoConfigUtil {
    private static final String CONFIG_FILE_PATH = "/MonitorTypeInfoConfig.json";

    public static List<AlarmMonitorType> getMonitorTypeInfoConfig(ManagedObjectReference objRef) {
        String objType = AlarmsUtil.getNormalizeType(objRef);
        URL resource = MonitorTypeInfoConfigUtil.class.getResource(CONFIG_FILE_PATH);
        if (resource == null) {
            throw new IllegalStateException("Could not find alarm config: /MonitorTypeInfoConfig.json");
        }
        try {
            AlarmObjectMonitorTypesInfo[] configData;
            ObjectMapper objectMapper = new ObjectMapper();
            for (AlarmObjectMonitorTypesInfo objectInfo : configData = (AlarmObjectMonitorTypesInfo[])objectMapper.readValue(resource, AlarmObjectMonitorTypesInfo[].class)) {
                if (!objType.equals(objectInfo.objectType)) continue;
                return Arrays.asList(objectInfo.monitorTypes);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Collections.emptyList();
    }
}

