/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.wizardinfo;

import com.vmware.opsmgmt.client.alarms.AlarmDefInfoSpec;
import com.vmware.opsmgmt.client.alarms.AlarmDefinitionInfo;
import com.vmware.opsmgmt.client.alarms.EventAlarmDetails;
import com.vmware.opsmgmt.client.alarms.ServerCollection;
import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.configuration.AlarmConfiguration;
import com.vmware.opsmgmt.client.extension.alarms.configuration.AlarmConfigurator;
import com.vmware.opsmgmt.client.extension.alarms.configuration.MetricTrigger;
import com.vmware.opsmgmt.client.extension.alarms.configuration.StateCollection;
import com.vmware.opsmgmt.client.extension.alarms.configuration.StateTrigger;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmDefWizardInfo;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmDefWizardSpec;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmEventTriggerInfo;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmMetricTriggerInfo;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmStateTriggerInfo;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmTriggerCategoryInfo;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmTriggerInfo;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.triggercategories.AlarmTriggerCategoryConfig;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.triggercategories.AlarmTriggerCategoryUtil;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryOption;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlarmWizardInfoCreator {
    private static final Log _logger = LogFactory.getLog(AlarmWizardInfoCreator.class);
    private static final String ALARM_WIZARD_INFO = "alarmWizardInfo";
    private static final int QUERY_TIMEOUT_MILLI_SECONDS = 60000;
    private static final String ALARM_OTHER_TRIGGER_CATEGORY_KEY = "AnyType.triggerCategory.Others";
    private AlarmConfiguration alarmConfiguration = new AlarmConfigurator().parseConfig();
    private QuerySpecBuilder querySpecBuilder;
    private QueryExecutor queryExecutor;
    private DataService dataService;

    public AlarmWizardInfoCreator(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this.queryExecutor = queryExecutor;
        this.querySpecBuilder = querySpecBuilder;
    }

    public AlarmDefWizardInfo createAlarmWizardinfo(ManagedObjectReference moRef, AlarmDefWizardSpec spec) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"Requested h5AlarmWizardInfo for monitor object type : ", spec.monitorType, " and alarm: ", spec.alarm}));
        }
        List<StateTrigger> stateTriggersConfig = this.alarmConfiguration.getStateTriggersByMoType(spec.monitorType);
        List<MetricTrigger> metricTriggersConfig = this.alarmConfiguration.getMetricTriggersByMoType(spec.monitorType);
        Map<String, StateTrigger> scToStateTriggerConfig = this.mapSCToStateTriggerConfig(stateTriggersConfig);
        Map<String, MetricTrigger> idToMetricTriggerConfig = this.mapIdToMetricTriggerConfig(metricTriggersConfig);
        AlarmDefinitionInfo alarmDefinitionInfo = this.getAlarmDefinitionInfo(moRef, spec.monitorType, spec.alarm, idToMetricTriggerConfig.keySet(), scToStateTriggerConfig.keySet());
        AlarmDefWizardInfo alarmDefWizardInfo = new AlarmDefWizardInfo();
        HashMap<String, AlarmTriggerInfo> idToAlarmTriggerInfo = new HashMap<String, AlarmTriggerInfo>();
        if (alarmDefinitionInfo.states != null) {
            for (ServerCollection sc : alarmDefinitionInfo.states) {
                StateTrigger stateTriggerConfig = scToStateTriggerConfig.get(sc.name);
                AlarmStateTriggerInfo stateTriggerInfo = new AlarmStateTriggerInfo();
                stateTriggerInfo.displayText = Localization.getTriggerName(stateTriggerConfig);
                stateTriggerInfo.stateTriggerConfig = stateTriggerConfig;
                stateTriggerInfo.serverCollection = sc;
                idToAlarmTriggerInfo.put(stateTriggerConfig.nameResourceId.toLowerCase(), stateTriggerInfo);
            }
        }
        if (alarmDefinitionInfo.counters != null) {
            for (PerformanceManager.CounterInfo counterInfo : alarmDefinitionInfo.counters) {
                String counterId = this.getCounterId(counterInfo);
                MetricTrigger metricTriggerConfig = idToMetricTriggerConfig.get(counterId);
                AlarmMetricTriggerInfo metricTriggerInfo = new AlarmMetricTriggerInfo();
                metricTriggerInfo.counterInfo = counterInfo;
                metricTriggerInfo.metricTriggerConfig = metricTriggerConfig;
                metricTriggerInfo.displayText = Localization.getTriggerName(metricTriggerConfig);
                idToAlarmTriggerInfo.put(counterId.toLowerCase(), metricTriggerInfo);
            }
        }
        if (alarmDefinitionInfo.events != null) {
            for (EventAlarmDetails eventAlarmDetails : alarmDefinitionInfo.events) {
                AlarmEventTriggerInfo eventTriggerInfo = new AlarmEventTriggerInfo();
                eventTriggerInfo.eventDetails = eventAlarmDetails;
                eventTriggerInfo.displayText = eventAlarmDetails.description != null ? eventAlarmDetails.description : eventAlarmDetails.eventTypeId;
                idToAlarmTriggerInfo.put(eventAlarmDetails.eventTypeId.toLowerCase(), eventTriggerInfo);
            }
        }
        for (StateTrigger stateTriggerConfig : stateTriggersConfig) {
            StateCollection states = stateTriggerConfig.states;
            if (states == null || states.serverCollection != null) continue;
            AlarmStateTriggerInfo stateTriggerInfo = new AlarmStateTriggerInfo();
            stateTriggerInfo.displayText = Localization.getTriggerName(stateTriggerConfig);
            stateTriggerInfo.stateTriggerConfig = stateTriggerConfig;
            idToAlarmTriggerInfo.put(stateTriggerConfig.nameResourceId.toLowerCase(), stateTriggerInfo);
        }
        Object[] triggerCategoryConfigs = AlarmTriggerCategoryUtil.getTriggerCategories(spec.monitorType);
        ArrayList<AlarmTriggerCategoryInfo> triggerCategoryInfos = new ArrayList<AlarmTriggerCategoryInfo>();
        if (!ArrayUtil.isNullOrEmpty((Object[])triggerCategoryConfigs)) {
            for (Object categoryConfig : triggerCategoryConfigs) {
                ArrayList<AlarmTriggerInfo> triggerInfos = new ArrayList<AlarmTriggerInfo>();
                if (((AlarmTriggerCategoryConfig)categoryConfig).states != null) {
                    for (String stateId : ((AlarmTriggerCategoryConfig)categoryConfig).states) {
                        AlarmTriggerInfo stateInfo = (AlarmTriggerInfo)((Object)idToAlarmTriggerInfo.remove(stateId = stateId.toLowerCase()));
                        if (stateInfo == null) continue;
                        triggerInfos.add(stateInfo);
                    }
                }
                if (((AlarmTriggerCategoryConfig)categoryConfig).counters != null) {
                    for (String counterId : ((AlarmTriggerCategoryConfig)categoryConfig).counters) {
                        AlarmTriggerInfo counterInfo = (AlarmTriggerInfo)((Object)idToAlarmTriggerInfo.remove(counterId = counterId.toLowerCase()));
                        if (counterInfo == null) continue;
                        triggerInfos.add(counterInfo);
                    }
                }
                if (((AlarmTriggerCategoryConfig)categoryConfig).events != null) {
                    for (String eventId : ((AlarmTriggerCategoryConfig)categoryConfig).events) {
                        AlarmTriggerInfo eventInfo = (AlarmTriggerInfo)((Object)idToAlarmTriggerInfo.remove(eventId = eventId.toLowerCase()));
                        if (eventInfo == null) continue;
                        triggerInfos.add(eventInfo);
                    }
                }
                if (triggerInfos.size() <= 0) continue;
                AlarmTriggerCategoryInfo categoryInfo = new AlarmTriggerCategoryInfo();
                categoryInfo.categoryName = Localization.getTriggerCategoryName(spec.monitorType, ((AlarmTriggerCategoryConfig)categoryConfig).categoryKey);
                categoryInfo.triggers = this.sortTheTriggerInfos(triggerInfos).toArray(new AlarmTriggerInfo[0]);
                triggerCategoryInfos.add(categoryInfo);
            }
        }
        if (idToAlarmTriggerInfo.size() > 0) {
            AlarmTriggerCategoryInfo othersCategory = new AlarmTriggerCategoryInfo();
            othersCategory.categoryName = Localization.getString(ALARM_OTHER_TRIGGER_CATEGORY_KEY);
            othersCategory.triggers = this.sortTheTriggerInfos(idToAlarmTriggerInfo.values()).toArray(new AlarmTriggerInfo[0]);
            triggerCategoryInfos.add(othersCategory);
        }
        alarmDefWizardInfo.triggerCategories = this.sortTheTriggerCategoryInfos(triggerCategoryInfos).toArray(new AlarmTriggerCategoryInfo[0]);
        alarmDefWizardInfo.migrateActionArgs = alarmDefinitionInfo.migrateActionArgs;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"Returning h5AlarmWizardInfo for monitor object type : ", spec.monitorType, " and alarm: ", spec.alarm, " with trigger category count ", alarmDefWizardInfo.triggerCategories.length}));
        }
        return alarmDefWizardInfo;
    }

    private Map<String, StateTrigger> mapSCToStateTriggerConfig(List<StateTrigger> stateTriggers) {
        HashMap<String, StateTrigger> scToStateTriggerConfig = new HashMap<String, StateTrigger>();
        for (StateTrigger stconfig : stateTriggers) {
            String sc = stconfig.states.serverCollection;
            if (sc == null) continue;
            scToStateTriggerConfig.put(sc, stconfig);
        }
        return scToStateTriggerConfig;
    }

    private Map<String, MetricTrigger> mapIdToMetricTriggerConfig(List<MetricTrigger> metricTriggersConfig) {
        HashMap<String, MetricTrigger> idToMetricTriggerConfig = new HashMap<String, MetricTrigger>();
        for (MetricTrigger metricTriggerconfig : metricTriggersConfig) {
            idToMetricTriggerConfig.put(metricTriggerconfig.counter, metricTriggerconfig);
        }
        return idToMetricTriggerConfig;
    }

    private AlarmDefinitionInfo getAlarmDefinitionInfo(ManagedObjectReference moRef, String moType, ManagedObjectReference alarmRef, Collection<String> counterIds, Collection<String> serverCollections) throws Exception {
        AlarmDefInfoSpec alarmDefInfoSpec = this.createAlarmDefInfoSpec(moType, alarmRef, counterIds, serverCollections);
        QuerySpec querySpec = this.querySpecBuilder.buildQuerySpec((Object)moRef, new String[]{ALARM_WIZARD_INFO});
        querySpec.options = new HashMap();
        querySpec.options.put(QueryOption.DS_CORE_QUERY_TIMEOUT_MS.name(), 60000);
        ParameterSpec parameterSpec = new ParameterSpec();
        parameterSpec.parameter = alarmDefInfoSpec;
        parameterSpec.propertyName = ALARM_WIZARD_INFO;
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = new String[]{ALARM_WIZARD_INFO};
        propertySpec.parameters = new ParameterSpec[]{parameterSpec};
        querySpec.resourceSpec.propertySpecs[0].parameters = new ParameterSpec[]{parameterSpec};
        ResultSet resultSet = this.queryExecutor.getData(querySpec);
        return this.extractAlarmDefinitionInfoFromResultSet(resultSet);
    }

    private AlarmDefInfoSpec createAlarmDefInfoSpec(String moType, ManagedObjectReference alarmRef, Collection<String> counterIds, Collection<String> serverCollections) {
        AlarmDefInfoSpec alarmDefInfoSpec = new AlarmDefInfoSpec();
        alarmDefInfoSpec.moType = moType;
        alarmDefInfoSpec.getEvents = true;
        alarmDefInfoSpec.alarm = alarmRef;
        alarmDefInfoSpec.counters = counterIds.toArray(new String[0]);
        alarmDefInfoSpec.serverCollections = serverCollections.toArray(new String[0]);
        return alarmDefInfoSpec;
    }

    private AlarmDefinitionInfo extractAlarmDefinitionInfoFromResultSet(ResultSet resultSet) {
        if (resultSet == null || resultSet.items == null) {
            return new AlarmDefinitionInfo();
        }
        for (ResultItem resultItem : resultSet.items) {
            if (resultItem == null || resultItem.properties == null) continue;
            for (PropertyValue propValue : resultItem.properties) {
                if (propValue == null || !ALARM_WIZARD_INFO.equals(propValue.propertyName)) continue;
                return (AlarmDefinitionInfo)propValue.value;
            }
        }
        return new AlarmDefinitionInfo();
    }

    private String getCounterId(PerformanceManager.CounterInfo counterInfo) {
        return String.format("%s.%s.%s", counterInfo.groupInfo.key, counterInfo.nameInfo.key, counterInfo.rollupType).toLowerCase();
    }

    private List<AlarmTriggerInfo> sortTheTriggerInfos(Collection<AlarmTriggerInfo> triggersInfos) {
        ArrayList<AlarmTriggerInfo> triggersList = new ArrayList<AlarmTriggerInfo>(triggersInfos);
        Collections.sort(triggersList, new Comparator<AlarmTriggerInfo>(){

            @Override
            public int compare(AlarmTriggerInfo o1, AlarmTriggerInfo o2) {
                if (o1 == null || o1.displayText == null) {
                    return -1;
                }
                return o1.displayText.compareToIgnoreCase(o2.displayText);
            }
        });
        return triggersList;
    }

    private List<AlarmTriggerCategoryInfo> sortTheTriggerCategoryInfos(Collection<AlarmTriggerCategoryInfo> triggerCategoryInfos) {
        ArrayList<AlarmTriggerCategoryInfo> triggerCategoriesList = new ArrayList<AlarmTriggerCategoryInfo>(triggerCategoryInfos);
        Collections.sort(triggerCategoriesList, new Comparator<AlarmTriggerCategoryInfo>(){

            @Override
            public int compare(AlarmTriggerCategoryInfo o1, AlarmTriggerCategoryInfo o2) {
                if (o1 == null || o1.categoryName == null) {
                    return -1;
                }
                return o1.categoryName.compareToIgnoreCase(o2.categoryName);
            }
        });
        return triggerCategoriesList;
    }
}

