/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.common.compositecommand;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.compositecommand.api.spec.BaseCommandSpec;

final class CommandDebugUtil {
    public static String dumpCommandSpec(BaseCommandSpec spec, boolean dumpDependentSpecs) {
        return CommandDebugUtil.dumpCommandSpecInternal(spec, dumpDependentSpecs, " ");
    }

    private static String dumpCommandSpecInternal(BaseCommandSpec spec, boolean dumpDependentSpecs, String prefix) {
        try {
            if (spec == null) {
                return prefix + "null";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(prefix).append(spec.getClass().getCanonicalName());
            sb.append("\n").append(prefix).append("  mor: ").append(ManagedObjectUtil.morefToString((ManagedObjectReference)spec.mor));
            sb.append("\n").append(prefix).append("  dependentSpecs: ");
            if (spec.dependentSpecs == null) {
                sb.append("null");
            } else {
                sb.append("length(").append(spec.dependentSpecs.length).append(")");
                if (dumpDependentSpecs) {
                    for (BaseCommandSpec depSpec : spec.dependentSpecs) {
                        sb.append("\n");
                        sb.append(CommandDebugUtil.dumpCommandSpecInternal(depSpec, true, prefix + "    "));
                    }
                }
            }
            return sb.toString();
        }
        catch (Exception ex) {
            return "Error generating command spec tree dump: " + ex.toString();
        }
    }

    private CommandDebugUtil() {
    }
}

