/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vcha;

import com.google.common.base.Preconditions;
import com.vmware.vapi.bindings.Structure;
import com.vmware.vapi.std.errors.UnverifiedPeer;
import com.vmware.vcenter.vcha.CertificateInfo;
import com.vmware.vcenter.vcha.Cluster;
import com.vmware.vcenter.vcha.ClusterTypes;
import com.vmware.vcenter.vcha.CredentialsSpec;
import com.vmware.vcenter.vcha.VcCredentials;
import com.vmware.vcenter.vcha.cluster.Active;
import com.vmware.vcenter.vcha.cluster.ActiveTypes;
import com.vmware.vcenter.vcha.cluster.Mode;
import com.vmware.vcenter.vcha.cluster.Passive;
import com.vmware.vcenter.vcha.cluster.PassiveTypes;
import com.vmware.vcenter.vcha.cluster.Witness;
import com.vmware.vcenter.vcha.cluster.WitnessTypes;
import com.vmware.vim.binding.vim.Task;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.vapi.VapiConnectionManagerRegistry;
import com.vmware.vsphere.client.h5.vcha.model.CheckSpec;
import com.vmware.vsphere.client.h5.vcha.model.DeploySpec;
import com.vmware.vsphere.client.h5.vcha.model.FailoverSpec;
import com.vmware.vsphere.client.h5.vcha.model.ModeSpec;
import com.vmware.vsphere.client.h5.vcha.model.RedeploySpec;
import com.vmware.vsphere.client.h5.vcha.model.UndeploySpec;
import com.vmware.vsphere.client.h5.vcha.model.ValidateActiveNodeSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VchaMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(VchaMutationProvider.class);
    private final VapiConnectionManagerRegistry<String> _vapiConnectionManagerRegistry;

    public VchaMutationProvider(VapiConnectionManagerRegistry<String> vapiConnectionManagerRegistry) {
        this._vapiConnectionManagerRegistry = (VapiConnectionManagerRegistry)Preconditions.checkNotNull(vapiConnectionManagerRegistry, (Object)"vapiConnectionManagerRegistry is found null");
    }

    public OperationResult apply(ManagedObjectReference vcRef, ModeSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        try {
            String vcInstanceName = VcServiceUtil.getServiceName((String)vcRef.getServerGuid());
            String taskUid = ((Mode)this._vapiConnectionManagerRegistry.getService(Mode.class, (Object)vcInstanceName)).set_Task(spec.mode);
            this.fillupOperationResultWithTask(taskUid, result);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while calling vcha Mode.set() ", (Throwable)ex);
            result.error = ex;
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, FailoverSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        try {
            String vcInstanceName = VcServiceUtil.getServiceName((String)vcRef.getServerGuid());
            String taskUid = ((Cluster)this._vapiConnectionManagerRegistry.getService(Cluster.class, (Object)vcInstanceName)).failover_Task(spec.planned);
            this.fillupOperationResultWithTask(taskUid, result);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while calling vcha Cluster.failover() ", (Throwable)ex);
            result.error = ex;
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, UndeploySpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        try {
            String vcInstanceName = VcServiceUtil.getServiceName((String)vcRef.getServerGuid());
            ClusterTypes.UndeploySpec removeVchaSpec = new ClusterTypes.UndeploySpec();
            removeVchaSpec.setVcSpec(spec.credentialsSpec);
            removeVchaSpec.setForceDelete(Boolean.valueOf(spec.forceDeleteVms));
            String taskUid = ((Cluster)this._vapiConnectionManagerRegistry.getService(Cluster.class, (Object)vcInstanceName)).undeploy_Task(removeVchaSpec);
            this.fillupOperationResultWithTask(taskUid, result);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while calling vcha Cluster.undeploy() ", (Throwable)ex);
            result.error = ex;
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, DeploySpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        try {
            String vcInstanceName = VcServiceUtil.getServiceName((String)vcRef.getServerGuid());
            String taskUid = ((Cluster)this._vapiConnectionManagerRegistry.getService(Cluster.class, (Object)vcInstanceName)).deploy_Task(spec.deploySpec);
            this.fillupOperationResultWithTask(taskUid, result);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while calling vcha Cluster.deploy() ", (Throwable)ex);
            result.error = ex;
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, RedeploySpec redeploySpec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        try {
            String vcInstanceName = VcServiceUtil.getServiceName((String)vcRef.getServerGuid());
            String taskUid = "";
            if (redeploySpec.nodeRole.equals((Object)ClusterTypes.NodeRole.PASSIVE)) {
                taskUid = ((Passive)this._vapiConnectionManagerRegistry.getService(Passive.class, (Object)vcInstanceName)).redeploy_Task(redeploySpec.passiveRedeploySpec);
            } else if (redeploySpec.nodeRole.equals((Object)ClusterTypes.NodeRole.WITNESS)) {
                taskUid = ((Witness)this._vapiConnectionManagerRegistry.getService(Witness.class, (Object)vcInstanceName)).redeploy_Task(redeploySpec.witnessRedeploySpec);
            } else {
                throw new IllegalArgumentException("Illegal nodeRole argument. Only PASSIVE or WITNESS nodes can be redeployed.");
            }
            this.fillupOperationResultWithTask(taskUid, result);
        }
        catch (Exception ex) {
            _logger.error((Object)"Failed while calling vcha redeploy node() ", (Throwable)ex);
            result.error = ex;
        }
        return result;
    }

    public ValidationResult validate(ManagedObjectReference vcRef, CredentialsSpec spec) {
        ValidationResult result = new ValidationResult();
        result.entity = vcRef;
        try {
            String vcInstanceName = VcServiceUtil.getServiceName((String)vcRef.getServerGuid());
            ((VcCredentials)this._vapiConnectionManagerRegistry.getService(VcCredentials.class, (Object)vcInstanceName)).validate(spec);
        }
        catch (UnverifiedPeer ex) {
            if (ex.getData()._hasTypeNameOf(CertificateInfo.class)) {
                CertificateInfo info = (CertificateInfo)ex.getData()._convertTo(CertificateInfo.class);
                ex.setData((Structure)info);
            }
            _logger.warn((Object)"UnverifiedPeer exception caught while validating VC's credentials spec");
            result.error = ex;
        }
        catch (Exception ex) {
            _logger.error((Object)"Error while calling vcha VcCredentials.validate()", (Throwable)ex);
            result.error = ex;
        }
        return result;
    }

    public ValidationResult validate(ManagedObjectReference vcRef, CheckSpec checkSpec) {
        ValidationResult result;
        block4: {
            result = new ValidationResult();
            result.entity = vcRef;
            try {
                String vcInstanceName = VcServiceUtil.getServiceName((String)vcRef.getServerGuid());
                if (checkSpec.nodeRole.equals((Object)ClusterTypes.NodeRole.PASSIVE)) {
                    PassiveTypes.CheckResult checkResult = ((Passive)this._vapiConnectionManagerRegistry.getService(Passive.class, (Object)vcInstanceName)).check(checkSpec.passiveCheckSpec);
                    result.result = checkResult;
                    break block4;
                }
                if (checkSpec.nodeRole.equals((Object)ClusterTypes.NodeRole.WITNESS)) {
                    WitnessTypes.CheckResult checkResult = ((Witness)this._vapiConnectionManagerRegistry.getService(Witness.class, (Object)vcInstanceName)).check(checkSpec.witnessCheckSpec);
                    result.result = checkResult;
                    break block4;
                }
                throw new IllegalArgumentException("Invalid node role. PASSIVE and WITNESS are the only types for check");
            }
            catch (Exception ex) {
                _logger.error((Object)"Error while calling vcha check");
                result.error = ex;
            }
        }
        return result;
    }

    public ValidationResult validate(ManagedObjectReference vcRef, ValidateActiveNodeSpec spec) {
        ValidationResult result = new ValidationResult();
        result.entity = vcRef;
        try {
            String vcInstanceName = VcServiceUtil.getServiceName((String)vcRef.getServerGuid());
            ActiveTypes.Info activeInfo = ((Active)this._vapiConnectionManagerRegistry.getService(Active.class, (Object)vcInstanceName)).get(spec.credentialsSpec, Boolean.valueOf(spec.partialInfoRequired));
            result.result = activeInfo;
        }
        catch (UnverifiedPeer ex) {
            if (ex.getData()._hasTypeNameOf(CertificateInfo.class)) {
                CertificateInfo info = (CertificateInfo)ex.getData()._convertTo(CertificateInfo.class);
                ex.setData((Structure)info);
            }
            _logger.warn((Object)"UnverifiedPeer exception caught while validating or getting active node");
            result.error = ex;
        }
        catch (Exception ex) {
            _logger.error((Object)"Error while calling vcha active.get", (Throwable)ex);
            result.error = ex;
        }
        return result;
    }

    private void fillupOperationResultWithTask(String taskUid, OperationResult result) {
        ManagedObjectReference task = this.getTaskRef(taskUid);
        result.task = task;
        result.taskUid = ManagedObjectUtil.morefToString((ManagedObjectReference)task);
    }

    private ManagedObjectReference getTaskRef(String taskUid) {
        String[] taskUidParts = taskUid.split(":");
        String vmodl1TaskClassName = Task.class.getSimpleName();
        ManagedObjectReference task = new ManagedObjectReference(vmodl1TaskClassName, taskUidParts[0], taskUidParts[1]);
        return task;
    }
}

