/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.as.checkers;

import com.vmware.vide.vwcsdktools.Activator;
import com.vmware.vide.vwcsdktools.managers.MetadataTagProjectDataManager;
import com.vmware.vide.vwcsdktools.utils.Runners;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution2;

public class AddProblemValueToWhiteList
implements IMarkerResolution2 {
    private static ILog logger = Activator.getDefault().getLog();
    private final String whiteListName;
    private final String word;

    AddProblemValueToWhiteList(String whiteListName, String word) {
        this.whiteListName = whiteListName;
        this.word = word;
    }

    public String getLabel() {
        return String.format("Add %s to the list of expected values.", this.word);
    }

    public void run(IMarker marker) {
        IFile file = (IFile)marker.getResource();
        if (this.word != null) {
            MetadataTagProjectDataManager.INSTANCE.addWordToWhiteListFile(file, this.whiteListName, this.word);
            Set<IFile> files = this.getProblemFiles(file.getWorkspace().getRoot());
            for (IFile f : files) {
                Runners.runMetadataChecker(f);
            }
        }
    }

    public String getDescription() {
        return "Add the new value which is currently reported as invalid value to the list of expected values for the attribute. The value becomes valid after the value is added to the list.";
    }

    public Image getImage() {
        return null;
    }

    private Set<IFile> getProblemFiles(IWorkspaceRoot root) {
        IMarker[] markers;
        HashSet<IFile> files = new HashSet<IFile>();
        try {
            markers = root.findMarkers("com.vmware.vide.vwcsdktools.metadata_tag_problem_marker", false, 2);
        }
        catch (CoreException e) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", null, (Throwable)e));
            return files;
        }
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker m = iMarkerArray[n2];
            IFile file = (IFile)m.getResource();
            files.add(file);
            ++n2;
        }
        return files;
    }
}

