/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.as.checkers;

import com.vmware.vide.vwcsdktools.Activator;
import com.vmware.vide.vwcsdktools.managers.MetadataTagProjectDataManager;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class FixProblemValueFromWhiteList
implements IMarkerResolution2 {
    static ILog logger = Activator.getDefault().getLog();
    private final String whiteListName;
    private final String word;

    FixProblemValueFromWhiteList(String whiteListName, String word) {
        this.whiteListName = whiteListName;
        this.word = word;
    }

    public String getLabel() {
        return String.format("Replace %s with a valid value for attribute %s", this.word, this.whiteListName);
    }

    public void run(IMarker marker) {
        IFile file = (IFile)marker.getResource();
        IEditorPart part = null;
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            part = IDE.openEditor((IWorkbenchPage)page, (IMarker)marker);
        }
        catch (PartInitException partInitException) {}
        if (part instanceof ITextEditor) {
            ITextEditor editor = (ITextEditor)part;
            IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            if (doc == null) {
                return;
            }
            Range range = this.getReplaceRange(marker, doc);
            if (range == null) {
                return;
            }
            Set<String> whiteList = MetadataTagProjectDataManager.INSTANCE.getWhiteList(file.getProject(), this.whiteListName);
            LabelProvider labelProvider = new LabelProvider(){

                public String getText(Object element) {
                    return (String)element;
                }
            };
            ListContentProvider contentProvider = new ListContentProvider();
            String[] whiteListItems = whiteList.toArray(new String[whiteList.size()]);
            Shell shell = part.getSite().getShell();
            ListDialog dlg = new ListDialog(shell){

                protected Control createDialogArea(Composite container) {
                    Control control = super.createDialogArea(container);
                    TableViewer viewer = this.getTableViewer();
                    FixProblemValueFromWhiteList.this.customizeTableViewer(viewer);
                    return control;
                }
            };
            dlg.setBlockOnOpen(true);
            dlg.setTitle("Select Word");
            dlg.setMessage(String.format("Please select a value to replace %s.", this.word));
            dlg.setContentProvider((IStructuredContentProvider)contentProvider);
            dlg.setLabelProvider((ILabelProvider)labelProvider);
            dlg.setInput((Object)whiteListItems);
            if (dlg.open() != 0) {
                return;
            }
            Object[] objects = dlg.getResult();
            if (objects.length != 1) {
                ErrorDialog errDlg = new ErrorDialog(shell, "Information", "Please select one.", (IStatus)new Status(1, "com.vmware.vide.vwcsdktools", "Multiple items were selected. Please select only one item."), 0);
                errDlg.open();
                return;
            }
            String word = (String)objects[0];
            try {
                doc.replace(range.offset, range.length, word);
            }
            catch (BadLocationException e) {
                String msg = String.format("Failed to replace the value at [offset:%d, length:%d] with [%s] in [%s].", range.offset, range.length, word, file.getLocation().toOSString());
                logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", msg, (Throwable)e));
            }
            try {
                marker.delete();
            }
            catch (CoreException e) {
                logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", null, (Throwable)e));
            }
        }
    }

    public String getDescription() {
        return "Correct the value by selecting one from the list of expected values.";
    }

    public Image getImage() {
        return null;
    }

    private Range getReplaceRange(IMarker marker, IDocument doc) {
        Range range = null;
        int charStart = marker.getAttribute("charStart", -1);
        int charEnd = marker.getAttribute("charEnd", -1);
        if (charStart != -1 && charEnd != -1) {
            range = new Range(charStart, charEnd - charStart);
        }
        return range;
    }

    private void customizeTableViewer(TableViewer viewer) {
        viewer.setSorter(new ViewerSorter());
    }

    class ListContentProvider
    implements IStructuredContentProvider {
        ListContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }
    }

    class Range {
        int offset;
        int length;

        Range(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }
    }
}

