/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.as.checkers;

import com.vmware.vide.vwcsdktools.Activator;
import com.vmware.vide.vwcsdktools.as.checkers.MetadataTagCheckResult;
import com.vmware.vide.vwcsdktools.as.checkers.MetadataTagChecker;
import com.vmware.vide.vwcsdktools.as.checkers.MetadataTagProblemType;
import com.vmware.vide.vwcsdktools.as.model.MetadataTag;
import com.vmware.vide.vwcsdktools.as.model.MetadataTagParameter;
import com.vmware.vide.vwcsdktools.as.parser.AsToken;
import com.vmware.vide.vwcsdktools.as.parser.StringLiteralToken;
import com.vmware.vide.vwcsdktools.managers.CheckTypeRule;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;

public class MetadataTagRemoteJavaClassParameterChecker
extends MetadataTagChecker {
    private static ILog logger = Activator.getDefault().getLog();
    MetadataTagParameter parameter;

    MetadataTagRemoteJavaClassParameterChecker(CheckTypeRule rule, IFile file, MetadataTag tag, MetadataTagParameter param) {
        super(rule, file, tag);
        this.parameter = param;
    }

    @Override
    public MetadataTagCheckResult run() {
        IProject project = this.file.getProject();
        MetadataTagCheckResult result = new MetadataTagCheckResult();
        AsToken token = this.parameter.getValue();
        String value = null;
        if (!token.isStringLiteral()) {
            String msg = String.format("A double-quoted string is expected for this parameter.", new Object[0]);
            result.add(MetadataTagProblemType.NOT_SUPPORTED_TYPE, this.rule, this.file, this.tag, this.parameter, msg);
            return result;
        }
        value = ((StringLiteralToken)token).getString();
        try {
            IProject[] projects = project.getReferencedProjects();
            if (projects.length != 0) {
                List<IJavaProject> javaProjects = this.getJavaProjects(projects);
                if (!javaProjects.isEmpty()) {
                    IType t = null;
                    for (IJavaProject javaProject : javaProjects) {
                        t = javaProject.findType(value);
                        if (t == null) continue;
                    }
                    if (t == null) {
                        String msg = String.format("No remote class [%s].", value);
                        result.add(MetadataTagProblemType.NO_REMOTE_CLASS, this.rule, this.file, this.tag, this.parameter, msg);
                    }
                } else {
                    String msg = "No Java project is referenced in this Flex project.";
                    logger.log((IStatus)new Status(2, "com.vmware.vide.vwcsdktools", msg));
                    result.add(MetadataTagProblemType.NO_JAVA_PROJECT, this.rule, this.file, this.tag, this.parameter, msg);
                }
            } else {
                String msg = "No project was referenced by this Flex project.";
                logger.log((IStatus)new Status(2, "com.vmware.vide.vwcsdktools", msg));
                result.add(MetadataTagProblemType.NO_JAVA_PROJECT, this.rule, this.file, this.tag, this.parameter, msg);
            }
        }
        catch (CoreException e) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", null, (Throwable)e));
        }
        return result;
    }

    private List<IJavaProject> getJavaProjects(IProject[] projects) {
        ArrayList<IJavaProject> javaProjects = new ArrayList<IJavaProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (this.isJavaProject(project)) {
                    javaProjects.add(JavaCore.create((IProject)project));
                }
            }
            catch (CoreException e) {
                logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", null, (Throwable)e));
            }
            ++n2;
        }
        return javaProjects;
    }

    private boolean isJavaProject(IProject p) throws CoreException {
        String[] stringArray = p.getDescription().getNatureIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            if (n3.equals("org.eclipse.jdt.core.javanature")) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

