/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.as.parser;

import com.vmware.vide.vwcsdktools.as.parser.BufferError;
import com.vmware.vide.vwcsdktools.as.parser.LineColumnRecorder;
import com.vmware.vide.vwcsdktools.as.parser.RingBuffer;
import java.io.IOException;
import java.io.InputStreamReader;

public class BufferedCharReader {
    private final InputStreamReader isr;
    private final RingBuffer rb;
    private final LineColumnRecorder lineRecorder;

    BufferedCharReader(InputStreamReader isr, int initialLine, int initialColumn) {
        this.isr = isr;
        this.rb = new RingBuffer(1024);
        this.lineRecorder = new LineColumnRecorder(initialLine, initialColumn);
    }

    int getChar() throws IOException, BufferError {
        int cc = -1;
        if (this.rb.have()) {
            cc = this.rb.get();
        } else {
            cc = this.isr.read();
            this.rb.put(cc);
            this.rb.get();
        }
        this.lineRecorder.forward(cc);
        return cc;
    }

    int peekChar() throws IOException, BufferError {
        if (this.rb.have()) {
            return this.rb.at();
        }
        int cc = this.isr.read();
        this.rb.put(cc);
        return cc;
    }

    void putCharBack() throws BufferError {
        this.rb.back();
        this.lineRecorder.backward();
    }

    int getLine() {
        return this.lineRecorder.getLine();
    }

    int getColumn() {
        return this.lineRecorder.getColumn();
    }

    void close() throws IOException {
        if (this.isr != null) {
            this.isr.close();
        }
    }

    public int peekChar(int n) throws IOException, BufferError {
        if (this.rb.have(n)) {
            return this.rb.at(n);
        }
        int cc = -1;
        do {
            cc = this.isr.read();
            this.rb.put(cc);
            if (!this.rb.have(n)) continue;
            return this.rb.at(n);
        } while (cc != -1);
        return cc;
    }
}

