/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.as.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum Keyword {
    BREAK("break"),
    CASE("case"),
    CONTINUE("continue"),
    DEFAULT("default"),
    DEFAULT_XML_NAMESPACE("default xml namespace"),
    WHILE("while"),
    DO("do"),
    ELSE("else"),
    FOR("for"),
    IN("in"),
    FOR_EACH("for each"),
    EACH("each"),
    IF("if"),
    RETURN("return"),
    SUPER("super"),
    SWITCH("switch"),
    THROW("throw"),
    TRY("try"),
    CATCH("catch"),
    FINALLY("finally"),
    WITH("with"),
    CLASS("class"),
    CONST("const"),
    EXTENDS("extends"),
    FUNCTION("function"),
    FUNCTION_GET("function get"),
    FUNCTION_SET("function set"),
    GET("get"),
    SET("set"),
    IMPLEMENTS("implements"),
    INTERFACE("interface"),
    PACKAGE("package"),
    VAR("var"),
    PRIVATE("private"),
    PROTECTED("protected"),
    PUBLIC("public"),
    USE("use"),
    USE_NAMESPACE("use namespace"),
    IMPORT("import"),
    INCLUDE("include"),
    AS("as"),
    DELETE("delete"),
    NEW("new"),
    INSTANCEOF("instanceof"),
    IS("is"),
    TYPEOF("typeof"),
    VOID("void"),
    FALSE("false"),
    TRUE("true"),
    NULL("null"),
    THIS("this"),
    FINAL("final"),
    INTERNAL("internal"),
    NATIVE("native"),
    STATIC("static"),
    DYNAMIC("dynamic"),
    OVERRIDE("override"),
    NAMESPACE("namespace");

    private static Set<String> names;
    private static Set<String> combinations;
    private static Set<String> weak;
    private static Map<String, Keyword> nameTable;
    private String name;

    static {
        names = new HashSet<String>();
        combinations = new HashSet<String>();
        weak = new HashSet<String>();
        nameTable = new HashMap<String, Keyword>();
        Keyword[] keywordArray = Keyword.values();
        int n = keywordArray.length;
        int n2 = 0;
        while (n2 < n) {
            Keyword k = keywordArray[n2];
            names.add(k.getName());
            nameTable.put(k.getName(), k);
            ++n2;
        }
        combinations.add(Keyword.EACH.name);
        combinations.add(Keyword.GET.name);
        combinations.add(Keyword.SET.name);
        combinations.add(Keyword.NAMESPACE.name);
        weak.add(Keyword.NAMESPACE.name);
        weak.add(Keyword.DYNAMIC.name);
        weak.add(Keyword.FINAL.name);
        weak.add(Keyword.INTERNAL.name);
        weak.add(Keyword.NATIVE.name);
        weak.add(Keyword.OVERRIDE.name);
        weak.add(Keyword.STATIC.name);
    }

    private Keyword(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    static boolean isStrongKeyword(String name) {
        return names.contains(name) && !weak.contains(name) && !combinations.contains(name);
    }

    static boolean isCombinationKeyword(String name) {
        return combinations.contains(name);
    }

    static boolean isKeyword(String name) {
        return names.contains(name);
    }

    static Keyword getKeyword(String name) {
        return nameTable.get(name);
    }
}

