/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.as.parser;

import java.util.Arrays;

public class LineColumnRecorder {
    private int column;
    private int line;
    private int[] columns;
    private static int INCREASE_SIZE = 256;

    LineColumnRecorder(int initialLine, int initialColumn) {
        this.column = initialColumn;
        this.line = initialLine;
        this.columns = new int[INCREASE_SIZE];
    }

    LineColumnRecorder() {
        this(0, 0);
    }

    void forward(int cc) {
        ++this.column;
        if (cc == 10) {
            if (this.line >= this.columns.length) {
                this.columns = Arrays.copyOf(this.columns, this.columns.length + INCREASE_SIZE);
            }
            this.columns[this.line] = this.column;
            this.column = 0;
            ++this.line;
        }
    }

    void backward() {
        --this.column;
        if (this.column < 0) {
            --this.line;
            this.column = this.columns[this.line];
        }
    }

    int getLine() {
        return this.line;
    }

    int getColumn() {
        return this.column;
    }
}

