/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.managers;

import java.util.HashMap;
import java.util.Map;
import javax.tools.Diagnostic;

public enum DiagnosticLevel {
    IGNORE(null),
    WARNING(Diagnostic.Kind.WARNING),
    ERROR(Diagnostic.Kind.ERROR);

    private static Map<String, DiagnosticLevel> nameMap;
    private final Diagnostic.Kind kind;

    static {
        nameMap = new HashMap<String, DiagnosticLevel>();
        nameMap.put("Ignore", IGNORE);
        nameMap.put("Warning", WARNING);
        nameMap.put("Error", ERROR);
    }

    private DiagnosticLevel(Diagnostic.Kind k) {
        this.kind = k;
    }

    public String getName() {
        return String.valueOf(this.toString().charAt(0)) + this.toString().substring(1).toLowerCase();
    }

    public Diagnostic.Kind getKind() {
        return this.kind;
    }

    public static DiagnosticLevel parse(String levelName) {
        return nameMap.get(levelName);
    }
}

