/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.ui;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class DiagnosticLevelComboFieldEditor
extends FieldEditor {
    private final String typeText;
    private Label typeLabel;
    private Combo fCombo;
    private String fValue;
    private final String[][] fEntryNamesAndValues;

    public DiagnosticLevelComboFieldEditor(String name, String labelText, String typeText, String[][] entries, Composite parent) {
        this.init(name, labelText);
        this.typeText = typeText;
        this.fEntryNamesAndValues = entries;
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        int left = numColumns;
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = 1;
            --left;
        }
        ((GridData)this.typeLabel.getLayoutData()).horizontalSpan = 1;
        ((GridData)this.fCombo.getLayoutData()).horizontalSpan = 1;
    }

    public int getNumberOfControls() {
        return 3;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        control = this.getLabelControl2(parent);
        gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        control = this.getComboBoxControl(parent);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        control.setLayoutData((Object)gd);
        control.setFont(parent.getFont());
    }

    protected void doLoad() {
        this.updateComboForValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.updateComboForValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    protected void doStore() {
        if (this.fValue == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.fValue);
    }

    private Control getLabelControl2(Composite parent) {
        if (this.typeLabel == null) {
            this.typeLabel = new Label(parent, 131072);
            this.typeLabel.setFont(parent.getFont());
            String text = this.typeText;
            if (text != null) {
                this.typeLabel.setText(text);
            }
            this.typeLabel.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    DiagnosticLevelComboFieldEditor.this.typeLabel = null;
                }
            });
        }
        return this.typeLabel;
    }

    private Combo getComboBoxControl(Composite parent) {
        if (this.fCombo == null) {
            this.fCombo = new Combo(parent, 8);
            this.fCombo.setFont(parent.getFont());
            int i = 0;
            while (i < this.fEntryNamesAndValues.length) {
                this.fCombo.add(this.fEntryNamesAndValues[i][0], i);
                ++i;
            }
            this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    String oldValue = DiagnosticLevelComboFieldEditor.this.fValue;
                    String name = DiagnosticLevelComboFieldEditor.this.fCombo.getText();
                    DiagnosticLevelComboFieldEditor.this.fValue = DiagnosticLevelComboFieldEditor.this.getValueForName(name);
                    DiagnosticLevelComboFieldEditor.this.setPresentsDefaultValue(false);
                    DiagnosticLevelComboFieldEditor.this.fireValueChanged("field_editor_value", oldValue, DiagnosticLevelComboFieldEditor.this.fValue);
                }
            });
        }
        return this.fCombo;
    }

    private String getValueForName(String name) {
        int i = 0;
        while (i < this.fEntryNamesAndValues.length) {
            String[] entry = this.fEntryNamesAndValues[i];
            if (name.equals(entry[0])) {
                return entry[1];
            }
            ++i;
        }
        return this.fEntryNamesAndValues[0][0];
    }

    private void updateComboForValue(String value) {
        this.fValue = value;
        int i = 0;
        while (i < this.fEntryNamesAndValues.length) {
            if (value.equals(this.fEntryNamesAndValues[i][1])) {
                this.fCombo.setText(this.fEntryNamesAndValues[i][0]);
                return;
            }
            ++i;
        }
        if (this.fEntryNamesAndValues.length > 0) {
            this.fValue = this.fEntryNamesAndValues[0][1];
            this.fCombo.setText(this.fEntryNamesAndValues[0][0]);
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getLabelControl2(parent).setEnabled(enabled);
        this.getComboBoxControl(parent).setEnabled(enabled);
    }
}

