/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.ui;

import com.vmware.vide.vwcsdktools.model.IPropertyChangedListener;
import com.vmware.vide.vwcsdktools.model.ProxiedPreferenceStore;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbenchPropertyPage;

public abstract class FieldEditorOverlayPage
extends FieldEditorPreferencePage
implements IWorkbenchPropertyPage {
    public static final String USEPROJECT = "useproject";
    private ImageDescriptor image;
    private IAdaptable element;
    private Button useProjectButton;
    private Link configureLink;
    private final List<FieldEditor> editors = new ArrayList<FieldEditor>();
    private IPreferenceStore overlayStore;
    private String ownerId;

    public FieldEditorOverlayPage(int style) {
        super(style);
    }

    public FieldEditorOverlayPage(String title, int style) {
        super(title, style);
    }

    public FieldEditorOverlayPage(String title, ImageDescriptor image, int style) {
        super(title, image, style);
        this.image = image;
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }

    public boolean isPropertyPage() {
        return this.element != null;
    }

    protected void createFieldEditors() {
    }

    protected Control createContents(Composite parent) {
        if (this.isPropertyPage()) {
            this.createSelectionGroup(parent);
        }
        return super.createContents(parent);
    }

    private void createSelectionGroup(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.useProjectButton = new Button(comp, 32);
        this.useProjectButton.setText("Enable project specific settings");
        this.useProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FieldEditorOverlayPage.this.configureLink.setEnabled(!FieldEditorOverlayPage.this.useProjectButton.getSelection());
                FieldEditorOverlayPage.this.updateFieldEditors();
            }
        });
        this.useProjectButton.setLayoutData((Object)new GridData(768));
        this.configureLink = new Link(comp, 2048);
        this.configureLink.setText("<A>Configure Workspace Settings ...</A>");
        this.configureLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FieldEditorOverlayPage.this.configureWorkspaceSettings();
            }
        });
        this.configureLink.setLayoutData((Object)new GridData(3));
        try {
            IResource res = this.getResource(this.element);
            if (res == null) {
                throw new MissingResourceException("Bad element was selected.", "FieldEditorOverlayPage", null);
            }
            String use = res.getPersistentProperty(new QualifiedName(this.ownerId, USEPROJECT));
            if (Boolean.toString(true).equals(use)) {
                this.useProjectButton.setSelection(true);
                this.configureLink.setEnabled(false);
            } else {
                this.useProjectButton.setSelection(false);
                this.configureLink.setEnabled(true);
            }
        }
        catch (CoreException coreException) {
            this.useProjectButton.setSelection(false);
            this.configureLink.setEnabled(true);
        }
    }

    protected IResource getResource(IAdaptable element) {
        if (element instanceof IResource) {
            return (IResource)element;
        }
        return (IResource)element.getAdapter(IResource.class);
    }

    protected void addField(FieldEditor editor) {
        this.editors.add(editor);
        super.addField(editor);
    }

    private void updateFieldEditors() {
        boolean enabled = this.useProjectButton.getSelection();
        this.updateFieldEditors(enabled);
    }

    protected void updateFieldEditors(boolean enabled) {
        Composite parent = this.getFieldEditorParent();
        for (FieldEditor editor : this.editors) {
            editor.setEnabled(enabled, parent);
        }
    }

    public void createControl(Composite parent) {
        if (this.isPropertyPage()) {
            this.ownerId = this.getOwnerId();
            IResource res = this.getResource(this.element);
            if (res == null) {
                throw new MissingResourceException("Bad element was selected.", "FieldEditorOverlayPage", null);
            }
            this.overlayStore = new ProxiedPreferenceStore(res, super.getPreferenceStore(), this.ownerId);
            IPropertyChangedListener listener = this.getPropertyChangedListener();
            if (listener != null) {
                ((ProxiedPreferenceStore)this.overlayStore).addPropertyChangedListener(listener);
            }
        }
        super.createControl(parent);
        if (this.isPropertyPage()) {
            this.updateFieldEditors();
        }
    }

    protected abstract String getOwnerId();

    public IPreferenceStore getPreferenceStore() {
        if (this.isPropertyPage()) {
            return this.overlayStore;
        }
        return super.getPreferenceStore();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (result && this.isPropertyPage()) {
            IResource resource = this.getResource(this.element);
            try {
                String value = this.useProjectButton.getSelection() ? Boolean.toString(true) : Boolean.toString(false);
                resource.setPersistentProperty(new QualifiedName(this.ownerId, USEPROJECT), value);
            }
            catch (CoreException coreException) {}
        }
        return result;
    }

    public void performDefaults() {
        if (this.isPropertyPage()) {
            boolean b = this.getDefaultUseProject();
            this.useProjectButton.setSelection(b);
            this.configureLink.setEnabled(!b);
            this.updateFieldEditors();
        }
        super.performDefaults();
    }

    protected boolean getDefaultUseProject() {
        return false;
    }

    protected IPropertyChangedListener getPropertyChangedListener() {
        return null;
    }

    protected void configureWorkspaceSettings() {
        try {
            IPreferencePage page = (IPreferencePage)((Object)((Object)this)).getClass().newInstance();
            page.setTitle(this.getTitle());
            page.setImageDescriptor(this.image);
            this.showPreferencePage(this.ownerId, page);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    protected void showPreferencePage(String id, IPreferencePage page) {
        PreferenceNode targetNode = new PreferenceNode(id, page);
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot((IPreferenceNode)targetNode);
        final PreferenceDialog dialog = new PreferenceDialog(this.getControl().getShell(), manager);
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable((IPreferenceNode)targetNode){
            private final /* synthetic */ IPreferenceNode val$targetNode;
            {
                this.val$targetNode = iPreferenceNode;
            }

            @Override
            public void run() {
                dialog.create();
                dialog.setMessage(this.val$targetNode.getLabelText());
                dialog.open();
            }
        });
    }

    protected List<FieldEditor> getFieldEditors() {
        return this.editors;
    }
}

