/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.ui;

import com.vmware.vide.vwcsdktools.Activator;
import com.vmware.vide.vwcsdktools.managers.CheckTypeRule;
import com.vmware.vide.vwcsdktools.managers.DiagnosticLevel;
import com.vmware.vide.vwcsdktools.managers.MetadataTagProjectDataManager;
import com.vmware.vide.vwcsdktools.utils.Names;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MetadataTagDiagnosticLevelPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String STORE_KEY = "store-key";
    private List<Combo> levels;

    public MetadataTagDiagnosticLevelPage() {
    }

    public MetadataTagDiagnosticLevelPage(String title) {
        super(title);
    }

    public MetadataTagDiagnosticLevelPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.createHeader(comp);
        this.createLevels(comp);
        return comp;
    }

    private void createHeader(Composite comp) {
        Label l = new Label(comp, 0);
        l.setText("Tag");
        l = new Label(comp, 0);
        l.setText("Parameter");
        l = new Label(comp, 0);
        l.setText("Type");
        l = new Label(comp, 0);
        l.setText("Level");
    }

    private void createLevels(Composite comp) {
        this.levels = new ArrayList<Combo>();
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        for (Map.Entry<String, Map<String, List<CheckTypeRule>>> entry : MetadataTagProjectDataManager.INSTANCE.getWorkspaceCheckRuleTable().entrySet()) {
            String tagName = entry.getKey();
            for (Map.Entry<String, List<CheckTypeRule>> param : entry.getValue().entrySet()) {
                String paramName = param.getKey();
                for (CheckTypeRule rule : param.getValue()) {
                    String key = Names.getPrefKeyForDiagnosticLevel(tagName, paramName, rule.getType().name());
                    Label l1 = new Label(comp, 0);
                    l1.setText(tagName);
                    Label l2 = new Label(comp, 0);
                    l2.setText(paramName);
                    Label l3 = new Label(comp, 0);
                    l3.setText(rule.getType().name());
                    Combo combo = new Combo(comp, 8);
                    String[] items = new String[]{DiagnosticLevel.IGNORE.getName(), DiagnosticLevel.WARNING.getName(), DiagnosticLevel.ERROR.getName()};
                    combo.setItems(items);
                    int index = this.getLevelIndex(items, store.getString(key));
                    combo.select(index);
                    combo.setData(STORE_KEY, (Object)key);
                    this.levels.add(combo);
                }
            }
        }
    }

    private int getLevelIndex(String[] items, String level) {
        int i = 0;
        while (i < items.length) {
            if (level.equals(items[i])) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public boolean performOk() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        for (Combo combo : this.levels) {
            String[] items = combo.getItems();
            String levelName = items[combo.getSelectionIndex()];
            store.setValue((String)combo.getData(STORE_KEY), levelName);
        }
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        for (Combo combo : this.levels) {
            String defaultLevel = store.getDefaultString((String)combo.getData(STORE_KEY));
            combo.select(this.getLevelIndex(combo.getItems(), defaultLevel));
        }
    }
}

