/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.ui;

import com.vmware.vide.vwcsdktools.Activator;
import com.vmware.vide.vwcsdktools.managers.CheckTypeRule;
import com.vmware.vide.vwcsdktools.managers.DiagnosticLevel;
import com.vmware.vide.vwcsdktools.managers.MetadataTagProjectDataManager;
import com.vmware.vide.vwcsdktools.utils.Names;
import com.vmware.vide.vwcsdktools.utils.Property;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class MetadataTagDiagnosticLevelPreferencePage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private static final String STORE_KEY = "metadata-tag-check-diagnostic-level-key";
    private List<Combo> levels;
    private Composite projectGroup;
    private UseProjectSettingChangeListener listener;

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        this.createHeader(comp);
        this.createLevels(comp);
        this.projectGroup = comp;
        this.updateProjectGroup();
        this.listener = new UseProjectSettingChangeListener();
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.listener);
        return comp;
    }

    private void createHeader(Composite comp) {
        Label l = new Label(comp, 0);
        l.setText("Tag");
        l = new Label(comp, 0);
        l.setText("Parameter");
        l = new Label(comp, 0);
        l.setText("Type");
        l = new Label(comp, 0);
        l.setText("Level");
    }

    private void createLevels(Composite comp) {
        this.levels = new ArrayList<Combo>();
        IProject project = this.getProject();
        if (project == null) {
            return;
        }
        for (Map.Entry<String, Map<String, List<CheckTypeRule>>> entry : MetadataTagProjectDataManager.INSTANCE.getProjectCheckRuleTable(project).entrySet()) {
            String tagName = entry.getKey();
            for (Map.Entry<String, List<CheckTypeRule>> param : entry.getValue().entrySet()) {
                String paramName = param.getKey();
                for (CheckTypeRule rule : param.getValue()) {
                    String key = Names.getPrefKeyForDiagnosticLevel(tagName, paramName, rule.getType().name());
                    Label l1 = new Label(comp, 0);
                    l1.setText(tagName);
                    Label l2 = new Label(comp, 0);
                    l2.setText(paramName);
                    Label l3 = new Label(comp, 0);
                    l3.setText(rule.getType().name());
                    Combo combo = new Combo(comp, 8);
                    String[] items = new String[]{DiagnosticLevel.IGNORE.getName(), DiagnosticLevel.WARNING.getName(), DiagnosticLevel.ERROR.getName()};
                    combo.setItems(items);
                    int index = this.getLevelIndex(items, this.getDiagnosticLevel(rule, key));
                    combo.select(index);
                    combo.setData(STORE_KEY, (Object)key);
                    this.levels.add(combo);
                }
            }
        }
    }

    private String getDiagnosticLevel(CheckTypeRule rule, String key) {
        String level = Property.getMetadataTagCheckDiagnosticLevel((IResource)this.getProject(), key);
        if (level == null) {
            level = rule.getLevel().getName();
        }
        return level;
    }

    private int getLevelIndex(String[] items, String level) {
        int i = 0;
        while (i < items.length) {
            if (level.equals(items[i])) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private IProject getProject() {
        Object o = this.getElement().getAdapter(IProject.class);
        if (o instanceof IProject) {
            return (IProject)o;
        }
        return null;
    }

    private boolean getUseProjectSettings() {
        IProject project = this.getProject();
        if (project != null) {
            return Property.getBoolean((IResource)project, "metadata-tag-checker-use-project-settings");
        }
        return false;
    }

    private void updateProjectGroup() {
        boolean b = this.getUseProjectSettings();
        Control[] controlArray = this.projectGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Label) {
                Label label = (Label)control;
                label.setEnabled(b);
            } else if (control instanceof Combo) {
                Combo combo = (Combo)control;
                combo.setEnabled(b);
            }
            ++n2;
        }
    }

    protected void performDefaults() {
        if (!this.getUseProjectSettings()) {
            return;
        }
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        for (Combo combo : this.levels) {
            String defaultLevel = store.getDefaultString((String)combo.getData(STORE_KEY));
            combo.select(this.getLevelIndex(combo.getItems(), defaultLevel));
        }
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.getUseProjectSettings()) {
            IProject project = this.getProject();
            Map<String, Map<String, List<CheckTypeRule>>> table = MetadataTagProjectDataManager.INSTANCE.getProjectCheckRuleTable(project);
            for (Combo combo : this.levels) {
                String levelName = combo.getItems()[combo.getSelectionIndex()];
                String key = (String)combo.getData(STORE_KEY);
                Property.setMetadataTagCheckDiagnosticLevel((IResource)project, key, levelName);
                String[] names = Names.parseDiagnosticLevelKey(key);
                if (names == null || names.length != 4) continue;
                for (CheckTypeRule rule : table.get(names[1]).get(names[2])) {
                    if (!rule.getType().name().equals(names[3])) continue;
                    rule.setLevel(DiagnosticLevel.parse(levelName));
                }
            }
        }
        return super.performOk();
    }

    public void dispose() {
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.listener);
    }

    class UseProjectSettingChangeListener
    implements IPropertyChangeListener {
        UseProjectSettingChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            String name = event.getProperty();
            if (!name.equals("metadata-tag-checker-project-settings-switch")) {
                return;
            }
            String value = (String)event.getNewValue();
            if (!value.startsWith(String.valueOf(MetadataTagDiagnosticLevelPreferencePage.this.getProject().getName()) + ":::")) {
                return;
            }
            MetadataTagDiagnosticLevelPreferencePage.this.updateProjectGroup();
        }
    }
}

