/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.ui;

import com.vmware.vide.vwcsdktools.managers.MetadataTagProjectDataManager;
import com.vmware.vide.vwcsdktools.ui.ISharedPage;
import com.vmware.vide.vwcsdktools.ui.WhiteListContentProvider;
import com.vmware.vide.vwcsdktools.ui.WhiteListLabelProvider;
import com.vmware.vide.vwcsdktools.ui.WhiteListWordsContentProvider;
import com.vmware.vide.vwcsdktools.ui.WordInputDialog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;

public class WhiteListEditArea {
    private final int MAX_HEIGHT = 500;
    private final List<Control> projectGroup = new ArrayList<Control>();
    private final ISharedPage sharedPage;
    private ListViewer wordsViewer;
    private ListViewer listNameViewer;
    private Button includeButton;
    private Button excludeButton;
    private Button removeButton;
    private Button editButton;
    private Button addButton;

    WhiteListEditArea(Composite composite, ISharedPage sharedPage) {
        this.sharedPage = sharedPage;
        this.createWhiteListEditArea(composite);
    }

    void createWhiteListEditArea(Composite comp) {
        Label l = new Label(comp, 64);
        GridData gdl = new GridData(256);
        gdl.widthHint = 500;
        l.setLayoutData((Object)gdl);
        l.setText("This tool checks the value of attributes in metadata tags such as [Event(name=\" ...\", type=\"...\")] or [ResponseHandler(name=\"...\")] against a list of expected values and reports errors that would not be easy to catch at runtime.  The default values are the ones published in the vSphere Web Client SDK.  You can extend this list to add your own type or name attributes if necessary.");
        this.projectGroup.add((Control)l);
        Composite area = new Composite(comp, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        area.setLayout((Layout)layout);
        area.setLayoutData((Object)new GridData(768));
        SashForm sash = new SashForm(area, 256);
        sash.setLayoutData((Object)new GridData(1808));
        Composite whiteListComp = new Composite((Composite)sash, 0);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        whiteListComp.setLayout((Layout)layout);
        whiteListComp.setLayoutData((Object)new GridData(1808));
        Composite wordComp = new Composite((Composite)sash, 0);
        layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        wordComp.setLayout((Layout)layout);
        wordComp.setLayoutData((Object)new GridData(1808));
        sash.setWeights(new int[]{1, 4});
        Label label = new Label(whiteListComp, 0);
        label.setText("Attributes");
        this.projectGroup.add((Control)label);
        ListViewer viewer = new ListViewer(whiteListComp, 2820);
        GridData data = new GridData(1808);
        viewer.getList().setLayoutData((Object)data);
        viewer.setLabelProvider((IBaseLabelProvider)new WhiteListLabelProvider());
        viewer.setContentProvider((IContentProvider)new WhiteListContentProvider());
        viewer.setInput(this.sharedPage.getWhiteLists());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection select = event.getSelection();
                if (select instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)select;
                    Iterator it = ss.iterator();
                    if (it.hasNext()) {
                        String name = (String)it.next();
                        WhiteListEditArea.this.wordsViewer.setInput(WhiteListEditArea.this.sharedPage.getWhiteLists().get(name));
                    }
                } else {
                    WhiteListEditArea.this.wordsViewer.setInput((Object)WhiteListEditArea.this.sharedPage.getWhiteLists().keySet().iterator().next());
                }
                WhiteListEditArea.this.updateButtons();
            }
        });
        this.projectGroup.add(viewer.getControl());
        this.listNameViewer = viewer;
        Composite dummyComp = new Composite(whiteListComp, 0);
        dummyComp.setLayout((Layout)new GridLayout());
        new Button(dummyComp, 0).setVisible(false);
        label = new Label(wordComp, 0);
        label.setText("Expected values");
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
        this.projectGroup.add((Control)label);
        viewer = new ListViewer(wordComp, 2818);
        gd = new GridData(1808);
        viewer.getList().setLayoutData((Object)gd);
        viewer.setLabelProvider((IBaseLabelProvider)new WhiteListLabelProvider());
        viewer.setContentProvider((IContentProvider)new WhiteListWordsContentProvider());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WhiteListEditArea.this.updateButtons();
            }
        });
        this.wordsViewer = viewer;
        this.projectGroup.add(viewer.getControl());
        Composite buttonsComp = new Composite(wordComp, 0);
        buttonsComp.setLayout((Layout)new GridLayout(6, true));
        gd = new GridData(1);
        buttonsComp.setLayoutData((Object)gd);
        Button b = new Button(buttonsComp, 8);
        b.setText("Add&...");
        gd = new GridData(768);
        b.setLayoutData((Object)gd);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WordInputDialog dlg = new WordInputDialog(WhiteListEditArea.this.getShell(), "");
                if (dlg.open() == 0) {
                    String word = dlg.getValue();
                    String name = WhiteListEditArea.this.getSelectedName();
                    Set<String> words = WhiteListEditArea.this.sharedPage.getWhiteLists().get(name);
                    words.add(word);
                    WhiteListEditArea.this.wordsViewer.setInput(words);
                    WhiteListEditArea.this.selectWord(word);
                    WhiteListEditArea.this.updateButtons();
                }
            }
        });
        this.addButton = b;
        this.projectGroup.add((Control)b);
        b = new Button(buttonsComp, 8);
        b.setText("&Edit...");
        gd = new GridData(768);
        b.setLayoutData((Object)gd);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String word = WhiteListEditArea.this.getSelectedWords()[0];
                WordInputDialog dlg = new WordInputDialog(WhiteListEditArea.this.getShell(), word);
                if (dlg.open() == 0) {
                    String newWord = dlg.getValue();
                    if (newWord.equals(word)) {
                        return;
                    }
                    String name = WhiteListEditArea.this.getSelectedName();
                    Set<String> words = WhiteListEditArea.this.sharedPage.getWhiteLists().get(name);
                    words.remove(word);
                    words.add(newWord);
                    WhiteListEditArea.this.wordsViewer.setInput(words);
                    WhiteListEditArea.this.selectWord(newWord);
                    WhiteListEditArea.this.updateButtons();
                }
            }
        });
        this.editButton = b;
        this.projectGroup.add((Control)b);
        b = new Button(buttonsComp, 8);
        b.setText("De&lete");
        gd = new GridData(768);
        b.setLayoutData((Object)gd);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = WhiteListEditArea.this.getSelectedName();
                Set<String> words = WhiteListEditArea.this.sharedPage.getWhiteLists().get(name);
                String[] stringArray = WhiteListEditArea.this.getSelectedWords();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String word = stringArray[n2];
                    words.remove(word);
                    ++n2;
                }
                WhiteListEditArea.this.wordsViewer.setInput(words);
                WhiteListEditArea.this.updateButtons();
            }
        });
        this.removeButton = b;
        this.projectGroup.add((Control)b);
        b = new Button(buttonsComp, 8);
        b.setText("&Import...");
        gd = new GridData(768);
        b.setLayoutData((Object)gd);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = WhiteListEditArea.this.getSelectedName();
                String msg = String.format("Select .as files to import their metadata tag attributes values.", new Object[0]);
                ResourceSelectionDialog dlg = new ResourceSelectionDialog(WhiteListEditArea.this.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), msg);
                dlg.setTitle("Select ActionScripts");
                if (dlg.open() == 0) {
                    Object[] objs = dlg.getResult();
                    List files = WhiteListEditArea.this.collectActionScripts(objs);
                    Set<String> words = WhiteListEditArea.this.sharedPage.getProject() != null ? MetadataTagProjectDataManager.INSTANCE.getWhiteListWords(WhiteListEditArea.this.sharedPage.getProject(), files, name) : MetadataTagProjectDataManager.INSTANCE.getWhiteListWords(files, name);
                    WhiteListEditArea.this.sharedPage.getWhiteLists().get(name).addAll(words);
                    WhiteListEditArea.this.wordsViewer.setInput(WhiteListEditArea.this.sharedPage.getWhiteLists().get(name));
                    WhiteListEditArea.this.updateButtons();
                }
            }
        });
        this.includeButton = b;
        this.projectGroup.add((Control)b);
        b = new Button(buttonsComp, 8);
        b.setText("E&xclude...");
        gd = new GridData(768);
        b.setLayoutData((Object)gd);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = WhiteListEditArea.this.getSelectedName();
                String msg = String.format("Please select ActionScript files providing expected values to be removed from the attribute [%s].", name);
                ResourceSelectionDialog dlg = new ResourceSelectionDialog(WhiteListEditArea.this.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), msg);
                dlg.setTitle("Select ActionScripts");
                if (dlg.open() == 0) {
                    Object[] objs = dlg.getResult();
                    List files = WhiteListEditArea.this.collectActionScripts(objs);
                    Set<String> words = WhiteListEditArea.this.sharedPage.getProject() != null ? MetadataTagProjectDataManager.INSTANCE.getWhiteListWords(WhiteListEditArea.this.sharedPage.getProject(), files, name) : MetadataTagProjectDataManager.INSTANCE.getWhiteListWords(files, name);
                    WhiteListEditArea.this.sharedPage.getWhiteLists().get(name).removeAll(words);
                    WhiteListEditArea.this.wordsViewer.setInput(WhiteListEditArea.this.sharedPage.getWhiteLists().get(name));
                    WhiteListEditArea.this.updateButtons();
                }
            }
        });
        this.excludeButton = b;
        this.projectGroup.add((Control)b);
        b.setVisible(false);
        this.listNameViewer.getList().setSelection(0);
        this.wordsViewer.setInput(this.sharedPage.getWhiteLists().get(this.getSelectedName()));
        Point point = this.wordsViewer.getList().computeSize(-1, -1);
        if (point.y > 500) {
            gd = (GridData)this.wordsViewer.getList().getLayoutData();
            gd.verticalAlignment = 0x1000000;
            gd.grabExcessVerticalSpace = false;
            gd.heightHint = 500;
            this.wordsViewer.getList().setLayoutData((Object)gd);
        }
        this.updateButtons();
    }

    private Shell getShell() {
        return this.sharedPage.getCurrentShell();
    }

    private String getSelectedName() {
        return this.getSelectedItems(this.listNameViewer.getSelection())[0];
    }

    private String[] getSelectedWords() {
        return this.getSelectedItems(this.wordsViewer.getSelection());
    }

    private void selectWord(String word) {
        int i = 0;
        while (i < this.wordsViewer.getList().getItemCount()) {
            if (word.equals(this.wordsViewer.getList().getItems()[i])) {
                this.wordsViewer.getList().setSelection(i);
                return;
            }
            ++i;
        }
    }

    private void updateButtons() {
        int count = this.wordsViewer.getList().getSelectionCount();
        if (count == 0) {
            this.removeButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
        }
        if (count == 1) {
            this.editButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
        }
        if (this.listNameViewer.getList().getSelectionCount() == 0) {
            this.addButton.setEnabled(false);
            this.includeButton.setEnabled(false);
            this.excludeButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
            this.includeButton.setEnabled(true);
            this.excludeButton.setEnabled(true);
        }
    }

    void addProjectGroup(Control control) {
        this.projectGroup.add(control);
    }

    List<Control> getProjectGroup() {
        return this.projectGroup;
    }

    void updateProjectGroup(boolean b) {
        for (Control control : this.projectGroup) {
            control.setEnabled(b);
        }
    }

    void inputToWhiteListNameViewer(Map<String, Set<String>> whiteLists, boolean b) {
        if (b) {
            ISelection selection = this.listNameViewer.getSelection();
            this.listNameViewer.setInput(whiteLists);
            this.listNameViewer.setSelection(selection);
        } else {
            this.listNameViewer.setInput(whiteLists);
        }
    }

    private String[] getSelectedItems(ISelection selection) {
        ArrayList<String> results = new ArrayList<String>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Iterator it = ss.iterator();
            while (it.hasNext()) {
                results.add((String)it.next());
            }
        }
        return results.toArray(new String[results.size()]);
    }

    private List<IFile> collectActionScripts(Object[] objects) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            IFile f;
            Object o = objectArray[n2];
            if (o instanceof IFile && "as".equals((f = (IFile)o).getFileExtension())) {
                files.add(f);
            }
            ++n2;
        }
        return files;
    }
}

