/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.utils;

import com.vmware.vide.vwcsdktools.Activator;
import com.vmware.vide.vwcsdktools.as.model.MetadataTag;
import com.vmware.vide.vwcsdktools.as.model.MetadataTagParameter;
import com.vmware.vide.vwcsdktools.as.parser.ActionScriptMetadataTag;
import com.vmware.vide.vwcsdktools.as.parser.BufferError;
import com.vmware.vide.vwcsdktools.managers.CheckTypeRule;
import com.vmware.vide.vwcsdktools.processors.CheckType;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class WhiteListUtil {
    private static ILog logger = Activator.getDefault().getLog();

    public static Set<String> getWhiteListWords(List<IFile> files, String whiteListName, Map<String, Map<String, List<CheckTypeRule>>> table) {
        LinkedHashSet<String> words = new LinkedHashSet<String>();
        for (IFile f : files) {
            ActionScriptMetadataTag metadatatag;
            try {
                metadatatag = new ActionScriptMetadataTag(f);
            }
            catch (IOException e) {
                logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", null, (Throwable)e));
                continue;
            }
            catch (BufferError e) {
                logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", null, (Throwable)e));
                continue;
            }
            List<MetadataTag> tags = metadatatag.getMetadataTags();
            for (MetadataTag tag : tags) {
                Map<String, List<CheckTypeRule>> paramTable = table.get(tag.getName());
                if (paramTable == null) continue;
                for (MetadataTagParameter param : tag.getParameters()) {
                    List<CheckTypeRule> rules = paramTable.get(param.getParameterName());
                    if (rules == null) continue;
                    for (CheckTypeRule rule : rules) {
                        String word;
                        if (rule.getType() != CheckType.WHITE_LIST || !rule.getOptions().get(0).equals(whiteListName) || (word = param.getSimpleValue()) == null || word.isEmpty()) continue;
                        words.add(word);
                    }
                }
            }
        }
        return words;
    }
}

