/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.impl;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.security.AuthorizationUtil;

public class StorageActionResolverPropertyProvider
implements PropertyProviderBean {
    private static final String RUNTIME_CONNECTION_STATE = "runtime.connectionState";
    private static final String DATASTORE_RELATION = "datastore";
    private static final String[] HOST_CONFIG_STORAGE_PRIV = new String[]{"Host.Config.Storage"};
    private QueryService _queryService;

    public StorageActionResolverPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @type(value="Datastore")
    public boolean getIsDeleteDatastoreActionAvailable(ManagedObjectReference dsRef) throws Exception {
        ResultSet connectedHosts = this._queryService.select(new String[]{"grantedPrivileges"}).from(new String[]{HostSystem.class.getSimpleName()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate(RUNTIME_CONNECTION_STATE, PropertyPredicate.ComparisonOperator.EQUAL, (Object)HostSystem.ConnectionState.connected), new PropertyPredicate(DATASTORE_RELATION, PropertyPredicate.ComparisonOperator.EQUAL, (Object)dsRef)}).fetch();
        if (connectedHosts != null && connectedHosts.getItems() != null) {
            for (ResourceItem resourceItem : connectedHosts.getItems()) {
                if (!AuthorizationUtil.isPrivilegeGranted((String[])HOST_CONFIG_STORAGE_PRIV, (String[])((String[])resourceItem.get("grantedPrivileges")))) continue;
                return true;
            }
        }
        return false;
    }
}

