/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.storage.util;

import com.vmware.vim.binding.sms.storage.StorageContainer;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.StorageResourceManager;
import com.vmware.vim.binding.vim.host.DiskDimensions;
import com.vmware.vim.binding.vim.host.FibreChannelHba;
import com.vmware.vim.binding.vim.host.FibreChannelTargetTransport;
import com.vmware.vim.binding.vim.host.FileSystemMountInfo;
import com.vmware.vim.binding.vim.host.FileSystemVolumeInfo;
import com.vmware.vim.binding.vim.host.HostBusAdapter;
import com.vmware.vim.binding.vim.host.InternetScsiHba;
import com.vmware.vim.binding.vim.host.InternetScsiTargetTransport;
import com.vmware.vim.binding.vim.host.MountInfo;
import com.vmware.vim.binding.vim.host.NasVolume;
import com.vmware.vim.binding.vim.host.ScsiDisk;
import com.vmware.vim.binding.vim.host.ScsiLun;
import com.vmware.vim.binding.vim.host.TargetTransport;
import com.vmware.vim.binding.vim.host.VmfsDatastoreInfo;
import com.vmware.vim.binding.vim.host.VmfsVolume;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.common.model.PropertyValueData;
import com.vmware.vsphere.client.h5.storage.util.StorageStringUtil;
import com.vmware.vsphere.client.storage.adapters.StoragePathData;
import java.util.Collections;
import java.util.HashSet;

public class StorageUtil {
    public static final String NFS3 = "NFS";
    public static final String NFS41 = "NFS41";
    private static final String VVOL = "vvol";
    private static final long BLOCK_SIZE_DEFAULT = 512L;
    public static final String VMFS = "vmfs";
    private static final String PATH_RUNTIME_NAME_TMPL = "%s:C%s:T%s:L%s";
    private static final String VMFS_ZERO_VERSION = "0.00";

    public static long lbaToBytes(DiskDimensions.Lba lba) {
        long blockSize = lba.blockSize == 0 ? 512L : (long)lba.blockSize;
        return lba.block * blockSize;
    }

    public static String formatFlash(Boolean isFlash) {
        if (isFlash != null && isFlash.booleanValue()) {
            return StorageStringUtil.getString("flash");
        }
        return StorageStringUtil.getString("hdd");
    }

    public static String formatDatastoreType(String dsType) {
        if (NFS41.equalsIgnoreCase(dsType)) {
            return StorageStringUtil.getString("datastore.nfs41");
        }
        if (NFS3.equalsIgnoreCase(dsType)) {
            return StorageStringUtil.getString("datastore.nfs3");
        }
        if (VVOL.equalsIgnoreCase(dsType)) {
            return StorageStringUtil.getString("datastore.vvol");
        }
        return dsType;
    }

    public static PropertyValueData newPropValueDataWithKey(String labelKey, String value) {
        return PropertyValueData.newInstance((String)StorageStringUtil.getString(labelKey), (String)value);
    }

    public static String formatSupportedValue(Boolean supported) {
        if (Boolean.TRUE.equals(supported)) {
            return StorageStringUtil.getString("supported");
        }
        return StorageStringUtil.getString("notSupported");
    }

    public static String formatEnabledValue(Boolean enabled) {
        if (Boolean.TRUE.equals(enabled)) {
            return StorageStringUtil.getString("enabled");
        }
        return StorageStringUtil.getString("disabled");
    }

    public static boolean isVmfsDsType(String dsType) {
        return VMFS.equalsIgnoreCase(dsType);
    }

    public static String formatPathRuntimeName(StoragePathData data) {
        if (data.pathHba != null && data.path != null && data.pathHba.device != null && data.path.channelNumber != null && data.path.targetNumber != null && data.path.lunNumber != null) {
            return String.format(PATH_RUNTIME_NAME_TMPL, data.pathHba.device, data.path.channelNumber, data.path.targetNumber, data.path.lunNumber);
        }
        return "";
    }

    public static String formatTargetStringForPath(TargetTransport transport) {
        String formatted = "";
        if (transport == null) {
            return formatted;
        }
        if (transport instanceof FibreChannelTargetTransport) {
            FibreChannelTargetTransport fibreTransport = (FibreChannelTargetTransport)transport;
            String nodeName = StorageUtil.formatWWPN(fibreTransport.getNodeWorldWideName());
            String portName = StorageUtil.formatWWPN(fibreTransport.getPortWorldWideName());
            if (StringUtil.isNullOrEmpty((String)nodeName) && StringUtil.isNullOrEmpty((String)portName)) {
                return formatted;
            }
            if (StringUtil.isNullOrEmpty((String)nodeName)) {
                return portName;
            }
            if (StringUtil.isNullOrEmpty((String)portName)) {
                return nodeName;
            }
            formatted = String.format("%s %s", nodeName, portName);
        } else if (transport instanceof InternetScsiTargetTransport) {
            InternetScsiTargetTransport iscsiTransport = (InternetScsiTargetTransport)transport;
            StringBuilder ipAddressesStringBuilder = new StringBuilder();
            String[] ipAddresses = iscsiTransport.address;
            if (ipAddresses != null) {
                for (int i = 0; i < ipAddresses.length; ++i) {
                    String ipAddress = ipAddresses[i];
                    ipAddressesStringBuilder.append(ipAddress);
                    if (i >= ipAddresses.length - 1) continue;
                    ipAddressesStringBuilder.append(", ");
                }
            }
            String ipAddressesString = ipAddressesStringBuilder.toString();
            if (StringUtil.isNullOrEmpty((String)iscsiTransport.iScsiName) && StringUtil.isNullOrEmpty((String)ipAddressesString)) {
                return "";
            }
            String name = !StringUtil.isNullOrEmpty((String)iscsiTransport.iScsiName) ? iscsiTransport.iScsiName : StorageStringUtil.getString("storage.adapters.iscsi.noName");
            formatted = String.format("%s:%s", name, ipAddressesString);
        }
        return formatted;
    }

    public static String formatAccessMode(String accessMode) {
        if (MountInfo.AccessMode.readOnly.toString().equals(accessMode)) {
            return StorageStringUtil.getString("datastore.accessMode.readOnly");
        }
        if (MountInfo.AccessMode.readWrite.toString().equals(accessMode)) {
            return StorageStringUtil.getString("datastore.accessMode.readWrite");
        }
        return "";
    }

    public static String formatKerberosAuthentication(NasVolume nasVolume) {
        if (nasVolume == null || NFS3.equals(nasVolume.getType())) {
            return null;
        }
        if (NasVolume.SecurityType.SEC_KRB5.toString().equals(nasVolume.getSecurityType())) {
            return StorageStringUtil.getString("datastore.kerberosAuthentication.enabledKrb5");
        }
        if (NasVolume.SecurityType.SEC_KRB5I.toString().equals(nasVolume.getSecurityType())) {
            return StorageStringUtil.getString("datastore.kerberosAuthentication.enabledKrb5i");
        }
        return StorageStringUtil.getString("datastore.kerberosAuthentication.disabled");
    }

    public static String formatHostStorageAdapterIdentifier(HostBusAdapter hba) {
        if (hba instanceof FibreChannelHba) {
            FibreChannelHba fibreChannelHba = (FibreChannelHba)hba;
            String nodeName = StorageUtil.formatWWPN(fibreChannelHba.nodeWorldWideName);
            String portName = StorageUtil.formatWWPN(fibreChannelHba.portWorldWideName);
            if (nodeName.isEmpty()) {
                return portName;
            }
            if (portName.isEmpty()) {
                return nodeName;
            }
            return nodeName + " " + portName;
        }
        if (hba instanceof InternetScsiHba) {
            InternetScsiHba iscsiHba = (InternetScsiHba)hba;
            String result = StringUtil.isNullOrEmpty((String)iscsiHba.iScsiAlias) ? iscsiHba.iScsiName : (StringUtil.isNullOrEmpty((String)iscsiHba.iScsiName) ? iscsiHba.iScsiAlias : String.format("%s(%s)", iscsiHba.iScsiAlias, iscsiHba.iScsiName));
            if (result == null) {
                result = StorageStringUtil.getString("na");
            }
            return result;
        }
        return StorageStringUtil.getString("na");
    }

    public static String formatWWPN(long wwpn) {
        if (wwpn == 0L) {
            return "";
        }
        StringBuilder builder = new StringBuilder(Long.toHexString(wwpn));
        if (builder.length() % 2 != 0) {
            builder.insert(0, "0");
        }
        for (int i = builder.length() - 2; i > 0; i -= 2) {
            builder.insert(i, ":");
        }
        return builder.toString();
    }

    public static String formatHostName(String hostName, HostSystem.ConnectionState connectionState, HostSystem.PowerState powerState) {
        String hostState = null;
        if (connectionState == HostSystem.ConnectionState.notResponding) {
            hostState = powerState == HostSystem.PowerState.standBy ? StorageStringUtil.getString("hostState.standBy") : StorageStringUtil.getString("hostState.notResponding");
        } else if (connectionState == HostSystem.ConnectionState.disconnected) {
            hostState = StorageStringUtil.getString("hostState.disconnected");
        }
        if (hostState != null) {
            return String.format("%s (%s)", hostName, hostState);
        }
        return hostName;
    }

    public static boolean isVmfsDatastoreUpgradable(VmfsDatastoreInfo dsInfo) {
        VmfsVolume vmfsVolume = dsInfo.getVmfs();
        if (vmfsVolume == null) {
            return false;
        }
        return vmfsVolume.getMajorVersion() == 3;
    }

    public static boolean checkMountUnmountVmfsDatastoreActionAvailability(Boolean isUnmounting, Datastore.Info dsInfo, Datastore.HostMount[] hostMounts) {
        if (!(dsInfo instanceof VmfsDatastoreInfo)) {
            return false;
        }
        if (com.vmware.vsphere.client.storage.util.StorageUtil.isForceMountedVMFSDatastore((Datastore.Info)dsInfo).booleanValue()) {
            return false;
        }
        if (ArrayUtil.isNullOrEmpty((Object[])hostMounts)) {
            return false;
        }
        for (Datastore.HostMount hostMount : hostMounts) {
            if (hostMount.mountInfo == null || !isUnmounting.equals(hostMount.mountInfo.mounted)) continue;
            return true;
        }
        return false;
    }

    public static String formatVmfsVersion(VmfsVolume vmfsVolume) {
        String vmfsVersion = StorageStringUtil.getString("vmfsDatastore.version.format", vmfsVolume.version);
        if (VMFS_ZERO_VERSION.equals(vmfsVolume.version)) {
            vmfsVersion = vmfsVolume.majorVersion > 0 ? StorageStringUtil.getString("vmfsDatastore.version.format", Integer.toString(vmfsVolume.majorVersion)) : StorageStringUtil.getString("vmfsDatastore.version.format", "");
        }
        return vmfsVersion;
    }

    public static String formatIormMode(boolean isAutomaticMode, StorageResourceManager.IORMConfigInfo iormConfigInfo) {
        if (isAutomaticMode) {
            return StorageStringUtil.getString("datastore.manage.general.datastoreCapabilities.iormMode.automatic", iormConfigInfo.percentOfPeakThroughput.toString());
        }
        return StorageStringUtil.getString("datastore.manage.general.datastoreCapabilities.iormMode.manual");
    }

    public static String getSectorFormatByScsiLun(ScsiLun scsiLun) {
        if (scsiLun instanceof ScsiDisk) {
            String scsiDiskType = ((ScsiDisk)scsiLun).scsiDiskType;
            return StorageUtil.getSectorFormatByScsiDiskType(scsiDiskType);
        }
        return "";
    }

    public static String getSectorFormatByScsiDiskType(String scsiDiskType) {
        if (scsiDiskType != null) {
            String diskTypeKey = "scsiDisk.scsiDiskType.unknown";
            switch (ScsiDisk.ScsiDiskType.valueOf((String)scsiDiskType)) {
                case native512: {
                    diskTypeKey = "scsiDisk.scsiDiskType.native512";
                    break;
                }
                case emulated512: {
                    diskTypeKey = "scsiDisk.scsiDiskType.emulated512";
                    break;
                }
                case native4k: {
                    diskTypeKey = "scsiDisk.scsiDiskType.native4k";
                    break;
                }
                case SoftwareEmulated4k: {
                    diskTypeKey = "scsiDisk.scsiDiskType.softwareEmulated4k";
                }
            }
            return StorageStringUtil.getString(diskTypeKey);
        }
        return "";
    }

    public static ScsiLun.State getOperationalState(String[] operationalState) {
        if (operationalState != null) {
            HashSet operationalStateSet = new HashSet();
            Collections.addAll(operationalStateSet, operationalState);
            if (operationalStateSet.contains(ScsiLun.State.ok.toString())) {
                return ScsiLun.State.ok;
            }
            if (operationalStateSet.contains(ScsiLun.State.off.toString())) {
                return ScsiLun.State.off;
            }
            if (operationalStateSet.contains(ScsiLun.State.lostCommunication.toString())) {
                return ScsiLun.State.lostCommunication;
            }
            if (operationalStateSet.contains(ScsiLun.State.error.toString())) {
                return ScsiLun.State.error;
            }
        }
        return ScsiLun.State.unknownState;
    }

    public static boolean isVsanContainer(StorageContainer container) {
        if (container == null || StringUtil.isNullOrEmpty((String)container.uuid)) {
            return false;
        }
        return container.uuid.toLowerCase().startsWith("vsan:");
    }

    public static boolean isIoFilterContainer(StorageContainer container) {
        if (container == null || container.arrayId == null || ArrayUtil.isNullOrEmpty((Object[])container.arrayId)) {
            return false;
        }
        for (String arrayId : container.arrayId) {
            if (StringUtil.isNullOrEmpty((String)arrayId) || !arrayId.toLowerCase().startsWith("iofilters:")) continue;
            return true;
        }
        return false;
    }

    public static NasVolume getNasVolumeByMountInfo(FileSystemVolumeInfo fileSystemVolumeInfo, MountInfo mountInfo) {
        if (fileSystemVolumeInfo != null && mountInfo != null && fileSystemVolumeInfo.mountInfo != null && fileSystemVolumeInfo.mountInfo != null) {
            for (FileSystemMountInfo fileSystemMountInfo : fileSystemVolumeInfo.mountInfo) {
                if (!(fileSystemMountInfo.volume instanceof NasVolume) || !fileSystemMountInfo.mountInfo.path.equals(mountInfo.path)) continue;
                return (NasVolume)fileSystemMountInfo.volume;
            }
        }
        return null;
    }
}

