/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder;

import com.vmware.vim.binding.vim.DiagnosticManager;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.SessionManager;
import com.vmware.vim.binding.vim.encryption.CryptoManagerKmip;
import com.vmware.vim.binding.vim.encryption.KeyProviderId;
import com.vmware.vim.binding.vim.encryption.KmipServerInfo;
import com.vmware.vim.binding.vim.encryption.KmipServerSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.folder.keyServers.KmipServerInfoSpec;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FolderUtils {
    private static final Log _logger = LogFactory.getLog(FolderUtils.class);
    private static final String RESOURCE_BUNDLE_NAME = "FolderService";
    private static final String ERROR_INVALID_DIAGNOSTIC_MANAGER = "error.invalidDiagnosticManager";
    private static final String ERROR_INVALID_VC = "error.invalidVC";

    public static DiagnosticManager getDiagnosticManager(ManagedObjectReference vcRef) throws Exception {
        VcService service = FolderUtils.getVcService(vcRef);
        ServiceInstanceContent serviceContent = service.getServiceInstanceContent();
        if (serviceContent == null) {
            _logger.error((Object)"Could not retrieve ServiceInstanceContent");
            throw new RuntimeException(FolderUtils.getLocalizedString(ERROR_INVALID_DIAGNOSTIC_MANAGER));
        }
        return (DiagnosticManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceContent.getDiagnosticManager());
    }

    public static VcService getVcService(ManagedObjectReference vcRef) {
        return FolderUtils.getVcService(vcRef, null);
    }

    public static VcService getVcService(ManagedObjectReference objRef, HttpSession session) {
        if (!ManagedObjectUtil.isRootFolder((ManagedObjectReference)objRef) && !ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, HostSystem.class)) {
            _logger.error((Object)("Fetch invalid objRef = " + (objRef == null ? null : objRef.getValue())));
            throw new RuntimeException(FolderUtils.getLocalizedString(ERROR_INVALID_VC));
        }
        VcService service = VimSessionUtil.getService((String)objRef.getServerGuid(), (HttpSession)session);
        if (service == null) {
            _logger.error((Object)"Could not retrieve VcService");
            throw new RuntimeException(FolderUtils.getLocalizedString(ERROR_INVALID_VC));
        }
        return service;
    }

    public static boolean isVcRef(ManagedObjectReference vcRef) throws Exception {
        assert (vcRef != null && vcRef.getValue().equals("group-d1"));
        if (vcRef == null || StringUtil.isNullOrEmpty((String)vcRef.getServerGuid())) {
            throw new MethodFault(FolderUtils.getLocalizedString("error.nullObject"));
        }
        VcService service = VimSessionUtil.getService((String)vcRef.getServerGuid());
        if (service == null) {
            throw new MethodFault("error.notRootFolder");
        }
        ServiceInstanceContent content = service.getServiceInstanceContent();
        if (!FolderUtils.isApplicableRootFolder(vcRef, content)) {
            throw new MethodFault("error.notRootFolder");
        }
        return true;
    }

    public static SessionManager getSessionManager(ManagedObjectReference vcRef) throws Exception {
        assert (FolderUtils.isVcRef(vcRef));
        String serverGuid = vcRef.getServerGuid();
        VcService service = VimSessionUtil.getService((String)serverGuid);
        if (service == null) {
            throw new MethodFault("error.notRootFolder");
        }
        ManagedObjectReference sessionManagerMOR = service.getServiceInstanceContent().sessionManager;
        SessionManager sessionManager = (SessionManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)sessionManagerMOR);
        return sessionManager;
    }

    public static CryptoManagerKmip getCryptoManager(ManagedObjectReference moRef) throws Exception {
        String serverGuid = moRef.getServerGuid();
        VcService service = VimSessionUtil.getService((String)serverGuid);
        if (service == null) {
            throw new MethodFault("error.notRootFolder");
        }
        ManagedObjectReference cryptoManagerMOR = service.getServiceInstanceContent().cryptoManager;
        if (cryptoManagerMOR == null) {
            return null;
        }
        CryptoManagerKmip cryptoManagerKmip = (CryptoManagerKmip)ManagedObjectUtil.getManagedObject((ManagedObjectReference)cryptoManagerMOR);
        return cryptoManagerKmip;
    }

    public static String getLocalizedString(String key) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (ClassLoader)FolderUtils.class.getClassLoader());
    }

    public static KmipServerSpec getKmipServerSpec(KmipServerInfoSpec data2) {
        KmipServerInfo serverInfo = new KmipServerInfo();
        serverInfo.name = data2.name;
        serverInfo.address = data2.address;
        serverInfo.port = data2.port;
        serverInfo.userName = data2.username;
        serverInfo.proxyAddress = data2.proxyAddress;
        serverInfo.proxyPort = data2.proxyPort;
        KmipServerSpec serverSpec = new KmipServerSpec();
        serverSpec.clusterId = FolderUtils.getKmipProviderIdByName(data2.clusterName);
        serverSpec.info = serverInfo;
        if (data2.isPasswordChanged) {
            serverSpec.password = data2.password;
        }
        return serverSpec;
    }

    public static KeyProviderId getKmipProviderIdByName(String name) {
        KeyProviderId providerId = new KeyProviderId();
        providerId.id = name;
        return providerId;
    }

    private static boolean isApplicableRootFolder(ManagedObjectReference object, ServiceInstanceContent content) {
        if (content == null) {
            return false;
        }
        ManagedObjectReference contentRF = content.rootFolder;
        return ManagedObjectUtil.areEqual((ManagedObjectReference)object, (ManagedObjectReference)contentRF);
    }
}

