/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class VcServerSettingsInfo {
    public static final String TYPE_UID = "type://vcServer/settings";
    public static final String RUNTIME_SETTINGS_TYPE_UID = "type://vcServer/settings/runtime";
    public static final String ACTIVE_DIRECTORY_SETTINGS_TYPE_UID = "type://vcServer/settings/activeDirectory";
    public static final String MAIL_SETTINGS_TYPE_UID = "type://vcServer/settings/mail";
    public static final String SNMP_SETTINGS_TYPE_UID = "type://vcServer/settings/snmp";
    public static final String PORTS_SETTINGS_TYPE_UID = "type://vcServer/settings/ports";
    public static final String TIMEOUT_SETTINGS_TYPE_UID = "type://vcServer/settings/timeout";
    public static final String LOG_SETTINGS_TYPE_UID = "type://vcServer/settings/log";
    public static final String DATABASE_SETTINGS_TYPE_UID = "type://vcServer/settings/database";
    public static final String SSL_SETTINGS_TYPE_UID = "type://vcServer/settings/ssl";
    public static final String ADVANCED_SETTINGS_TYPE_UID = "type://vcServer/settings/advanced";
    public static final String RUNTIME_SETTINGS_KEY = "runtimeSettings";
    public static final String ACTIVE_DIRECTORY_SETTINGS_KEY = "activeDirectorySettings";
    public static final String MAIL_SETTINGS_KEY = "mailSettings";
    public static final String SNMP_SETTINGS_KEY = "snmpSettings";
    public static final String PORTS_SETTINGS_KEY = "portsSettings";
    public static final String TIMEOUT_SETTINGS_KEY = "timeoutSettings";
    public static final String LOG_SETTINGS_KEY = "logSettings";
    public static final String DATABASE_SETTINGS_KEY = "databaseSettings";
    public static final String SSL_SETTINGS_KEY = "sslSettings";
    public static final String ADVANCED_SETTINGS_KEY = "advancedSettings";
    public static final String[] RUNTIME_SETTINGS = new String[]{"instance.id", "VirtualCenter.ManagedIP", "VirtualCenter.InstanceName"};
    public static final String[] ACTIVE_DIRECTORY_SETTINGS = new String[]{"ads.timeout", "ads.maxFetchEnabled", "ads.maxFetch", "ads.checkIntervalEnabled", "ads.checkInterval"};
    public static final String[] MAIL_SETTINGS = new String[]{"mail.smtp.server", "mail.sender"};
    public static final String[] SNMP_SETTINGS = new String[]{"snmp.receiver.1.name", "snmp.receiver.1.enabled", "snmp.receiver.1.port", "snmp.receiver.1.community", "snmp.receiver.2.name", "snmp.receiver.2.enabled", "snmp.receiver.2.port", "snmp.receiver.2.community", "snmp.receiver.3.name", "snmp.receiver.3.enabled", "snmp.receiver.3.port", "snmp.receiver.3.community", "snmp.receiver.4.name", "snmp.receiver.4.enabled", "snmp.receiver.4.port", "snmp.receiver.4.community"};
    public static final String[] PORTS_SETTINGS = new String[]{"WebService.Ports.http", "WebService.Ports.https"};
    public static final String[] TIMEOUT_SETTINGS = new String[]{"client.timeout.normal", "client.timeout.long"};
    public static final String[] LOG_SETTINGS = new String[]{"log.level"};
    public static final String[] DATABASE_SETTINGS = new String[]{"VirtualCenter.MaxDBConnection", "task.maxAgeEnabled", "task.maxAge", "event.maxAgeEnabled", "event.maxAge"};
    public static final String[] SSL_SETTINGS = new String[]{"client.VerifySSLCertificates"};
    public static final String[] BASIC_SETTINGS = VcServerSettingsInfo.createBasicSettings();
    public static final Map<String, String[]> SETTINGS_BY_SECTIONS_VCDB_UI_ENABLED = VcServerSettingsInfo.createVcdbUiEnabledSettingsMap();
    public static final Map<String, String> TYPE_UID_BY_SECTIONS_VCDB_UI_ENABLED = VcServerSettingsInfo.createVcdbUiEnabledTypeUidMap();
    public static final Map<String, String> TYPE_UID_BY_SECTIONS_VCDB_UI_DISABLED = VcServerSettingsInfo.createVcdbUiDisabledTypeUidMap();

    private static String[] createBasicSettings() {
        ArrayList basicSettings = new ArrayList();
        Collections.addAll(basicSettings, RUNTIME_SETTINGS);
        Collections.addAll(basicSettings, ACTIVE_DIRECTORY_SETTINGS);
        Collections.addAll(basicSettings, MAIL_SETTINGS);
        Collections.addAll(basicSettings, SNMP_SETTINGS);
        Collections.addAll(basicSettings, PORTS_SETTINGS);
        Collections.addAll(basicSettings, TIMEOUT_SETTINGS);
        Collections.addAll(basicSettings, LOG_SETTINGS);
        Collections.addAll(basicSettings, DATABASE_SETTINGS);
        Collections.addAll(basicSettings, SSL_SETTINGS);
        int size = basicSettings.size();
        return basicSettings.toArray(new String[size]);
    }

    private static Map<String, String[]> createVcdbUiEnabledSettingsMap() {
        LinkedHashMap<String, String[]> settingsMap = new LinkedHashMap<String, String[]>();
        settingsMap.put(DATABASE_SETTINGS_KEY, DATABASE_SETTINGS);
        settingsMap.put(RUNTIME_SETTINGS_KEY, RUNTIME_SETTINGS);
        settingsMap.put(ACTIVE_DIRECTORY_SETTINGS_KEY, ACTIVE_DIRECTORY_SETTINGS);
        settingsMap.put(MAIL_SETTINGS_KEY, MAIL_SETTINGS);
        settingsMap.put(SNMP_SETTINGS_KEY, SNMP_SETTINGS);
        settingsMap.put(PORTS_SETTINGS_KEY, PORTS_SETTINGS);
        settingsMap.put(TIMEOUT_SETTINGS_KEY, TIMEOUT_SETTINGS);
        settingsMap.put(LOG_SETTINGS_KEY, LOG_SETTINGS);
        settingsMap.put(SSL_SETTINGS_KEY, SSL_SETTINGS);
        return Collections.unmodifiableMap(settingsMap);
    }

    private static Map<String, String> createVcdbUiEnabledTypeUidMap() {
        LinkedHashMap<String, String> typeMap = new LinkedHashMap<String, String>();
        typeMap.put(DATABASE_SETTINGS_KEY, DATABASE_SETTINGS_TYPE_UID);
        typeMap.put(RUNTIME_SETTINGS_KEY, RUNTIME_SETTINGS_TYPE_UID);
        typeMap.put(ACTIVE_DIRECTORY_SETTINGS_KEY, ACTIVE_DIRECTORY_SETTINGS_TYPE_UID);
        typeMap.put(MAIL_SETTINGS_KEY, MAIL_SETTINGS_TYPE_UID);
        typeMap.put(SNMP_SETTINGS_KEY, SNMP_SETTINGS_TYPE_UID);
        typeMap.put(PORTS_SETTINGS_KEY, PORTS_SETTINGS_TYPE_UID);
        typeMap.put(TIMEOUT_SETTINGS_KEY, TIMEOUT_SETTINGS_TYPE_UID);
        typeMap.put(LOG_SETTINGS_KEY, LOG_SETTINGS_TYPE_UID);
        typeMap.put(SSL_SETTINGS_KEY, SSL_SETTINGS_TYPE_UID);
        return Collections.unmodifiableMap(typeMap);
    }

    private static Map<String, String> createVcdbUiDisabledTypeUidMap() {
        LinkedHashMap<String, String> typeMap = new LinkedHashMap<String, String>();
        typeMap.put(RUNTIME_SETTINGS_KEY, RUNTIME_SETTINGS_TYPE_UID);
        typeMap.put(ACTIVE_DIRECTORY_SETTINGS_KEY, ACTIVE_DIRECTORY_SETTINGS_TYPE_UID);
        typeMap.put(MAIL_SETTINGS_KEY, MAIL_SETTINGS_TYPE_UID);
        typeMap.put(SNMP_SETTINGS_KEY, SNMP_SETTINGS_TYPE_UID);
        typeMap.put(PORTS_SETTINGS_KEY, PORTS_SETTINGS_TYPE_UID);
        typeMap.put(TIMEOUT_SETTINGS_KEY, TIMEOUT_SETTINGS_TYPE_UID);
        typeMap.put(LOG_SETTINGS_KEY, LOG_SETTINGS_TYPE_UID);
        typeMap.put(DATABASE_SETTINGS_KEY, DATABASE_SETTINGS_TYPE_UID);
        typeMap.put(SSL_SETTINGS_KEY, SSL_SETTINGS_TYPE_UID);
        return Collections.unmodifiableMap(typeMap);
    }
}

