/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.host.ConnectSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vsphere.client.folder.HostVerificationData;
import com.vmware.vsphere.client.folder.VcServerSettingsConfigSpec;
import com.vmware.vsphere.client.folder.VcServerSettingsManager;

public class VCenterServerSettingsMutationProvider
implements MutationProvider {
    private LegacyAuthorizationService _authService;
    private FeatureStateService _featureStateService;

    public VCenterServerSettingsMutationProvider(LegacyAuthorizationService authService, FeatureStateService featureStateService) {
        this._authService = authService;
        this._featureStateService = featureStateService;
    }

    public OperationResult apply(ManagedObjectReference vcRef, VcServerSettingsConfigSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = vcRef;
        try {
            VcServerSettingsManager mgr = new VcServerSettingsManager(vcRef, this._authService, this._featureStateService);
            mgr.updateHistoricalIntervals(spec.historicalIntervals);
            mgr.updateVcSettings(spec.vcServerSettingsChangeset);
            this.manuallyVerifyHosts(spec.hostVerificationData);
        }
        catch (Exception e) {
            result.error = e;
        }
        return result;
    }

    private void manuallyVerifyHosts(HostVerificationData[] hostVerificationData) throws Exception {
        if (ArrayUtil.isNullOrEmpty((Object[])hostVerificationData)) {
            return;
        }
        for (HostVerificationData hostData : hostVerificationData) {
            HostSystem hostSystem = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostData.host);
            ConnectSpec connectSpec = new ConnectSpec();
            connectSpec.sslThumbprint = hostData.sslThumbprint;
            hostSystem.reconnect(connectSpec, null);
        }
    }
}

