/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.commonservice.util;

import java.nio.charset.Charset;

public class NameValidationUtil {
    private static final int NAME_MAX_CHAR_LENGTH = 80;
    private static final int NAME_MAX_BYTE_LENGTH = 214;

    public static boolean validateCharLength(String name) {
        int charLen = NameValidationUtil.convertSpecialChars(name).length();
        return charLen > 0 && charLen <= 80;
    }

    public static boolean validateByteLength(String name) {
        int byteLen = (name = NameValidationUtil.convertSpecialChars(name)).getBytes(Charset.forName("UTF-8")).length;
        return byteLen > 0 && byteLen <= 214;
    }

    public static String convertSpecialChars(String name) {
        return name.replace("%", "%25").replace("/", "%2f").replace("\\", "%2c");
    }

    public static boolean validate(String name) {
        boolean isValidCharLength = NameValidationUtil.validateCharLength(name);
        if (!isValidCharLength) {
            return false;
        }
        boolean isValidByteLength = NameValidationUtil.validateByteLength(name);
        return isValidByteLength;
    }
}

