/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.contentLibrary;

import com.vmware.vapi.std.errors.OperationNotFound;
import com.vmware.vcenter.ovf.Capability;
import com.vmware.vcenter.ovf.CapabilityTypes;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vsphere.client.contentLibrary.ContentLibraryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentLibraryUtilImpl
implements ContentLibraryUtil {
    private static final Log _logger = LogFactory.getLog(ContentLibraryUtil.class);
    private static Capability _ovfCapability;
    private static final int DEPLOY_OVF_CACHE_DURATION = 900000;
    private static final String OVF_CAPABILITY_SESSION_KEY_PREFIX = "ovfCapabilityCache";

    public ContentLibraryUtilImpl(Capability ovfCapability) {
        _ovfCapability = ovfCapability;
    }

    @Override
    public boolean getIsDeployOvfSupported(ManagedObjectReference computeResource) {
        boolean result;
        String serverGuid = computeResource.getServerGuid();
        String cacheKey = OVF_CAPABILITY_SESSION_KEY_PREFIX + serverGuid;
        Boolean cachedValue = (Boolean)SessionUtil.getData((String)cacheKey);
        if (cachedValue != null) {
            return cachedValue;
        }
        try {
            CapabilityTypes.CapabilityInfo ovfCapabilityInfo = _ovfCapability.get(serverGuid);
            result = ovfCapabilityInfo.getImportOva();
            SessionUtil.setExpirableData((String)cacheKey, (Object)result, (int)900000);
        }
        catch (OperationNotFound ex) {
            _logger.warn((Object)String.format("CLS Capability interface not found on VC: %s\nReturning a CapabilityInfo with all features disabled.", serverGuid));
            result = false;
        }
        catch (Exception ex) {
            _logger.warn((Object)String.format("Error: %s, while checking CLS Capability interface on VC: %s\nAssuming deploy OVF is enabled.", ex.getMessage(), serverGuid), (Throwable)ex);
            result = true;
        }
        return result;
    }
}

