/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder.model;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.common.model.BaseSummaryData;
import com.vmware.vsphere.client.common.model.ResourceMeterData;
import com.vmware.vsphere.client.commonservice.util.Util;

@QueryBinding(value="Folder")
public final class StorageFolderSummaryData
extends BaseSummaryData
implements ResourceMeterData {
    @Property(value="Folder/allDs/length")
    private int datastoreCount;
    @Property(value="Folder/allSpod/length")
    private int dsClusterCount;
    @Property(value="Folder/usedStorageCapacity")
    private long storageUsageB;
    @Property(value="Folder/totalStorageCapacity")
    private long storageTotalB;

    @Override
    public ResourceMeterData.ResourceMeter[] getResourceMeters() {
        String freeStorage = FormatUtil.getStorageFormatted((Long)Math.abs(this.storageTotalB - this.storageUsageB), (long)1L, (long)-1L);
        String usedStorage = FormatUtil.getStorageFormatted((Long)this.storageUsageB, (long)1L, (long)-1L);
        String capacityStorage = FormatUtil.getStorageFormatted((Long)this.storageTotalB, (long)1L, (long)-1L);
        return new ResourceMeterData.ResourceMeter[]{new ResourceMeterData.ResourceMeter("StorageResourceDataItem.StorageLabel", freeStorage, usedStorage, capacityStorage, Util.getPercentageUsage(this.storageUsageB, this.storageTotalB))};
    }

    @Override
    public BaseSummaryData.LabelValue[] getSummaryItems() {
        return new BaseSummaryData.LabelValue[]{new BaseSummaryData.LabelValue("summary.datastoreCount", this.datastoreCount), new BaseSummaryData.LabelValue("summary.dsClusterCount", this.dsClusterCount)};
    }
}

