/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.permission;

import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.util.PropertyValueMap;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.security.AuthorizationObjectUtil;
import com.vmware.vise.vim.security.data.PermissionData;
import com.vmware.vise.vim.security.data.PermissionInfo;
import com.vmware.vsphere.client.permission.PermissionItemData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PermissionsPropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(PermissionsPropertyProviderAdapter.class);
    private static String PERMISSION_VIEW_DATA_PROP = "permissionViewData";
    private static String PARENT_PROP = "parent";
    private static String NAME_PROP = "name";
    private static String HOST_PROP = "host";
    private final QueryExecutor _queryExecutor;
    private final ObjectReferenceService _objectReferenceService;

    public PermissionsPropertyProviderAdapter(DataServiceExtensionRegistry registry, QueryExecutor queryExecutor, ObjectReferenceService objectReferenceService) {
        this._queryExecutor = queryExecutor;
        this._objectReferenceService = objectReferenceService;
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = "*";
        ti.properties = new String[]{PERMISSION_VIEW_DATA_PROP};
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        PropertyValue[] permissions;
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        if (!PermissionsPropertyProviderAdapter.isValidPropertyRequest(propertyRequest)) {
            return null;
        }
        Map<Object, Object> ctxObjects = this.getActualCtxObjects(propertyRequest.objects);
        if (ctxObjects == null || ctxObjects.isEmpty()) {
            return null;
        }
        Object[] queryObjects = ctxObjects.keySet().toArray();
        ResultSet rs = new ResultSet();
        try {
            permissions = this._queryExecutor.getProperty(queryObjects, "entityPermission");
        }
        catch (Exception e) {
            _logger.error((Object)("Error while getting entity permissions:" + e.getMessage()));
            rs.error = e;
            return rs;
        }
        List<ResultItem> resultItems = this.computePermissionItems(permissions, ctxObjects);
        rs.items = resultItems.toArray(new ResultItem[resultItems.size()]);
        return rs;
    }

    private List<ResultItem> computePermissionItems(PropertyValue[] permissions, Map<Object, Object> ctxObjects) {
        ArrayList<Object> objNames = new ArrayList<Object>();
        ArrayList<Object> objHosts = new ArrayList<Object>();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        for (PropertyValue pv : permissions) {
            Object[] permissionInfos = (PermissionInfo[])pv.value;
            if (ArrayUtil.isNullOrEmpty((Object[])permissionInfos)) continue;
            ArrayList<PermissionItemData> permissionItems = new ArrayList<PermissionItemData>();
            Object[] objectArray = permissionInfos;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object pi = objectArray[i];
                PermissionItemData item = new PermissionItemData();
                item.principal = ((PermissionInfo)pi).permission.principal;
                item.role = ((PermissionInfo)pi).label;
                item.permissionId = ((PermissionInfo)pi).permission.id;
                item.roleId = ((PermissionInfo)pi).permission.roleId;
                item.isGroup = ((PermissionInfo)pi).permission.group;
                item.propagateToChildren = ((PermissionInfo)pi).permission.propagate;
                if (this.isGlobalPermission(((PermissionInfo)pi).permission)) {
                    item.isGlobal = true;
                    permissionItems.add(item);
                    continue;
                }
                if (((PermissionInfo)pi).permission.entity.equals(pv.resourceObject)) {
                    item.isDefinedOnCurrentObject = true;
                    permissionItems.add(item);
                    continue;
                }
                item.entityId = this._objectReferenceService.getUid(((PermissionInfo)pi).permission.entity, true);
                item.entityType = this._objectReferenceService.getResourceObjectType(((PermissionInfo)pi).permission.entity);
                if (((PermissionInfo)pi).permission.entity instanceof ManagedObjectReference) {
                    item.isRootFolder = ManagedObjectUtil.isRootFolder((ManagedObjectReference)((ManagedObjectReference)((PermissionInfo)pi).permission.entity));
                    if (item.isRootFolder) {
                        item.entityName = VcServiceUtil.getServiceName((String)((ManagedObjectReference)((PermissionInfo)pi).permission.entity).getServerGuid());
                        permissionItems.add(item);
                        continue;
                    }
                    if (ComputeResource.class.getSimpleName().equals(item.entityType)) {
                        objHosts.add(((PermissionInfo)pi).permission.entity);
                    }
                }
                objNames.add(((PermissionInfo)pi).permission.entity);
                permissionItems.add(item);
            }
            resultItems.add(PermissionsPropertyProviderAdapter.createResultItem(pv.resourceObject, permissionItems, ctxObjects));
        }
        PropertyValueMap objNamesMap = this.retrieveEntityProperty(objNames, NAME_PROP);
        PropertyValueMap objHostsMap = this.retrieveEntityProperty(objHosts, HOST_PROP);
        for (ResultItem ri : resultItems) {
            PermissionItemData[] items;
            for (PermissionItemData item : items = (PermissionItemData[])ri.properties[0].value) {
                ManagedObjectReference[] value;
                PropertyValue pv = objNamesMap.getProperty(item.entityId, NAME_PROP);
                if (pv != null && pv.value != null) {
                    item.entityName = (String)pv.value;
                }
                if (!ComputeResource.class.getSimpleName().equals(item.entityType)) continue;
                pv = objHostsMap.getProperty(item.entityId, HOST_PROP);
                item.entityType = HostSystem.class.getSimpleName();
                if (pv == null || pv.value == null || !(pv.value instanceof ManagedObjectReference[]) || (value = (ManagedObjectReference[])pv.value).length <= 0) continue;
                item.entityId = this._objectReferenceService.getUid((Object)value[0], true);
            }
        }
        return resultItems;
    }

    private Map<Object, Object> getActualCtxObjects(Object[] objects) {
        ValidationUtil.paramsNotNull((Object[])objects);
        ArrayList<Object> hosts = new ArrayList<Object>();
        HashMap<Object, Object> ctxObjects = new HashMap<Object, Object>();
        for (Object object : objects) {
            String objType = this._objectReferenceService.getResourceObjectType(object);
            if (objType != null && objType.equals(HostSystem.class.getSimpleName())) {
                hosts.add(object);
                continue;
            }
            ctxObjects.put(object, null);
        }
        if (!hosts.isEmpty()) {
            PropertyValue[] hostParent;
            try {
                hostParent = this._queryExecutor.getProperty(hosts.toArray(), PARENT_PROP);
            }
            catch (Exception e) {
                _logger.error((Object)("Cannot get parent " + e.getMessage()));
                return null;
            }
            for (PropertyValue pv : hostParent) {
                if (pv.value == null || !(pv.value instanceof ManagedObjectReference)) {
                    _logger.error((Object)("Cannot get parent for host: " + pv.resourceObject.toString()));
                    continue;
                }
                ManagedObjectReference parent = (ManagedObjectReference)pv.value;
                if (ComputeResource.class.getSimpleName().equals(parent.getType())) {
                    ctxObjects.put(parent, pv.resourceObject);
                    continue;
                }
                ctxObjects.put(pv.resourceObject, null);
            }
        }
        return ctxObjects;
    }

    private PropertyValueMap retrieveEntityProperty(List<Object> objects, String prop) {
        PropertyValue[] propValues;
        PropertyValueMap result = new PropertyValueMap();
        if (objects.isEmpty()) {
            return result;
        }
        try {
            propValues = this._queryExecutor.getProperty(objects.toArray(), prop);
        }
        catch (Exception e) {
            _logger.error((Object)("Error while getting property " + prop + ": " + e.getMessage()));
            return result;
        }
        if (propValues != null) {
            for (PropertyValue pv : propValues) {
                String uid = this._objectReferenceService.getUid(pv.resourceObject);
                result.putProperty(uid, pv);
            }
        }
        return result;
    }

    private static boolean isValidPropertyRequest(PropertyRequestSpec propertyRequest) {
        Object[] objects = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        if (objects == null || objects.length < 1) {
            _logger.error((Object)"PermissionsPropertyProviderAdapter expects atleast one object");
            return false;
        }
        if (properties == null || properties.length < 1) {
            _logger.error((Object)"PermissionsPropertyProviderAdapter expects atleast one property");
            return false;
        }
        PropertySpec property = properties[0];
        if (property == null || property.propertyNames.length != 1 || !PERMISSION_VIEW_DATA_PROP.equals(property.propertyNames[0])) {
            _logger.error((Object)("PermissionsPropertyProviderAdapter expects request for property " + PERMISSION_VIEW_DATA_PROP));
            return false;
        }
        return true;
    }

    private boolean isGlobalPermission(PermissionData permission) {
        return AuthorizationObjectUtil.ROOT_NODE_URI.equals(permission.entity);
    }

    private static ResultItem createResultItem(Object resourceObject, List<PermissionItemData> permissionItems, Map<Object, Object> originalCtxObjects) {
        ResultItem item = new ResultItem();
        if (originalCtxObjects != null) {
            Object originalObj = originalCtxObjects.get(resourceObject);
            item.resourceObject = originalObj != null ? originalObj : resourceObject;
        }
        item.properties = new PropertyValue[1];
        item.properties[0] = new PropertyValue();
        item.properties[0].propertyName = PERMISSION_VIEW_DATA_PROP;
        item.properties[0].value = permissionItems.toArray(new PermissionItemData[permissionItems.size()]);
        return item;
    }
}

