/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginDependency;
import com.vmware.vise.extensionfw.PluginDependencyType;
import com.vmware.vise.extensionfw.PluginInfo;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.extensionfw.plugins.PluginPackageDiscoveryService;
import com.vmware.vise.mvc.telemetry.DataCollectionConfigurator;
import com.vmware.vise.mvc.util.FilenameHelper;
import com.vmware.vise.mvc.util.I18nServiceHelper;
import com.vmware.vise.usersession.UserSession;
import com.vmware.vise.util.BuildProperties;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.Predicate;
import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.serialization.JsonObjectMapper;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.security.NotAuthenticatedError;
import com.vmware.vsphere.client.security.util.Util;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AppStartController {
    private static final String INDEX_PAGE = "index";
    private static final Log _logger = LogFactory.getLog(AppStartController.class);
    private static final String ADV_PERF_CHART_PLUGIN_ID = "com.vmware.opsmgmt.client.advperfcharts";
    private static final String COMMON_MODULE_PLUGIN_ID = "com.vmware.vsphere.client.commonModule";
    private static final String STORAGE_MODULE_PLUGIN_ID = "com.vmware.vsphere.client.storage";
    private static final String NETWORK_LIB_UI_MODULE_PLUGIN_ID = "com.vmware.vsphere.client.networkLibUi";
    private static final String HMAC_SHA_256 = "HmacSHA256";
    private static final String CODE_CAPTURE_CONFIG_NAME = "codecapture.disabled";
    private final ExtensionService _extensionService;
    private final PluginPackageDiscoveryService _pluginPackageDiscoveryService;
    private final I18nServiceHelper _i18nServiceHelper;
    private final ConfigurationService _configurationService;
    private static final boolean _isReleaseBuild = BuildProperties.isReleaseBuild();
    private static final String _xsrfCookieName = BuildProperties.getXsrfCookieName();
    private static final String _xsrfHeaderName = BuildProperties.getXsrfHeaderName();
    private final Date _applicationStartedDate;
    private final DataCollectionConfigurator _dataCollectionConfigurator;
    private final JsonObjectMapper _jsonObjectMapper;

    @Autowired
    public AppStartController(ExtensionService extensionService, PluginPackageDiscoveryService pluginPackageDiscoveryService, I18nServiceHelper i18nServiceHelper, ConfigurationService configurationSvc, DataCollectionConfigurator dataCollectionConfigurator, JsonObjectMapper jsonObjectMapper) {
        this._extensionService = extensionService;
        this._pluginPackageDiscoveryService = pluginPackageDiscoveryService;
        this._i18nServiceHelper = i18nServiceHelper;
        this._configurationService = configurationSvc;
        this._applicationStartedDate = new Date();
        this._dataCollectionConfigurator = dataCollectionConfigurator;
        this._jsonObjectMapper = jsonObjectMapper;
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public final String getIndexPage(ModelMap model, @RequestParam(value="debug", required=false, defaultValue="false") boolean debug, HttpSession session) throws Exception {
        this.storeDeployedPackagesInSession(session);
        Predicate<PluginInfo> predicate = new Predicate<PluginInfo>(){

            public boolean evaluate(PluginInfo pluginInfo) {
                return true;
            }
        };
        String result = this.getPage(model, debug, predicate);
        return result;
    }

    protected void storeDeployedPackagesInSession(HttpSession session) throws Exception {
        String clientId = SessionUtil.getClientId((HttpSession)session);
        if (StringUtils.isNotEmpty((CharSequence)clientId) && SessionUtil.isValidClientId((String)clientId)) {
            boolean remotePluginAutoUpdateEnabled = PropertyUtil.getBooleanProperty((ConfigurationService)this._configurationService, (String)"remote.plugin.updateOnBrowserRefresh", (boolean)false);
            if (remotePluginAutoUpdateEnabled) {
                this._pluginPackageDiscoveryService.deployNewRemotePackages();
            }
            HashSet<IdVersionPair> deployedPackages = new HashSet<IdVersionPair>();
            for (PluginPackageInfo pluginInfo : this._extensionService.getAllPluginPackageInfos()) {
                deployedPackages.add(new IdVersionPair(pluginInfo.getId(), pluginInfo.getVersion()));
            }
            SessionUtil.setData((String)"PluginPackagesRefs", deployedPackages);
        }
    }

    @RequestMapping(value={"/cache/h5-namespace-init"}, method={RequestMethod.GET})
    public final String getH5NamespaceInitPage(ModelMap model) throws Exception {
        Locale locale = ResourceUtil.getLocale();
        String languageResourceJSON = this._i18nServiceHelper.getResources(locale.toString());
        boolean isTelemetryEnabled = this.isTelemetryEnabled();
        String installationId = this._configurationService.getProperty("installation.id");
        if (installationId == null) {
            installationId = "";
        }
        String telemetryCollectorId = this._configurationService.getProperty("telemetry.collectorId");
        String feedbackCollectorId = this._configurationService.getProperty("feedback.collectorId");
        String telemetryCookieDomain = this._configurationService.getProperty("telemetry.cookieDomain");
        model.addAttribute("applicationStartedDate", (Object)this._applicationStartedDate);
        model.addAttribute("languageResource", (Object)languageResourceJSON);
        model.addAttribute("xsrfCookieName", (Object)_xsrfCookieName);
        model.addAttribute("xsrfHeaderName", (Object)_xsrfHeaderName);
        model.addAttribute("isReleaseBuild", (Object)_isReleaseBuild);
        model.addAttribute("isTelemetryEnabled", (Object)isTelemetryEnabled);
        model.addAttribute("installationId", (Object)installationId);
        model.addAttribute("locale", (Object)locale.toLanguageTag());
        model.addAttribute("telemetryCollectorId", (Object)telemetryCollectorId);
        model.addAttribute("feedbackCollectorId", (Object)feedbackCollectorId);
        model.addAttribute("telemetryCookieDomain", (Object)telemetryCookieDomain);
        String errorPopupStatusString = this._configurationService.getProperty("error.popup.show");
        if (errorPopupStatusString == null) {
            errorPopupStatusString = "true";
        }
        model.addAttribute("isErrorPopupEnabled", (Object)Boolean.parseBoolean(errorPopupStatusString));
        return "h5-namespace-init";
    }

    @RequestMapping(value={"/chart"}, method={RequestMethod.GET})
    public final String getChartPage(ModelMap model, @RequestParam(value="debug", required=false, defaultValue="false") boolean debug) throws Exception {
        Predicate<PluginInfo> predicate = new Predicate<PluginInfo>(){

            public boolean evaluate(PluginInfo pluginInfo) {
                return AppStartController.ADV_PERF_CHART_PLUGIN_ID.equals(pluginInfo.getId()) || AppStartController.COMMON_MODULE_PLUGIN_ID.equals(pluginInfo.getId());
            }
        };
        model.addAttribute("popupPage", (Object)"chart");
        String result = this.getPage(model, debug, predicate);
        return result;
    }

    @RequestMapping(value={"/datastore-browser"}, method={RequestMethod.GET})
    public final String getDatastoreBrowserPage(ModelMap model, @RequestParam(value="debug", required=false, defaultValue="false") boolean debug) throws Exception {
        Predicate<PluginInfo> predicate = new Predicate<PluginInfo>(){

            public boolean evaluate(PluginInfo pluginInfo) {
                return AppStartController.STORAGE_MODULE_PLUGIN_ID.equals(pluginInfo.getId()) || AppStartController.COMMON_MODULE_PLUGIN_ID.equals(pluginInfo.getId()) || AppStartController.NETWORK_LIB_UI_MODULE_PLUGIN_ID.equals(pluginInfo.getId());
            }
        };
        model.addAttribute("popupPage", (Object)"datastore-browser");
        return this.getPage(model, debug, predicate);
    }

    @RequestMapping(value={"/userHash"}, method={RequestMethod.GET})
    @ResponseBody
    public final String getHashedUserId(@RequestParam(value="userId") String userId) {
        String hashKey = this._configurationService.getProperty("intercom.hash.key");
        return AppStartController.encodeIntercomUserId(userId, hashKey);
    }

    private String getPage(ModelMap model, Boolean debug, Predicate<PluginInfo> modulesToInclude) throws Exception {
        PluginInfo[] pluginInfos;
        String isBrowserContextMenuEnabledString = this._configurationService.getProperty("browser.context.menu");
        boolean isBrowserContextMenuEnabled = Boolean.parseBoolean(isBrowserContextMenuEnabledString);
        model.addAttribute("isBrowserContextMenuEnabled", (Object)isBrowserContextMenuEnabled);
        model.addAttribute("i18nResourcesVersion", (Object)this._i18nServiceHelper.getInternalVersion());
        UserSession userSession = Util.getUserSession();
        model.addAttribute("hasUserSession", (Object)(userSession != null ? 1 : 0));
        model.addAttribute("configurationJson", (Object)"{}");
        FilenameHelper filenameHelper = new FilenameHelper(debug, this.isDevMode());
        model.addAttribute("filenameHelper", (Object)filenameHelper);
        if (userSession == null) {
            model.addAttribute("angularModules", (Object)"[]");
            return INDEX_PAGE;
        }
        LinkedHashSet<PluginDependency> jsDependencies = new LinkedHashSet<PluginDependency>();
        LinkedHashSet<PluginDependency> cssDependencies = new LinkedHashSet<PluginDependency>();
        LinkedHashSet<String> angularModules = new LinkedHashSet<String>();
        for (PluginInfo pluginInfo : pluginInfos = this._extensionService.getPluginInfos()) {
            PluginDependency[] dependencies;
            if (!modulesToInclude.evaluate((Object)pluginInfo)) continue;
            String type = pluginInfo.getType().trim();
            if ("angularjs".equalsIgnoreCase(type)) {
                angularModules.add(pluginInfo.getId().trim());
            }
            if ((dependencies = pluginInfo.getDependencies()) == null) continue;
            for (PluginDependency dependency : dependencies) {
                PluginDependencyType pluginType = PluginDependencyType.fromString((String)dependency.getType());
                if (PluginDependencyType.JAVA_SCRIPT.equals((Object)pluginType)) {
                    jsDependencies.add(dependency);
                    continue;
                }
                if (!PluginDependencyType.CSS.equals((Object)pluginType)) continue;
                cssDependencies.add(dependency);
            }
        }
        model.addAttribute("isTelemetryEnabled", (Object)this.isTelemetryEnabled());
        String installationId = this._configurationService.getProperty("installation.id");
        if (installationId == null) {
            installationId = "";
        }
        String intercomHashKey = this._configurationService.getProperty("intercom.hash.key");
        String walkMeUrl = this._configurationService.getProperty("walkMe.url");
        String segmentAppId = this._configurationService.getProperty("segment.appId");
        String sddcId = this._configurationService.getProperty("sddc.id");
        String intercomUserId = userSession.userName;
        String userSuffix = this.getUserSuffix();
        if (userSuffix != null && !userSuffix.isEmpty()) {
            intercomUserId = intercomUserId + userSuffix;
        }
        String langTag = ResourceUtil.getLocale().toLanguageTag();
        String languageTag = langTag.toLowerCase();
        String angularModulesJson = this._jsonObjectMapper.writeValueAsString(angularModules);
        model.addAttribute("angularModules", (Object)angularModulesJson);
        model.addAttribute("jsDependencies", jsDependencies);
        model.addAttribute("cssDependencies", cssDependencies);
        model.addAttribute("installationId", (Object)installationId);
        model.addAttribute("langTag", (Object)langTag);
        model.addAttribute("languageTag", (Object)languageTag);
        model.addAttribute("walkMeUrl", (Object)walkMeUrl);
        model.addAttribute("sddcId", (Object)sddcId);
        model.addAttribute("segmentAppId", (Object)segmentAppId);
        model.addAttribute("userName", (Object)userSession.userName);
        model.addAttribute("intercomUserId", (Object)intercomUserId);
        model.addAttribute("hashedIntercomUserId", (Object)AppStartController.encodeIntercomUserId(intercomUserId, intercomHashKey));
        model.addAttribute("i18nResourcesVersion", (Object)(languageTag + this._i18nServiceHelper.getInternalVersion()));
        String configurationJson = this._jsonObjectMapper.writeValueAsString((Object)this._configurationService.getPublicConfiguration());
        model.addAttribute("configurationJson", (Object)configurationJson);
        model.addAttribute("isCodeCaptureEnabled", (Object)this.isCodeCaptureFeatureEnabled());
        return INDEX_PAGE;
    }

    private String getUserSuffix() {
        String sddcId = this._configurationService.getProperty("sddc.id");
        String installationId = this._configurationService.getProperty("installation.id");
        String userSuffix = null;
        if (StringUtils.isNotEmpty((CharSequence)sddcId)) {
            userSuffix = "-sddc" + sddcId;
        } else {
            _logger.error((Object)"Missing sddc id in the configuration file. Post installation scripts failed to set the property");
            if (StringUtils.isNotEmpty((CharSequence)installationId)) {
                userSuffix = "-vcenter" + installationId.substring(4);
            }
        }
        return userSuffix;
    }

    private static String encodeIntercomUserId(String userId, String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return userId;
        }
        StringBuffer result = new StringBuffer();
        try {
            byte[] hash;
            Mac sha256_HMAC = Mac.getInstance(HMAC_SHA_256);
            SecretKeySpec secret_key = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), HMAC_SHA_256);
            sha256_HMAC.init(secret_key);
            for (byte b : hash = sha256_HMAC.doFinal(userId.getBytes(StandardCharsets.UTF_8))) {
                result.append(String.format("%02X", b));
            }
        }
        catch (Exception e) {
            _logger.warn((Object)"Unable to encode intercom user id.");
            return userId;
        }
        return result.toString();
    }

    private boolean isTelemetryEnabled() {
        boolean isTelemetryEnabled = false;
        if (this.hasClientId()) {
            try {
                isTelemetryEnabled = this._dataCollectionConfigurator.isCeipEnabled();
            }
            catch (NotAuthenticatedError notAuthenticatedError) {
            }
            catch (Exception e) {
                _logger.error((Object)"Error checking whether the telemetry is enabled.", (Throwable)e);
            }
        }
        return isTelemetryEnabled;
    }

    private boolean isCodeCaptureFeatureEnabled() {
        return !PropertyUtil.getBooleanProperty((ConfigurationService)this._configurationService, (String)CODE_CAPTURE_CONFIG_NAME, (boolean)false);
    }

    protected boolean hasClientId() {
        return SessionUtil.getClientId((HttpSession)SessionUtil.getHttpSession()) != null;
    }

    private boolean isDevMode() {
        return PropertyUtil.getBooleanProperty((ConfigurationService)this._configurationService, (String)"local.development", (boolean)false);
    }
}

