/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.sso.PrincipalId;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.CombinedExtensionPointInfo;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionPointInfo;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginConstants;
import com.vmware.vise.extensionfw.PluginInfo;
import com.vmware.vise.extensionfw.PluginPackageEvent;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.extensionfw.PluginPackageStateInfo;
import com.vmware.vise.extensionfw.impl.plugin.util.comparator.IdVersionPairComparator;
import com.vmware.vise.extensionfw.plugins.PluginStatusService;
import com.vmware.vise.mvc.model.Plugin;
import com.vmware.vise.mvc.util.ExtensionServiceUtil;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.PropertyUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.security.sso.SsoUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ExtensionServiceController {
    private static final String BUNDLE_NAME = "CommonMvc";
    private static final String SHOW_STACKTRACE_ENABLED_PROPERTY = "error.stackTrace.show";
    private static final Log _logger = LogFactory.getLog(ExtensionServiceController.class);
    private final ExtensionService _extensionService;
    private final PluginStatusService _pluginStatusService;
    private final ObjectReferenceService _objRefService;
    private final boolean _showStacktraceEnabled;
    private final String CERTIFIED_YES = "Plugin.vmwareCertified.yes";
    private final String CERTIFIED_NO = "Plugin.vmwareCertified.no";
    private final String CERTIFIED_UNKNOWN = "Plugin.vmwareCertified.unknown";

    @Autowired
    public ExtensionServiceController(ExtensionService extensionService, PluginStatusService pluginStatusService, ConfigurationService configService, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService) {
        this._extensionService = extensionService;
        this._pluginStatusService = pluginStatusService;
        this._objRefService = objectReferenceService;
        this._showStacktraceEnabled = PropertyUtil.getBooleanProperty((ConfigurationService)configService, (String)SHOW_STACKTRACE_ENABLED_PROPERTY, (boolean)false);
    }

    @RequestMapping(value={"/extensions/{pointId}/{objectId:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public <T> List<T> getExtensionObjects(@PathVariable(value="pointId") String pointId, @PathVariable(value="objectId") String objectId) {
        Map<String, Object> filterContext = ExtensionServiceUtil.getFilterContext(this._objRefService, objectId);
        List result = this._extensionService.getExtensionObjects(pointId, filterContext, true);
        return result;
    }

    @RequestMapping(value={"/extensionInfos/{pointId:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ExtensionInfo> getExtensionInfos(@PathVariable(value="pointId") String pointId) throws Exception {
        ExtensionPointInfo extensionPointInfo = this._extensionService.getExtensionPointInfo(pointId);
        if (extensionPointInfo == null) {
            throw new IllegalArgumentException("Extension point with pointId: " + extensionPointInfo + " not found");
        }
        ExtensionInfo[] result = this._extensionService.getExtensionInfos(pointId);
        return Arrays.asList(result);
    }

    @RequestMapping(value={"/hostedextensions/{extensionId:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public <T> List<T> getHostedExtensionObjectsByExtensionId(@PathVariable(value="extensionId") String extensionId, @RequestParam(value="objectId", required=false) String objectId) throws Exception {
        List result = ExtensionServiceUtil.getHostedExtensionObjectsByExtensionId(this._extensionService, extensionId, this._objRefService, objectId);
        return result;
    }

    @RequestMapping(value={"/extension/{extensionId:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public ExtensionInfo getExtensionInfo(@PathVariable(value="extensionId") String extensionId) throws Exception {
        return this._extensionService.getExtensionInfo(extensionId);
    }

    @RequestMapping(value={"/changePluginPackageState"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean changePluginPackageState(@RequestParam(value="pluginPackageId") String pluginPackageId, @RequestParam(value="pluginPackageVersion") String pluginPackageVersion, @RequestParam(value="pluginPackageState") String pluginPackageState) throws Exception {
        if (StringUtils.isEmpty((CharSequence)pluginPackageId) || StringUtils.isEmpty((CharSequence)pluginPackageVersion) || StringUtils.isEmpty((CharSequence)pluginPackageState)) {
            _logger.error((Object)"plugin package id, version or state cannot be null");
            return false;
        }
        if (!this.isLoggedInUserAdministrator()) {
            _logger.error((Object)"Unable to change the plugin package state. The user is not a member of the 'Administrators' group");
            return false;
        }
        IdVersionPair pluginPackageRef = new IdVersionPair(pluginPackageId, pluginPackageVersion);
        PluginPackageStateInfo pluginPackageStateInfo = new PluginPackageStateInfo();
        pluginPackageStateInfo.setPackageRef(pluginPackageRef);
        pluginPackageStateInfo.setState("enabled".equalsIgnoreCase(pluginPackageState));
        try {
            this._extensionService.setPackageStates(new PluginPackageStateInfo[]{pluginPackageStateInfo});
        }
        catch (Exception e) {
            _logger.warn((Object)("Failed to change plugin package state: " + pluginPackageRef), (Throwable)e);
            return false;
        }
        return true;
    }

    @RequestMapping(value={"/allExtensions"}, method={RequestMethod.GET})
    @ResponseBody
    public CombinedExtensionPointInfo[] getAllExtensionObjects() {
        CombinedExtensionPointInfo[] points = this._extensionService.getAllCombinedExtensionPointInfos();
        Arrays.sort(points, new Comparator<CombinedExtensionPointInfo>(){

            @Override
            public int compare(CombinedExtensionPointInfo o1, CombinedExtensionPointInfo o2) {
                return o1.getPoint().getId().compareTo(o2.getPoint().getId());
            }
        });
        return points;
    }

    @RequestMapping(value={"/plugins"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Plugin> getAllUserPlugins() throws Exception {
        Map pluginStatuses = this._pluginStatusService.getAllPluginStatuses();
        List<Plugin> filteredPlugins = this.getFilteredPluginData(pluginStatuses);
        return filteredPlugins;
    }

    @RequestMapping(value={"/plugins/deployed"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Plugin> getDeployedUserPlugins() throws Exception {
        Map pluginStatuses = this._pluginStatusService.getPluginsByStatus(PluginPackageEvent.Type.DEPLOYED);
        List<Plugin> filteredPlugins = this.getFilteredPluginData(pluginStatuses);
        return filteredPlugins;
    }

    @RequestMapping(value={"/pluginInfos"}, method={RequestMethod.GET})
    @ResponseBody
    public PluginInfo[] getAllPluginInfos() throws Exception {
        PluginInfo[] pluginInfos = this._extensionService.getPluginInfos();
        return pluginInfos;
    }

    @RequestMapping(value={"/checkForNewPlugins"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean checkForNewPlugins() throws Exception {
        PluginInfo[] allPluginInfos;
        PluginInfo[] pluginInfosOnLogin = this._extensionService.getPluginInfos();
        if (pluginInfosOnLogin.length < (allPluginInfos = this._extensionService.getFilteredPluginInfos()).length) {
            return true;
        }
        HashSet<String> pluginInfosOnLoginIds = new HashSet<String>();
        for (PluginInfo pluginInfo : pluginInfosOnLogin) {
            String pluginId = pluginInfo.getId();
            pluginInfosOnLoginIds.add(pluginId);
        }
        for (PluginInfo currentPluginInfo : allPluginInfos) {
            if (pluginInfosOnLoginIds.contains(currentPluginInfo.getId())) continue;
            return true;
        }
        return false;
    }

    private List<Plugin> getFilteredPluginData(Map<IdVersionPair, PluginPackageEvent> pluginStatuses) {
        ArrayList<Plugin> filteredPlugins = new ArrayList<Plugin>();
        for (Map.Entry<IdVersionPair, PluginPackageEvent> pluginStatus : pluginStatuses.entrySet()) {
            IdVersionPair packageRef = pluginStatus.getKey();
            PluginPackageEvent event = pluginStatus.getValue();
            PluginPackageInfo pluginInfo = this.findPackageInfo(event, packageRef);
            if (packageRef == null || event == null || pluginInfo == null || PluginPackageEvent.Type.BUNDLE_DEPLOYED == event.getType() || PluginPackageEvent.Reason.SKIPPED_ALREADY_PRESENT == event.getReason() || ArrayUtils.contains((Object[])PluginConstants.CORE_VSPHERE_CLIENT_PACKAGE_IDS, (Object)packageRef.getId()) || "com.vmware.fallback.mixed".equals(packageRef.getId()) || this.deployedLocalPluginExists(filteredPlugins, packageRef)) continue;
            Plugin plugin = this.createPluginData(event, pluginInfo);
            filteredPlugins.add(plugin);
        }
        Collections.sort(filteredPlugins, new PluginOrderComparator());
        return filteredPlugins;
    }

    private PluginPackageInfo findPackageInfo(PluginPackageEvent event, IdVersionPair packageRef) {
        for (PluginPackageInfo pluginInfo : event.getPluginPackageInfos()) {
            if (!packageRef.equals((Object)pluginInfo.getPackageRef())) continue;
            return pluginInfo;
        }
        return null;
    }

    private boolean deployedLocalPluginExists(List<Plugin> plugins, IdVersionPair packageRef) {
        for (Plugin plugin : plugins) {
            if (!packageRef.getId().equals(plugin.getId()) || plugin.isRemote() || DeploymentStatus.DEPLOYED != DeploymentStatus.fromStatusId(plugin.getDeploymentState())) continue;
            return true;
        }
        return false;
    }

    private Plugin createPluginData(PluginPackageEvent event, PluginPackageInfo pluginInfo) {
        Plugin plugin = new Plugin(pluginInfo);
        DeploymentStatus status = DeploymentStatus.fromEvent(event);
        String enabledState = "notApplicable";
        if (DeploymentStatus.DEPLOYED == status) {
            enabledState = this._pluginStatusService.isPluginEnabled(pluginInfo.getPackageRef()) ? "enabled" : "deployedAndDisabled";
        }
        plugin.setState(enabledState);
        String reason = null;
        if (event.getReason() != null) {
            DeploymentStatusReason statusReason = DeploymentStatusReason.fromEvent(event);
            reason = statusReason.getReasonId();
        }
        String error = null;
        if (event.getError() != null) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)event.getError());
            if (rootCause == null) {
                rootCause = event.getError();
            }
            if (this._showStacktraceEnabled) {
                error = rootCause.toString();
                StackTraceElement[] stackTrace = rootCause.getStackTrace();
                if (stackTrace != null && stackTrace.length > 0) {
                    error = error + "\n" + stackTrace[0];
                }
            } else if (rootCause.getMessage() != null) {
                error = rootCause.getMessage();
            }
        }
        plugin.setDeploymentState(status.getStatusId(), reason, error);
        String message = this.calculateVmwareCertifiedMessage(pluginInfo.getSigningState());
        plugin.setVmwareCertifiedMessage(message);
        return plugin;
    }

    private String calculateVmwareCertifiedMessage(PluginPackageInfo.PluginPackageSigningState signingState) {
        if (signingState == PluginPackageInfo.PluginPackageSigningState.SIGNED) {
            return this.getLocalizedString("Plugin.vmwareCertified.yes");
        }
        if (signingState == PluginPackageInfo.PluginPackageSigningState.UNSIGNED) {
            return this.getLocalizedString("Plugin.vmwareCertified.no");
        }
        return this.getLocalizedString("Plugin.vmwareCertified.unknown");
    }

    private String getLocalizedString(String message) {
        return ResourceUtil.getString((String)BUNDLE_NAME, (String)message, (String[])new String[0], (ClassLoader)ExtensionServiceController.class.getClassLoader());
    }

    private boolean isLoggedInUserAdministrator() {
        SamlToken samlToken = AuthSessionUtil.getSsoToken((SsoDomain)SsoDomain.getLocal());
        if (samlToken == null) {
            _logger.error((Object)"The SAML token is null.");
            return false;
        }
        if (samlToken.getSubjectNameId() == null) {
            _logger.error((Object)"SubjectNameId of the SAML token is null.");
            return false;
        }
        if (samlToken.getSubjectNameId().getValue() == null) {
            _logger.error((Object)"SubjectNameId value of the SAML token is null.");
            return false;
        }
        String systemDomainName = SsoUtil.getDomainName((String)samlToken.getSubjectNameId().getValue());
        List tokenGroups = samlToken.getGroupList();
        for (PrincipalId tokenGroup : tokenGroups) {
            if (!"Administrators".equalsIgnoreCase(tokenGroup.getName()) || !systemDomainName.equalsIgnoreCase(tokenGroup.getDomain())) continue;
            return true;
        }
        return false;
    }

    private class PluginOrderComparator
    implements Comparator<Plugin> {
        private PluginOrderComparator() {
        }

        @Override
        public int compare(Plugin plugin1, Plugin plugin2) {
            DeploymentStatus statusPlugin1 = DeploymentStatus.fromStatusId(plugin1 != null ? plugin1.getDeploymentState() : null);
            DeploymentStatus statusPlugin2 = DeploymentStatus.fromStatusId(plugin2 != null ? plugin2.getDeploymentState() : null);
            int diff = statusPlugin1.getOrderIndex() - statusPlugin2.getOrderIndex();
            if (diff == 0) {
                return IdVersionPairComparator.INSTANCE.compare(new IdVersionPair(plugin1.getId(), plugin1.getVersion()), new IdVersionPair(plugin2.getId(), plugin2.getVersion()));
            }
            return diff;
        }
    }

    private static enum DeploymentStatusReason {
        UNKNOWN_DOWNLOAD_ERROR("unknownDownloadError", PluginPackageEvent.Reason.UNKNOWN_DOWNLOAD_ERROR),
        DOWNLOAD_URL_UNREACHABLE_ERROR("unreachableUrlDownloadError", PluginPackageEvent.Reason.DOWNLOAD_URL_UNREACHABLE_ERROR),
        DOWNLOAD_SSL_ERROR("sslDownloadError", PluginPackageEvent.Reason.DOWNLOAD_SSL_ERROR),
        DOWNLOAD_UNSECURE_ERROR("unsecureDownloadError", PluginPackageEvent.Reason.DOWNLOAD_UNSECURE_ERROR),
        PLUGIN_UNZIP_ERROR("unzipError", PluginPackageEvent.Reason.PLUGIN_UNZIP_ERROR),
        REMOTE_PLUGIN_MOVE_ERROR("moveError", PluginPackageEvent.Reason.REMOTE_PLUGIN_MOVE_ERROR),
        MISSING_PLUGIN_DIRECTORY_ERROR("missingPluginCacheDirectory", PluginPackageEvent.Reason.MISSING_PLUGIN_DIRECTORY_ERROR),
        MISSING_PLUGIN_MANIFEST_ERROR("missingPluginManifest", PluginPackageEvent.Reason.MISSING_PLUGIN_MANIFEST_ERROR),
        MISSING_PLUGINS_FOLDER_ERROR("missingPluginsFolder", PluginPackageEvent.Reason.MISSING_PLUGINS_FOLDER_ERROR),
        MISSING_PLUGIN_BUNDLES_ERROR("missingPluginBundles", PluginPackageEvent.Reason.MISSING_PLUGIN_BUNDLES_ERROR),
        UNKNOWN_DEPLOYMENT_ERROR("unknownDeploymentError", PluginPackageEvent.Reason.UNKNOWN_DEPLOYMENT_ERROR),
        INCOMPATIBLE_PLUGIN_VERSIONING("versioningIncompatibility", PluginPackageEvent.Reason.INCOMPATIBLE_PLUGIN_VERSIONING),
        INCOMPATIBLE_BLACKLISTED("matrixIncompatibility", PluginPackageEvent.Reason.INCOMPATIBLE_BLACKLISTED),
        INCOMPATIBLE_FLASH_PLUGIN("flashPluginIncompatibility", PluginPackageEvent.Reason.INCOMPATIBLE_FLASH_PLUGIN),
        JSON_MANIFEST_VALIDATION_FAILED("jsonManifestValidationFailed", PluginPackageEvent.Reason.JSON_MANIFEST_VALIDATION_FAILED),
        REVERSE_PROXY_CONFIGURATION_ERROR("reverseProxyConfigurationError", PluginPackageEvent.Reason.REVERSE_PROXY_CONFIGURATION_ERROR);

        private final PluginPackageEvent.Reason _reason;
        private final String _id;

        private DeploymentStatusReason(String reasonId, PluginPackageEvent.Reason reason) {
            this._id = reasonId;
            this._reason = reason;
        }

        private String getReasonId() {
            return this._id;
        }

        private PluginPackageEvent.Reason getReason() {
            return this._reason;
        }

        private static DeploymentStatusReason fromEvent(PluginPackageEvent event) {
            if (event != null) {
                for (DeploymentStatusReason statusReason : DeploymentStatusReason.values()) {
                    if (statusReason.getReason() != event.getReason()) continue;
                    return statusReason;
                }
            }
            return UNKNOWN_DEPLOYMENT_ERROR;
        }
    }

    private static enum DeploymentStatus {
        IN_PROGRESS("inprogress", 0),
        FAILED("failed", 1),
        DEPLOYED("deployed", 2),
        INCOMPATIBLE("incompatible", 3),
        UNKNOWN("unknown", 4);

        private final int _orderIndex;
        private final String _status;

        private DeploymentStatus(String status, int orderIndex) {
            this._status = status;
            this._orderIndex = orderIndex;
        }

        private int getOrderIndex() {
            return this._orderIndex;
        }

        private String getStatusId() {
            return this._status;
        }

        private static DeploymentStatus fromStatusId(String statusId) {
            for (DeploymentStatus status : DeploymentStatus.values()) {
                if (!StringUtils.equals((CharSequence)status.getStatusId(), (CharSequence)statusId)) continue;
                return status;
            }
            return UNKNOWN;
        }

        private static DeploymentStatus fromEvent(PluginPackageEvent event) {
            if (event == null) {
                return UNKNOWN;
            }
            switch (event.getType()) {
                case DOWNLOADING: 
                case DOWNLOADED: 
                case DEPLOYING: 
                case BUNDLE_DEPLOYED: {
                    return IN_PROGRESS;
                }
                case DOWNLOAD_FAILED: 
                case DEPLOYMENT_FAILED: {
                    if (PluginPackageEvent.Reason.INCOMPATIBLE_BLACKLISTED == event.getReason() || PluginPackageEvent.Reason.INCOMPATIBLE_FLASH_PLUGIN == event.getReason() || PluginPackageEvent.Reason.INCOMPATIBLE_PLUGIN_VERSIONING == event.getReason()) {
                        return INCOMPATIBLE;
                    }
                    return FAILED;
                }
                case DEPLOYED: 
                case UNDEPLOYMENT_FAILED: {
                    return DEPLOYED;
                }
            }
            return UNKNOWN;
        }
    }
}

