/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vim.binding.vim.alarm.AlarmInfo;
import com.vmware.vise.actionsfw.Action;
import com.vmware.vise.actionsfw.ActionContext;
import com.vmware.vise.actionsfw.ActionEvaluation;
import com.vmware.vise.actionsfw.ActionsRequestSpec;
import com.vmware.vise.actionsfw.ActionsService;
import com.vmware.vise.actionsfw.RequestPolicy;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.core.model.monitor.IssueStatus;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.mvc.issues.model.IssueSummaryItem;
import com.vmware.vise.mvc.issues.model.IssueSummaryItemResultSet;
import com.vmware.vise.mvc.util.VmToolsUtil;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class IssuesViewController {
    private static final Log _logger = LogFactory.getLog(IssuesViewController.class);
    private final String _opId = "h5c-" + this.getClass().getSimpleName();
    private final ObjectReferenceService _objectReferenceService;
    private final QuerySpecBuilder _querySpecBuilder;
    private final QueryExecutor _queryExecutor;
    private final ActionsService _actionsService;
    private static final String ISSUE_TYPE = "Issue";
    private static final String ISSUE_INFO_PROPERTY = "info";
    private static final String ISSUE_ENTITY_PROPERTY = "info.entity";
    private static final String VM_TOOLS_ISSUE = "VmToolsIssue";
    private static final String CONFIG_ISSUE = "ConfigIssue";
    private static final String VM_COMPATIBILITY_ISSUE_TYPE = "VmCompatibilityIssue";
    private static final String ALARM_ISSUE = "AlarmIssue";
    private static final String DETAILS_PROPERTY = "details";
    private static final String ACTION_ID_UNLOCK_VM = "vsphere.core.vm.actions.cryptoUnlock";
    private static final String ACTION_ID_ENABLE_ENCRYPTION_MODE = "vsphere.core.host.actions.enableEncryptionMode";
    private static final String ALARM_SYSTEM_NAME_VM_IS_LOCKED = "alarm.VmCryptoStateLockedAlarm";
    private static final String ALARM_SYSTEM_NAME_HOST_REQUIRES_ENCRYPTION_MODE_ENABLED = "alarm.HostRequiresEncryptionModeEnabledAlarm";
    private static final String EVENTEX_CLASS = "EventEx";

    @Autowired
    public IssuesViewController(ObjectReferenceService objectReferenceService, QuerySpecBuilder querySpecBuilder, QueryExecutor queryExecutor, ActionsService actionsService) {
        this._objectReferenceService = objectReferenceService;
        this._querySpecBuilder = querySpecBuilder;
        this._queryExecutor = queryExecutor;
        this._actionsService = actionsService;
    }

    @RequestMapping(value={"/issues"})
    @ResponseBody
    public final IssueSummaryItemResultSet getIssues(@RequestParam(value="objectId", required=true) String objectId, @RequestParam(value="pageSize", defaultValue="-1") int count, @RequestParam(value="skip", defaultValue="0") int offset, @RequestParam(value="getActionEvaluations", required=false, defaultValue="false") boolean getActionEvaluations) throws Exception {
        PropertyConstraint constraint = null;
        Object objRef = null;
        String[] requestedProperties = new String[]{ISSUE_INFO_PROPERTY};
        ResultSpec resultSpec = new ResultSpec();
        if (objectId != null) {
            objRef = this._objectReferenceService.getReference(objectId, true);
            constraint = this.createPropertyConstraint(objRef);
        }
        QuerySpec query = this._querySpecBuilder.buildQuerySpec(constraint, requestedProperties, Collections.singleton(ISSUE_TYPE));
        query.name = this._opId;
        resultSpec.maxResultCount = count;
        resultSpec.offset = offset;
        query.resultSpec = resultSpec;
        ResultSet resultSet = this._queryExecutor.getData(query);
        IssueSummaryItemResultSet issuesResult = this.formatResults(resultSet, objRef, getActionEvaluations);
        return issuesResult;
    }

    @RequestMapping(value={"/issues/actions/evaluations"}, method={RequestMethod.POST})
    @ResponseBody
    public List<ActionEvaluation> getIssueActions(@RequestParam(value="objectId", required=true) String objectId, @RequestParam(value="issueId", required=true) String issueId, @RequestBody Map<String, Object> args) throws Exception {
        Object details = null;
        if (args != null && !args.isEmpty() && args.containsKey(DETAILS_PROPERTY)) {
            details = args.get(DETAILS_PROPERTY);
        }
        Object objRef = this._objectReferenceService.getReference(objectId, true);
        Object issueRef = this._objectReferenceService.getReference(issueId, true);
        ActionsRequestSpec actionSpec = IssuesViewController.createActionsSpec(issueRef);
        List<ActionEvaluation> actionEvaluations = new ArrayList<ActionEvaluation>();
        try {
            List<Action> actions = this._actionsService.getActions(actionSpec, false);
            actions = this.filterIssueActions(actions, details, issueRef, objRef);
            actionEvaluations = this.evaluateActions(actions, objRef);
        }
        catch (Exception ex) {
            _logger.error((Object)("Error while evaluating available actions for: " + issueRef), (Throwable)ex);
        }
        return actionEvaluations;
    }

    private PropertyConstraint createPropertyConstraint(Object comparableValue) {
        return QueryUtil.createPropertyConstraint((String)ISSUE_TYPE, (String)ISSUE_ENTITY_PROPERTY, (Comparator)Comparator.EQUALS, (Object)comparableValue);
    }

    private IssueSummaryItemResultSet formatResults(ResultSet resultSet, Object objRef, boolean getActionEvaluations) {
        IssueSummaryItemResultSet issueSummaryItemResultSet = new IssueSummaryItemResultSet();
        ArrayList<IssueSummaryItem> summaryItemSpecs = new ArrayList<IssueSummaryItem>();
        for (ResultItem resultItem : resultSet.items) {
            for (PropertyValue propertyValue : resultItem.properties) {
                IssueInfo issue = (IssueInfo)propertyValue.value;
                IssueSummaryItem issueSummaryItem = new IssueSummaryItem();
                issueSummaryItem.issueUid = this._objectReferenceService.getUid(resultItem.resourceObject);
                if (issue.entity != null) {
                    issueSummaryItem.entity = issue.entity;
                    issueSummaryItem.entityId = this._objectReferenceService.getUid(issue.entity);
                }
                if (objRef != null && !objRef.equals(issue.entity)) {
                    issueSummaryItem.entityName = issue.entityName;
                }
                issueSummaryItem.description = issue.description;
                issueSummaryItem.descriptionKey = issue.descriptionKey;
                issueSummaryItem.status = issue.status;
                issueSummaryItem.issueType = issue.typeDisplayName;
                issueSummaryItem.details = issue.details;
                this.handleEsxHyperthreadIssue(issueSummaryItem, issue.details);
                if (issue.timestamp != null) {
                    issueSummaryItem.timestamp = issue.timestamp.getTime();
                    issueSummaryItem.dateText = new SimpleDateFormat("MM/dd/yyyy h:mm:ss a").format(issue.timestamp);
                } else {
                    issueSummaryItem.dateText = "";
                }
                if (getActionEvaluations) {
                    ActionsRequestSpec actionSpec = IssuesViewController.createActionsSpec(resultItem.resourceObject);
                    try {
                        List<Action> actions = this._actionsService.getActions(actionSpec, false);
                        actions = this.filterIssueActions(actions, issue.details, resultItem.resourceObject, objRef);
                        issueSummaryItem.actionEvaluations = this.evaluateActions(actions, objRef);
                    }
                    catch (Exception ex) {
                        _logger.error((Object)("Error while evaluating available actions for: " + resultItem.resourceObject), (Throwable)ex);
                    }
                }
                summaryItemSpecs.add(issueSummaryItem);
            }
        }
        issueSummaryItemResultSet.totalMatchedObjectCount = resultSet.totalMatchedObjectCount;
        issueSummaryItemResultSet.summaryItemSpecs = summaryItemSpecs;
        return issueSummaryItemResultSet;
    }

    private void handleEsxHyperthreadIssue(IssueSummaryItem issueSummaryItem, Object details) {
        if (this.isEsxHyperthreadIssue(details)) {
            Class<?> c = details.getClass();
            try {
                Field fullFormattedMessage = c.getField("fullFormattedMessage");
                issueSummaryItem.status = IssueStatus.INFO;
                issueSummaryItem.description = (String)fullFormattedMessage.get(details);
            }
            catch (Exception e) {
                _logger.debug((Object)e);
            }
        }
    }

    private boolean isEsxHyperthreadIssue(Object details) {
        if (details == null) {
            return false;
        }
        Class<?> c = details.getClass();
        if (EVENTEX_CLASS.equals(c.getSimpleName())) {
            try {
                Field eventTypeId = c.getField("eventTypeId");
                if ("esx.problem.hyperthreading.unmitigated".equals((String)eventTypeId.get(details))) {
                    return true;
                }
            }
            catch (Exception e) {
                _logger.debug((Object)e);
            }
        }
        return false;
    }

    private List<Action> filterIssueActions(List<Action> actions, Object issueDetails, Object issueResourceObject, Object objRef) {
        if (issueDetails == null || objRef == null || issueResourceObject == null) {
            return actions;
        }
        String issueType = this._objectReferenceService.getResourceObjectType(issueResourceObject);
        String objectRefType = this._objectReferenceService.getResourceObjectType(objRef);
        ArrayList<Action> possibleActions = new ArrayList<Action>();
        for (Action action : actions) {
            if (!this.checkIsActionApplicable(action, issueType, objectRefType, issueDetails)) continue;
            possibleActions.add(action);
        }
        return possibleActions;
    }

    private boolean checkIsActionApplicable(Action action, String issueType, String objectRefType, Object issueDetails) {
        List applicableIssueTargetTypes = action.getApplicableTargetTypes();
        if (applicableIssueTargetTypes.contains(issueType) && applicableIssueTargetTypes.contains(objectRefType)) {
            return this.checkIsActionApplicableByIssueType(issueType, action, issueDetails, applicableIssueTargetTypes);
        }
        return false;
    }

    private boolean checkIsActionApplicableByIssueType(String issueType, Action action, Object issueDetails, List<String> applicableIssueTargetTypes) {
        String detailsClassName = issueDetails.getClass().getSimpleName();
        if (issueType.equals(VM_TOOLS_ISSUE)) {
            if (!VmToolsUtil.isVmIssueActionInapplicable(action, issueDetails).booleanValue()) {
                return true;
            }
        } else if (issueType.equals(CONFIG_ISSUE)) {
            if (applicableIssueTargetTypes.contains(detailsClassName)) {
                return !EVENTEX_CLASS.equals(detailsClassName) || this.isEsxHyperthreadIssue(issueDetails);
            }
        } else {
            if (issueType.equals(VM_COMPATIBILITY_ISSUE_TYPE) && issueDetails instanceof Boolean) {
                return (Boolean)issueDetails;
            }
            if (issueType.equals(ALARM_ISSUE)) {
                try {
                    if (ACTION_ID_UNLOCK_VM.equals(action.getUid()) || ACTION_ID_ENABLE_ENCRYPTION_MODE.equals(action.getUid())) {
                        Field alarmInfoField = issueDetails.getClass().getDeclaredField("alarmInfo");
                        AlarmInfo alarmInfo = (AlarmInfo)alarmInfoField.get(issueDetails);
                        if (ACTION_ID_UNLOCK_VM.equals(action.getUid())) {
                            return ALARM_SYSTEM_NAME_VM_IS_LOCKED.equals(alarmInfo.systemName);
                        }
                        if (ACTION_ID_ENABLE_ENCRYPTION_MODE.equals(action.getUid())) {
                            return ALARM_SYSTEM_NAME_HOST_REQUIRES_ENCRYPTION_MODE_ENABLED.equals(alarmInfo.systemName);
                        }
                    }
                }
                catch (ReflectiveOperationException e) {
                    _logger.debug((Object)e);
                    return false;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    private List<ActionEvaluation> evaluateActions(List<Action> actions, Object objRef) throws Exception {
        if (CollectionUtils.isEmpty(actions)) {
            return null;
        }
        ActionsRequestSpec actionSpec = IssuesViewController.createActionsSpec(objRef);
        actionSpec.actionUids = new ArrayList(actions.size());
        for (Action a : actions) {
            actionSpec.actionUids.add(a.getUid());
        }
        return this._actionsService.getEvaluatedActions(actionSpec, false);
    }

    private static ActionsRequestSpec createActionsSpec(Object issueRef) {
        ActionsRequestSpec actionSpec = new ActionsRequestSpec();
        actionSpec.context = new ActionContext();
        actionSpec.globalActions = RequestPolicy.EXCLUDE;
        actionSpec.context.setTargetObjects(Arrays.asList(issueRef));
        return actionSpec;
    }
}

