/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.google.common.base.Optional;
import com.vmware.cis.data.api.ComplexQuerySupport;
import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryCommand;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.CustomFieldsManager;
import com.vmware.vise.common.api.filters.QueryFilterRegistry;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.metadata.MetadataService;
import com.vmware.vise.metadata.PropertyDescriptor;
import com.vmware.vise.mvc.lists.ColumnDataSourceInfo;
import com.vmware.vise.mvc.lists.ListOptions;
import com.vmware.vise.mvc.listview.ListViewExportSpec;
import com.vmware.vise.mvc.listview.ListViewSpec;
import com.vmware.vise.mvc.listview.SortDirection;
import com.vmware.vise.mvc.listview.SortSpec;
import com.vmware.vise.mvc.model.ComponentSpec;
import com.vmware.vise.mvc.model.ObjectTypeSpec;
import com.vmware.vise.mvc.model.data.ParamSpec;
import com.vmware.vise.mvc.objecttypes.ObjectTypesManager;
import com.vmware.vise.mvc.relateditems.RelatedItemsManager;
import com.vmware.vise.mvc.util.ParameterSpecHelper;
import com.vmware.vise.util.serialization.ObjectSerializer;
import com.vmware.vise.util.service.ClassLoaderService;
import com.vmware.vsphere.client.export.ColumnType;
import com.vmware.vsphere.client.export.ExportColumn;
import com.vmware.vsphere.client.export.ExportFormat;
import com.vmware.vsphere.client.export.ExportListSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/list"})
public class ListViewController {
    private final String _opId = "h5c-" + this.getClass().getSimpleName();
    private static final String RELATED_ITEMS_LIST_FILTER_ID = "relatedItemsListFilterId";
    private static final String SIMPLE_SEARCH_LIST_FILTER_ID = "simpleSearchListFilterId";
    private static final String PROPERTY_LENGTH_SUFFIX = "._length";
    private static final String PROPERTY_FORMAT_SUFFIX = "@formatted";
    private static final String PROPERTY_SEPARATOR = ",";
    private final ObjectReferenceService _objectReferenceService;
    private final ExtensionService _extensionService;
    private final MetadataService _metadataService;
    private final QueryServiceFactory _queryServiceFactory;
    private final QueryFilterRegistry _queryFilterRegistry;
    private final RelatedItemsManager _relatedItemsManager;
    private final ObjectTypesManager _objectTypesManager;
    private final ClassLoaderService _classLoaderService;
    private final ObjectSerializer _objectMapper;
    private final MutationService _mutationService;
    private static final String OBJECT_ID = "id";

    @Autowired
    public ListViewController(@Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService, ExtensionService extensionService, MetadataService metadataService, QueryServiceFactory queryServiceFactory, QueryFilterRegistry queryFilterRegistry, RelatedItemsManager relatedItemsManager, ObjectTypesManager objectTypesManager, ClassLoaderService classLoaderService, ObjectSerializer objectMapper, MutationService mutationService) {
        this._objectReferenceService = objectReferenceService;
        this._extensionService = extensionService;
        this._metadataService = metadataService;
        this._queryServiceFactory = queryServiceFactory;
        this._queryFilterRegistry = queryFilterRegistry;
        this._relatedItemsManager = relatedItemsManager;
        this._objectTypesManager = objectTypesManager;
        this._classLoaderService = classLoaderService;
        this._objectMapper = objectMapper;
        this._mutationService = mutationService;
    }

    @RequestMapping(value={"/ex/"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> getListDataEx(@RequestBody ListViewSpec listViewSpec) throws Exception {
        Validate.notEmpty((CharSequence)listViewSpec.queryFilterId, (String)"Need a filterId to retrieve the list data.", (Object[])new Object[0]);
        Validate.notEmpty((Object[])listViewSpec.dataModels, (String)"Data model(s) are required.", (Object[])new Object[0]);
        ResultSet listData = this.getListDataResult(listViewSpec);
        Map<String, Object> result = this.transformRelationDataToMap(listData);
        return result;
    }

    @RequestMapping(value={"/listOptions/{listViewId:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public ListOptions getListOptions(@PathVariable(value="listViewId") String listViewId, @RequestParam(value="listViewType", required=false) String listViewType, @RequestParam(value="objectId", required=false) String objectId) throws Exception {
        ListOptions listOptions = new ListOptions();
        listOptions.columnDataSourceInfos = this.getColumnDataSourceInfos(listViewId, listViewType, objectId);
        ExtensionInfo listExtensionInfo = this._extensionService.getExtensionInfo(listViewId);
        ComponentSpec componentSpec = null;
        if (listExtensionInfo != null) {
            componentSpec = (ComponentSpec)((Object)this._extensionService.getExtensionObject(listExtensionInfo, null, true));
        }
        listOptions.metadata = componentSpec != null && componentSpec.contentSpec != null && componentSpec.contentSpec.metadata != null ? componentSpec.contentSpec.metadata : Collections.emptyMap();
        return listOptions;
    }

    @RequestMapping(value={"/export"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult getExportResult(@RequestBody ListViewExportSpec listViewExportSpec) throws Exception {
        ListViewSpec listViewSpec = listViewExportSpec.listViewSpec;
        Validate.notNull((Object)listViewSpec, (String)"Need a list view spec.", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)listViewSpec.queryFilterId, (String)"Need a filterId to retrieve the list data.", (Object[])new Object[0]);
        Validate.notEmpty((Object[])listViewSpec.dataModels, (String)"Data model(s) are required.", (Object[])new Object[0]);
        Validate.notEmpty((Object[])listViewExportSpec.columns, (String)"Columns are required.", (Object[])new Object[0]);
        listViewSpec.skip = 0;
        listViewSpec.take = -1;
        if (ArrayUtils.isNotEmpty((Object[])listViewExportSpec.selectedObjectIds)) {
            listViewSpec.queryFilterId = SIMPLE_SEARCH_LIST_FILTER_ID;
            listViewSpec.filterParams = new String[listViewExportSpec.selectedObjectIds.length];
            int index = 0;
            for (String string : listViewExportSpec.selectedObjectIds) {
                listViewSpec.filterParams[index++] = string;
            }
        }
        HashSet<String> exportProperties = new HashSet<String>();
        for (ExportColumn exportColumn : listViewExportSpec.columns) {
            if (exportColumn.type != ColumnType.CUSTOM) {
                exportProperties.add(exportColumn.propertyName);
                continue;
            }
            exportProperties.add("customValue");
            exportProperties.add("@instanceUuid");
        }
        listViewSpec.requestedProperties = exportProperties.toArray(new String[exportProperties.size()]);
        ResultSet resultSet = this.getListDataResult(listViewSpec);
        ResultItem[] resultItems = this.transformRelationDataToExportItems(resultSet, listViewExportSpec.columns);
        ExportListSpec exportSpec = new ExportListSpec();
        exportSpec.items = resultItems;
        exportSpec.columns = listViewExportSpec.columns;
        exportSpec.format = listViewExportSpec.format != null ? listViewExportSpec.format : ExportFormat.CSV;
        OperationResult operationResult = this._mutationService.add((Object)exportSpec);
        return operationResult;
    }

    private List<ColumnDataSourceInfo> getColumnDataSourceInfos(String listViewId, String listViewType, String objectId) throws Exception {
        HashSet<String> listTypes = new HashSet<String>();
        if (listViewType != null) {
            listTypes.add(listViewType);
        } else {
            listTypes.addAll(this.getListViewTypesById(listViewId));
        }
        Collection<String> unsearchableProperties = this.getUnsearchableProperties(listTypes);
        List<ColumnDataSourceInfo> columnDefinitions = this.getColumDefinitions(listViewId, objectId);
        ListViewController.augmentColumnDefinitions(columnDefinitions, unsearchableProperties);
        return columnDefinitions;
    }

    private List<ColumnDataSourceInfo> getColumDefinitions(String listViewId, String objectId) throws Exception {
        ExtensionInfo ei = this._extensionService.getExtensionInfo(listViewId);
        if (ei == null || ei.getHostedPointsIds() == null || ei.getHostedPointsIds().length == 0) {
            return Collections.emptyList();
        }
        Map<String, Object> filterContext = this.createFilterContextForColumnDefinitions(objectId);
        ArrayList<ColumnDataSourceInfo> result = new ArrayList<ColumnDataSourceInfo>();
        for (String pointId : ei.getHostedPointsIds()) {
            List columnDataSourceInfos = this._extensionService.getExtensionObjects(pointId, filterContext, true);
            result.addAll(columnDataSourceInfos);
        }
        return result;
    }

    private Map<String, Object> createFilterContextForColumnDefinitions(String objectId) {
        Object ref = null;
        ref = objectId != null ? this._objectReferenceService.getReference(objectId, true) : "NO_OBJECT";
        HashMap<String, Object[]> filterContext = null;
        if (ref != null) {
            filterContext = new HashMap<String, Object[]>();
            filterContext.put("contextObjects", new Object[]{ref});
        }
        return filterContext;
    }

    private Collection<String> getListViewTypesById(String listViewId) {
        HashSet<String> result = new HashSet<String>();
        Map<String, ObjectTypeSpec> specMap = this._objectTypesManager.getAllObjectTypeSpecs();
        for (ObjectTypeSpec spec : specMap.values()) {
            if (spec == null || spec.types == null || spec.listViewId == null || !spec.listViewId.equals(listViewId)) continue;
            result.addAll(Arrays.asList(spec.types));
        }
        return Collections.unmodifiableCollection(result);
    }

    private Collection<String> getUnsearchableProperties(Collection<String> objectTypes) {
        HashSet<String> result = new HashSet<String>();
        for (String objectType : objectTypes) {
            PropertyDescriptor[] descriptors;
            for (PropertyDescriptor descriptor : descriptors = this._metadataService.getPropertyMetadata(objectType)) {
                String op = descriptor.inapplicableOperators;
                if (op == null || !op.contains(Comparator.TEXTUALLY_MATCHES.name())) continue;
                result.add(descriptor.name);
                if (descriptor.aliases == null) continue;
                result.addAll(Arrays.asList(descriptor.aliases));
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    private static void augmentColumnDefinitions(Collection<ColumnDataSourceInfo> columnDefinitions, Collection<String> unsearchableProperties) {
        for (ColumnDataSourceInfo columnDefinition : columnDefinitions) {
            columnDefinition.searchable = ListViewController.isColumnSearchable(columnDefinition, unsearchableProperties);
        }
    }

    private static boolean isColumnSearchable(ColumnDataSourceInfo columnDefinition, Collection<String> unsearchableProperties) {
        String[] properties;
        String filterProperty;
        String string = filterProperty = columnDefinition.filterProperty != null ? columnDefinition.filterProperty : columnDefinition.sortProperty;
        if (StringUtils.isEmpty((CharSequence)filterProperty)) {
            return false;
        }
        for (String property : properties = StringUtils.stripAll((String[])filterProperty.split(PROPERTY_SEPARATOR))) {
            if (!StringUtils.isEmpty((CharSequence)property) && !property.endsWith(PROPERTY_LENGTH_SUFFIX) && !unsearchableProperties.contains(ListViewController.removeFormatSuffix(property))) continue;
            return false;
        }
        return true;
    }

    private Optional<Filter> createFilterForRelatedItems(String objectId, String[] filterParams) {
        Object reference;
        Validate.notEmpty((Object[])filterParams, (String)"Filter parameters expected.", (Object[])new Object[0]);
        String relationId = filterParams[0];
        if (objectId != null) {
            reference = this._objectReferenceService.getReference(objectId, true);
        } else {
            String relatedType = filterParams[1];
            reference = DefaultUriSchemeUtil.createUri((String)relatedType, (String)relatedType);
        }
        return this._relatedItemsManager.getFilterByRelationId(reference, relationId);
    }

    private Optional<Filter> createFilterForSearch(String[] filterParams) {
        Validate.notNull((Object)filterParams, (String)"Filter parameters expected.", (Object[])new Object[0]);
        if (filterParams.length == 0) {
            return Optional.absent();
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        for (int i = 0; i < filterParams.length; ++i) {
            String objectUid = filterParams[i];
            Object reference = this._objectReferenceService.getReference(objectUid, true);
            if (reference == null) continue;
            objects.add(reference);
        }
        if (objects.isEmpty()) {
            throw new IllegalArgumentException("Unrecognized object type.");
        }
        PropertyPredicate propertyPredicate = new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, objects);
        return Optional.of((Object)new Filter(Collections.singletonList(propertyPredicate)));
    }

    private Optional<Filter> createFilter(String objectId, String filterId, String[] filterParams, ParamSpec[] paramSpecs) throws IOException, ClassNotFoundException {
        Validate.notNull((Object)"Need a constraint object id to retrieve the list data.");
        Filter filter = ArrayUtils.isEmpty((Object[])filterParams) ? this._queryFilterRegistry.get(filterId, new Object[]{objectId}) : this._queryFilterRegistry.get(filterId, new Object[]{objectId, filterParams});
        Validate.notNull((Object)filter, (String)("Invalid filter Id: " + filterId), (Object[])new Object[0]);
        if (ArrayUtils.isNotEmpty((Object[])paramSpecs)) {
            ParameterSpecHelper helper = new ParameterSpecHelper(this._classLoaderService, this._objectMapper, paramSpecs);
            Map<String, List<ParameterSpec>> paramSpecsByProperty = helper.getParameterSpecs();
            ArrayList<PropertyPredicate> predicates = new ArrayList<PropertyPredicate>();
            predicates.addAll(filter.getCriteria());
            LogicalOperator operator = filter.getOperator();
            for (Map.Entry<String, List<ParameterSpec>> entry : paramSpecsByProperty.entrySet()) {
                for (ParameterSpec parameterSpec : entry.getValue()) {
                    PropertyPredicate predicate = new PropertyPredicate(entry.getKey() + "/@param", PropertyPredicate.ComparisonOperator.EQUAL, parameterSpec.parameter);
                    predicates.add(predicate);
                }
            }
            filter = new Filter(predicates, operator);
        }
        return Optional.of((Object)filter);
    }

    private static Optional<Filter> createUserFilteringCriteria(String searchTerm, String[] properties) {
        if (StringUtils.isEmpty((CharSequence)searchTerm) || ArrayUtils.isEmpty((Object[])properties)) {
            return Optional.absent();
        }
        ArrayList<PropertyPredicate> criteria = new ArrayList<PropertyPredicate>();
        for (String property : properties) {
            if (!StringUtils.isNotEmpty((CharSequence)property)) continue;
            PropertyPredicate criterion = PropertyPredicate.containsIgnoreCase((String)property, (String)searchTerm);
            criteria.add(criterion);
        }
        if (criteria.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)new Filter(criteria, LogicalOperator.OR));
    }

    private ResultSet getListDataResult(ListViewSpec listViewSpec) throws Exception {
        Optional<Filter> filter = RELATED_ITEMS_LIST_FILTER_ID.equals(listViewSpec.queryFilterId) ? this.createFilterForRelatedItems(listViewSpec.constraintObjectId, listViewSpec.filterParams) : (SIMPLE_SEARCH_LIST_FILTER_ID.equals(listViewSpec.queryFilterId) ? this.createFilterForSearch(listViewSpec.filterParams) : this.createFilter(listViewSpec.constraintObjectId, listViewSpec.queryFilterId, listViewSpec.filterParams, listViewSpec.propertyParamSpecs));
        Optional<Filter> userFilter = ListViewController.createUserFilteringCriteria(listViewSpec.searchTerm, listViewSpec.searchableProperties);
        QueryService queryService = this._queryServiceFactory.getQueryService();
        List<SortCriterion> sortCriteria = this.createSortCriteria(listViewSpec.sort);
        if (sortCriteria.isEmpty()) {
            sortCriteria.add(new SortCriterion("@modelKey"));
        }
        QueryCommand.Builder query = queryService.select(Arrays.asList(listViewSpec.requestedProperties)).from(listViewSpec.dataModels).orderBy(sortCriteria).offset(listViewSpec.skip).limit(listViewSpec.take).withTotalCount().opId(this.buildOperationId(listViewSpec));
        if (filter.isPresent()) {
            query.where((Filter)filter.get());
        }
        ResultSet resultSet = userFilter.isPresent() ? ComplexQuerySupport.joinFilter((QueryCommand)query.build(), (Filter)((Filter)userFilter.get())) : query.fetch();
        return resultSet;
    }

    private List<SortCriterion> createSortCriteria(SortSpec[] sortSpecs) {
        ArrayList<SortCriterion> sortCriteria = new ArrayList<SortCriterion>();
        if (ArrayUtils.isNotEmpty((Object[])sortSpecs)) {
            for (SortSpec sortSpec : sortSpecs) {
                SortCriterion.SortDirection sortDirection = SortCriterion.SortDirection.ASCENDING;
                if (SortDirection.desc.equals((Object)sortSpec.dir)) {
                    sortDirection = SortCriterion.SortDirection.DESCENDING;
                }
                SortCriterion sortCriterion = new SortCriterion(ListViewController.removeFormatSuffix(sortSpec.field), sortDirection);
                sortCriteria.add(sortCriterion);
            }
        }
        return sortCriteria;
    }

    private Map<String, Object> transformRelationDataToMap(ResultSet resultSet) {
        ArrayList itemDataResult = new ArrayList();
        for (ResourceItem item : resultSet.getItems()) {
            HashMap<String, Object> itemData = new HashMap<String, Object>();
            for (String property : resultSet.getProperties()) {
                Object value = item.get(property);
                if (value != null && this._objectReferenceService.getResourceObjectType(value) != null) {
                    itemData.put(property, this._objectReferenceService.getUid(value, true));
                    continue;
                }
                itemData.put(property, value);
            }
            itemData.put(OBJECT_ID, this._objectReferenceService.getUid(item.getKey(), true));
            itemDataResult.add(itemData);
        }
        HashMap<String, Object> resultObject = new HashMap<String, Object>();
        resultObject.put("data", itemDataResult);
        resultObject.put("totalResultCount", resultSet.getTotalCount());
        return resultObject;
    }

    private ResultItem[] transformRelationDataToExportItems(ResultSet resultSet, ExportColumn[] exportColumns) {
        List resourceItems = resultSet.getItems();
        ResultItem[] resultItems = new ResultItem[resourceItems.size()];
        int itemIndex = 0;
        for (ResourceItem resourceItem : resourceItems) {
            PropertyValue[] pvs = new PropertyValue[exportColumns.length];
            int propIndex = 0;
            for (ExportColumn exportColumn : exportColumns) {
                PropertyValue pv = new PropertyValue();
                pv.value = exportColumn.type == ColumnType.CUSTOM ? this.customPropValue(resourceItem, exportColumn.propertyName) : resourceItem.get(exportColumn.propertyName);
                pv.propertyName = exportColumn.propertyName;
                pvs[propIndex++] = pv;
            }
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = resourceItem.getKey();
            resultItem.properties = pvs;
            resultItems[itemIndex++] = resultItem;
        }
        return resultItems;
    }

    private Object customPropValue(ResourceItem resultItem, String guidAndKey) {
        CustomFieldsManager.Value[] customAttrValues = (CustomFieldsManager.Value[])resultItem.get("customValue");
        String resultItemServerGuid = (String)resultItem.get("@instanceUuid");
        if (customAttrValues != null) {
            for (CustomFieldsManager.Value customAttrValue : customAttrValues) {
                if (!(customAttrValue instanceof CustomFieldsManager.StringValue) || !this.parseCustomKey(guidAndKey).equals(String.valueOf(customAttrValue.key)) || !this.parseVcGuid(guidAndKey).equals(resultItemServerGuid)) continue;
                return ((CustomFieldsManager.StringValue)customAttrValue).value;
            }
        }
        return null;
    }

    private String parseCustomKey(String guidAndKey) {
        return guidAndKey.substring(guidAndKey.lastIndexOf(":") + 1);
    }

    private String parseVcGuid(String guidAndKey) {
        return guidAndKey.substring(0, guidAndKey.lastIndexOf(":"));
    }

    private String buildOperationId(ListViewSpec listViewSpec) {
        String operationId = this._opId;
        if (listViewSpec.isLiveRefreshRequest) {
            String relationId;
            operationId = operationId + ".liveRefreshRequest";
            if (StringUtils.isNotEmpty((CharSequence)listViewSpec.listViewId)) {
                operationId = operationId + "; listViewId=" + listViewSpec.listViewId;
            }
            if (ArrayUtils.isNotEmpty((Object[])listViewSpec.filterParams) && StringUtils.isNotEmpty((CharSequence)(relationId = listViewSpec.filterParams[0]))) {
                operationId = operationId + "; relationId=" + relationId;
            }
        }
        return operationId;
    }

    private static String removeFormatSuffix(String propertyName) {
        int index = propertyName.lastIndexOf(PROPERTY_FORMAT_SUFFIX);
        if (index > 1) {
            return propertyName.substring(0, index - 1);
        }
        return propertyName;
    }
}

