/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.vim.binding.pbm.fault.CompatibilityCheckFault;
import com.vmware.vise.core.model.EntitySpecPair;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.mvc.model.data.EntitySpecPairMulti;
import com.vmware.vise.mvc.model.data.MultiObjectMutationRequestSpec;
import com.vmware.vise.util.service.ClassLoaderService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/mutation"})
public class MutationServiceController {
    private final MutationService _mutationService;
    private final ObjectReferenceService _objRefService;
    private final ClassLoaderService _classLoaderService;
    private final ObjectMapper _objectMapper;
    private static final Log _logger = LogFactory.getLog(MutationServiceController.class);

    @Autowired
    public MutationServiceController(MutationService mutationService, ClassLoaderService classLoaderService, ObjectMapper objectMapper, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService) {
        this._mutationService = mutationService;
        this._classLoaderService = classLoaderService;
        this._objectMapper = objectMapper;
        this._objRefService = objectReferenceService;
    }

    @RequestMapping(value={"/{objectId:.*}"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult apply(@PathVariable(value="objectId") String objectId, @RequestParam(value="propertyName", required=true) String propertyName, @RequestBody Map<String, Object> args) {
        ResourceSpec rs = new ResourceSpec();
        Object target = this._objRefService.getReference(objectId, true);
        ObjectIdentityConstraint oic = new ObjectIdentityConstraint();
        oic.target = target;
        rs.constraint = oic;
        PropertySpec ps = new PropertySpec();
        ps.propertyNames = new String[]{propertyName};
        ParameterSpec paramSpec = new ParameterSpec();
        paramSpec.parameter = args;
        ps.parameters = new ParameterSpec[]{paramSpec};
        rs.propertySpecs = new PropertySpec[]{ps};
        OperationResult[] results = this._mutationService.applyData(rs);
        return results[0];
    }

    @RequestMapping(value={"/apply/{objectId:.*}"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult apply(@PathVariable(value="objectId") String objectId, @RequestParam(value="propertyObjectType", required=true) String propertyObjectType, @RequestBody String propertySpec) {
        OperationResult result = new OperationResult();
        Object propertyObject = null;
        try {
            Class clazz = this._classLoaderService.loadClass(propertyObjectType);
            propertyObject = this._objectMapper.readValue(propertySpec, clazz);
        }
        catch (Exception ex) {
            result.error = ex;
            return result;
        }
        Object target = this._objRefService.getReference(objectId, true);
        result = this._mutationService.apply(target, propertyObject);
        return result;
    }

    @RequestMapping(value={"/applyMultiSpec/{objectId:.*}"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult applyMultiSpec(@PathVariable(value="objectId") String objectId, @RequestParam(value="propertyObjectType") String propertyObjectType, @RequestBody List<Map<String, Object>> propertySpecs) {
        Object[] specs = new Object[propertySpecs.size()];
        try {
            Class clazz = this._classLoaderService.loadClass(propertyObjectType);
            for (int i = 0; i < propertySpecs.size(); ++i) {
                specs[i] = this.getJsonObject(propertySpecs.get(i), clazz);
            }
        }
        catch (Exception ex) {
            OperationResult result = new OperationResult();
            result.error = ex;
            return result;
        }
        OperationResult result = this._mutationService.applyMultiSpec(this._objRefService.getReference(objectId, true), specs);
        return result;
    }

    @RequestMapping(value={"/applyOnMultiEntity"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult[] applyOnMultiEntity(@RequestBody MultiObjectMutationRequestSpec requestSpec) {
        String[] objectIds = requestSpec.objectIds;
        String propertyObjectType = requestSpec.propertyObjectType;
        String propertySpec = requestSpec.propertySpec;
        OperationResult result = new OperationResult();
        Object propertyObject = null;
        try {
            Class clazz = this._classLoaderService.loadClass(propertyObjectType);
            propertyObject = this._objectMapper.readValue(propertySpec, clazz);
        }
        catch (Exception ex) {
            result.error = ex;
            return new OperationResult[]{result};
        }
        int targetLength = objectIds.length;
        Object[] targets = new Object[targetLength];
        for (int i = 0; i < targetLength; ++i) {
            targets[i] = this._objRefService.getReference(objectIds[i], true);
        }
        OperationResult[] operationResults = this._mutationService.applyOnMultiEntity(targets, propertyObject);
        return operationResults;
    }

    @RequestMapping(value={"/applyMulti"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult[] applyMulti(@RequestParam(value="propertyObjectType") String propertyObjectType, @RequestBody EntitySpecPairMulti[] entitySpecs) {
        EntitySpecPair[] specs = new EntitySpecPair[entitySpecs.length];
        try {
            Class clazz = this._classLoaderService.loadClass(propertyObjectType);
            for (int i = 0; i < entitySpecs.length; ++i) {
                specs[i] = new EntitySpecPair();
                specs[i].spec = this.getJsonObject(entitySpecs[i].spec, clazz);
                specs[i].entity = this._objRefService.getReference(entitySpecs[i].entity, true);
            }
        }
        catch (Exception ex) {
            OperationResult[] result = new OperationResult[]{new OperationResult()};
            result[0].error = ex;
            return result;
        }
        OperationResult[] result = this._mutationService.applyMulti(specs);
        return result;
    }

    private <T> T getJsonObject(Map<String, Object> specObjectMap, Class<T> clazz) throws JSONException, IOException {
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, Object> entry : specObjectMap.entrySet()) {
            jsonObject.put(entry.getKey(), entry.getValue());
        }
        return (T)this._objectMapper.readValue(jsonObject.toString(), clazz);
    }

    @RequestMapping(value={"/validateOnMultiEntity"}, method={RequestMethod.POST})
    @ResponseBody
    public ValidationResult[] validateOnMultiEntity(@RequestBody MultiObjectMutationRequestSpec requestSpec) {
        String[] objectIds = requestSpec.objectIds;
        String propertyObjectType = requestSpec.propertyObjectType;
        String propertySpec = requestSpec.propertySpec;
        ValidationResult result = new ValidationResult();
        Object propertyObject = null;
        try {
            Class clazz = this._classLoaderService.loadClass(propertyObjectType);
            propertyObject = this._objectMapper.readValue(propertySpec, clazz);
        }
        catch (Exception ex) {
            result.error = ex;
            return new ValidationResult[]{result};
        }
        int targetLength = objectIds.length;
        Object[] targets = new Object[targetLength];
        for (int i = 0; i < targetLength; ++i) {
            targets[i] = this._objRefService.getReference(objectIds[i], true);
        }
        ValidationResult[] validationResults = this._mutationService.validateOnMultiEntity(targets, propertyObject);
        return validationResults;
    }

    @RequestMapping(value={"/validate/{objectId:.*}"}, method={RequestMethod.POST})
    @ResponseBody
    public ValidationResult validate(@PathVariable(value="objectId") String objectId, @RequestParam(value="propertyObjectType", required=true) String propertyObjectType, @RequestBody String propertySpec) {
        ValidationResult result = new ValidationResult();
        Object propertyObject = null;
        try {
            Class clazz = this._classLoaderService.loadClass(propertyObjectType);
            propertyObject = this._objectMapper.readValue(propertySpec, clazz);
        }
        catch (Exception ex) {
            result.error = ex;
            return result;
        }
        Object target = this._objRefService.getReference(objectId, true);
        result = this._mutationService.validate(target, propertyObject);
        return result;
    }

    @RequestMapping(value={"/validateSpec"}, method={RequestMethod.POST})
    @ResponseBody
    public ValidationResult validate(@RequestParam(value="propertyObjectType", required=true) String propertyObjectType, @RequestBody String propertySpec) {
        ValidationResult result = new ValidationResult();
        Object propertyObject = null;
        try {
            Class clazz = this._classLoaderService.loadClass(propertyObjectType);
            propertyObject = this._objectMapper.readValue(propertySpec, clazz);
        }
        catch (Exception ex) {
            result.error = ex;
            return result;
        }
        result = this._mutationService.validate(null, propertyObject);
        return result;
    }

    @RequestMapping(value={"/validateMultiSpec"}, method={RequestMethod.POST})
    @ResponseBody
    public ValidationResult[] validateMultiSpec(@RequestParam(value="propertyObjectType", required=true) String propertyObjectType, @RequestBody List<Map<String, Object>> specObjects) throws CompatibilityCheckFault {
        if (specObjects == null || specObjects.size() == 0) {
            return null;
        }
        Object[] specs = new Object[specObjects.size()];
        try {
            Class clazz = this._classLoaderService.loadClass(propertyObjectType);
            for (int i = 0; i < specObjects.size(); ++i) {
                JSONObject jsonObject = new JSONObject();
                for (Map.Entry<String, Object> entry : specObjects.get(i).entrySet()) {
                    jsonObject.put(entry.getKey(), entry.getValue());
                }
                specs[i] = this._objectMapper.readValue(jsonObject.toString(), clazz);
            }
        }
        catch (Exception ex) {
            return null;
        }
        ValidationResult[] result = this._mutationService.validateMultiSpec(null, specs);
        return result;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult add(@RequestParam(value="propertyObjectType", required=true) String propertyObjectType, @RequestBody String propertySpec) {
        OperationResult result = new OperationResult();
        Object propertyObject = null;
        try {
            Class clazz = this._classLoaderService.loadClass(propertyObjectType);
            propertyObject = this._objectMapper.readValue(propertySpec, clazz);
        }
        catch (Exception ex) {
            result.error = ex;
            return result;
        }
        result = this._mutationService.add(propertyObject);
        return result;
    }

    @RequestMapping(value={"/addMulti"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult[] addMulti(@RequestParam(value="propertyObjectType") String propertyObjectType, @RequestBody List<Map<String, Object>> propertySpecs) {
        Object[] specs = new Object[propertySpecs.size()];
        try {
            Class clazz = this._classLoaderService.loadClass(propertyObjectType);
            for (int i = 0; i < propertySpecs.size(); ++i) {
                JSONObject jsonObject = new JSONObject();
                for (Map.Entry<String, Object> entry : propertySpecs.get(i).entrySet()) {
                    jsonObject.put(entry.getKey(), entry.getValue());
                }
                specs[i] = this._objectMapper.readValue(jsonObject.toString(), clazz);
            }
        }
        catch (Exception ex) {
            OperationResult result = new OperationResult();
            result.error = ex;
            return new OperationResult[]{result};
        }
        OperationResult[] result = this._mutationService.addMulti(specs);
        return result;
    }

    @RequestMapping(value={"/remove/{objectId:.*}"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult remove(@PathVariable(value="objectId") String objectId, @RequestParam(value="propertyObjectType", required=false) String propertyObjectType, @RequestBody(required=false) String propertySpec) {
        Object propertyObject;
        OperationResult result = new OperationResult();
        try {
            propertyObject = this.loadPropertyObject(propertyObjectType, propertySpec);
        }
        catch (Exception ex) {
            result.error = ex;
            _logger.error((Object)String.format("Failed to load property object: %s", propertyObjectType), (Throwable)ex);
            return result;
        }
        Object target = this._objRefService.getReference(objectId, true);
        result = this._mutationService.remove(target, propertyObject);
        return result;
    }

    @RequestMapping(value={"/removeOnMultiEntity"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult[] removeOnMultiEntity(@RequestBody MultiObjectMutationRequestSpec requestSpec) {
        String[] objectIds = requestSpec.objectIds;
        String propertyObjectType = requestSpec.propertyObjectType;
        String propertySpec = requestSpec.propertySpec;
        OperationResult result = new OperationResult();
        Object propertyObject = null;
        try {
            if (propertyObjectType != null) {
                Class clazz = this._classLoaderService.loadClass(propertyObjectType);
                propertyObject = this._objectMapper.readValue(propertySpec, clazz);
            }
        }
        catch (Exception ex) {
            result.error = ex;
            return new OperationResult[]{result};
        }
        int targetLength = objectIds.length;
        Object[] targets = new Object[targetLength];
        for (int i = 0; i < targetLength; ++i) {
            targets[i] = this._objRefService.getReference(objectIds[i], true);
        }
        OperationResult[] operationResults = this._mutationService.removeOnMultiEntity(targets, propertyObject);
        return operationResults;
    }

    private Object loadPropertyObject(String propertyObjectType, String propertySpec) throws IOException, ClassNotFoundException {
        Object propertyObject = null;
        if (propertyObjectType == null) {
            return propertyObject;
        }
        Class clazz = this._classLoaderService.loadClass(propertyObjectType);
        propertyObject = this._objectMapper.readValue(propertySpec, clazz);
        return propertyObject;
    }
}

