/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginConstants;
import com.vmware.vise.extensionfw.impl.Filterer;
import com.vmware.vise.mvc.filters.ObjectPropertyFilter;
import com.vmware.vise.mvc.filters.PrivilegeFilter;
import com.vmware.vise.mvc.model.ViewSpecInternal;
import com.vmware.vise.mvc.navigation.NavigationNode;
import com.vmware.vise.util.IUID;
import com.vmware.vise.util.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class NavigationServiceController {
    private static final List<String> VSPHERE_OBJECT_VALUES = Arrays.asList(VirtualMachine.class.getSimpleName(), HostSystem.class.getSimpleName(), ClusterComputeResource.class.getSimpleName(), VirtualApp.class.getSimpleName(), ResourcePool.class.getSimpleName(), Folder.class.getSimpleName(), Datacenter.class.getSimpleName(), Datastore.class.getSimpleName(), StoragePod.class.getSimpleName(), Network.class.getSimpleName(), VmwareDistributedVirtualSwitch.class.getSimpleName(), DistributedVirtualSwitch.class.getSimpleName(), DistributedVirtualPortgroup.class.getSimpleName(), "com.vmware.content.Library", "com.vmware.content.library.Item");
    private static final Set<String> VSPHERE_OBJECT_TYPES = new HashSet<String>(VSPHERE_OBJECT_VALUES);
    private static final Set<String> VALID_PLUGIN_PACKAGE_IDS = new HashSet<String>(Arrays.asList(PluginConstants.CORE_VSPHERE_CLIENT_PACKAGE_IDS));
    private static final String PUBLIC_EXT_POINTS = "vsphere\\.core\\..+\\.(monitorViews|manageViews|manage\\.settingsViews|monitor\\.issuesViews|monitor\\.performanceViews|manage\\.alarmDefinitionsViews)";
    private static final Pattern CONFIG_OR_MONITOR_EXT_ID = Pattern.compile("vsphere\\.core\\..+\\.(monitorViews|manageViews|manage\\.settingsViews|monitor\\.issuesViews|monitor\\.performanceViews|manage\\.alarmDefinitionsViews)");
    private static final Log _logger = LogFactory.getLog(NavigationServiceController.class);
    private final String _opId = "h5c-" + this.getClass().getSimpleName() + ":";
    private final ObjectReferenceService _objRefService;
    private final QueryServiceFactory _queryServiceFactory;
    private final ExtensionService _extensionService;
    private static final String ONLY_LOCAL_FILTERS = "onlyLocalFilters";
    private static NavigationNode OBJECT_NOT_FOUND;
    private final ServiceRegistry _serviceRegistry;

    @Autowired
    public NavigationServiceController(QueryServiceFactory queryServiceFactory, ExtensionService extensionService, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService, ServiceRegistry serviceRegistry) {
        this._extensionService = extensionService;
        this._queryServiceFactory = queryServiceFactory;
        this._objRefService = objectReferenceService;
        this._serviceRegistry = serviceRegistry;
        OBJECT_NOT_FOUND = new NavigationNode();
        NavigationServiceController.OBJECT_NOT_FOUND.error = NavigationNode.ErrorType.OBJECT_NOT_FOUND;
    }

    @RequestMapping(value={"/navigation/data/{extensionId:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public NavigationNode getNavigationData(@PathVariable(value="extensionId") String extensionId, @RequestParam(value="objectId", required=false) String objectId) throws Exception {
        Validate.notNull((Object)extensionId);
        NavigationNode result = this.navigate(extensionId, objectId);
        return result;
    }

    public NavigationNode navigate(String extensionId, String objectId) throws Exception {
        Validate.notNull((Object)extensionId, (String)"extensionId cannot be null", (Object[])new Object[0]);
        ExtensionInfo[][] extensionPaths = this._extensionService.getExtensionHosts(extensionId);
        if (extensionPaths == null || extensionPaths.length == 0) {
            _logger.warn((Object)("No navigation path found for: " + extensionId));
            return null;
        }
        NavigationNode rootNode = null;
        NavigationNode currentNode = null;
        for (ExtensionInfo[] extensionPath : extensionPaths) {
            if (extensionPath[0].getExtendedPointIds().length > 1) continue;
            Map<String, Object> filterContext = this.createFilterContext(objectId);
            rootNode = new NavigationNode();
            rootNode.extensionObject = this._extensionService.getExtensionObject(extensionPath[0], filterContext, false);
            if (rootNode.extensionObject == null) {
                return OBJECT_NOT_FOUND;
            }
            String uid = ((IUID)rootNode.extensionObject).getUid();
            ArrayList<ExtensionInfo> childrenInfos = new ArrayList<ExtensionInfo>();
            childrenInfos.add(this.getExtensionInfo(uid));
            this.buildTree(rootNode, childrenInfos, objectId, extensionPath, 0);
            if (objectId != null) {
                String rootUid;
                List<ExtensionInfo> ext = this.excludePluginExtensions(childrenInfos, objectId, extensionId);
                Set<String> validUids = this.runRemoteFilters(ext, objectId);
                if (!validUids.contains(rootUid = ((IUID)rootNode.extensionObject).getUid())) {
                    return OBJECT_NOT_FOUND;
                }
                NavigationServiceController.pruneInvalidNodes(rootNode, validUids);
            }
            PathResult pathResult = this.probeExtensionPath(rootNode, extensionPath);
            if (!pathResult.isDesiredExtension) continue;
            currentNode = pathResult.navigationNode;
            break;
        }
        if (currentNode == null) {
            return rootNode;
        }
        do {
            if (currentNode.extensionObject instanceof IUID) continue;
            _logger.warn((Object)"Can't explore the navigation path any further as extension object is not an IUID.");
            return rootNode;
        } while ((currentNode = this.activateChildIndex(currentNode, null)) != null);
        return rootNode;
    }

    private Set<String> runRemoteFilters(List<ExtensionInfo> childrenInfos, String objectId) {
        Object ref = this._objRefService.getReference(objectId, true);
        assert (ref != null);
        Filterer filterer = new Filterer(false);
        HashMap<String, Object[]> filterContext = new HashMap<String, Object[]>();
        filterContext.put("contextObjects", new Object[]{ref});
        List filters = this._serviceRegistry.getServices(ExtensionObjectFilter.class.getName());
        Filterer.FilterResult filterResult = filterer.filterExtensions(childrenInfos, filterContext, filters);
        if (this.needsExistsCheck(filterResult.executedFilters) && !this.objectExists(ref)) {
            return Collections.emptySet();
        }
        HashSet<String> validUids = new HashSet<String>();
        for (ExtensionInfo ei : filterResult.extensionInfos) {
            validUids.add(ei.getId());
        }
        return validUids;
    }

    private boolean needsExistsCheck(List<ExtensionObjectFilter> executedFilters) {
        for (ExtensionObjectFilter eof : executedFilters) {
            if (!(eof instanceof ObjectPropertyFilter) && !(eof instanceof PrivilegeFilter)) continue;
            return false;
        }
        return true;
    }

    private void buildTree(NavigationNode root, ArrayList<ExtensionInfo> childrenInfos, String objectId, ExtensionInfo[] desiredPath, int pathIndex) {
        String rootUid = ((IUID)root.extensionObject).getUid();
        if (pathIndex < desiredPath.length && !rootUid.equals(desiredPath[pathIndex].getId())) {
            return;
        }
        ++pathIndex;
        List childExtensions = this.fetchChildren(rootUid, objectId);
        for (Object childExtension : childExtensions) {
            NavigationNode childNode = new NavigationNode();
            childNode.extensionObject = childExtension;
            String childUid = ((IUID)childNode.extensionObject).getUid();
            root.children.add(childNode);
            childrenInfos.add(this.getExtensionInfo(childUid));
            this.buildTree(childNode, childrenInfos, objectId, desiredPath, pathIndex);
        }
    }

    private static void pruneInvalidNodes(NavigationNode root, Set<String> validUids) {
        if (root == null || CollectionUtils.isEmpty(root.children)) {
            return;
        }
        Iterator<NavigationNode> it = root.children.iterator();
        while (it.hasNext()) {
            NavigationNode node = it.next();
            assert (node != null);
            String uid = ((IUID)node.extensionObject).getUid();
            if (validUids.contains(uid)) {
                NavigationServiceController.pruneInvalidNodes(node, validUids);
                continue;
            }
            it.remove();
        }
    }

    private PathResult probeExtensionPath(NavigationNode currentNode, ExtensionInfo[] extensionPath) throws Exception {
        for (int index = 0; index < extensionPath.length; ++index) {
            NavigationNode nextNode;
            String nextInPath = null;
            if (index + 1 < extensionPath.length) {
                nextInPath = extensionPath[index + 1].getId();
            }
            if ((nextNode = this.activateChildIndex(currentNode, nextInPath)) == null && index != extensionPath.length - 1) {
                return new PathResult(false, null);
            }
            currentNode = nextNode;
        }
        return new PathResult(true, currentNode);
    }

    private NavigationNode activateChildIndex(NavigationNode currentNode, String nextUid) throws Exception {
        NavigationNode nextNode = null;
        for (int childIndex = 0; childIndex < currentNode.children.size(); ++childIndex) {
            NavigationNode childNode = currentNode.children.get(childIndex);
            if (nextNode != null || !(childNode.extensionObject instanceof IUID)) continue;
            String childUid = ((IUID)childNode.extensionObject).getUid();
            ViewSpecInternal currentNodeObj = (ViewSpecInternal)currentNode.extensionObject;
            if (nextUid == null && currentNodeObj != null && !currentNodeObj.hostsMultipleViewsSimultaneously) {
                nextUid = childUid;
            }
            if (nextUid == null || !nextUid.equals(childUid)) continue;
            currentNode.childIndexToActivate = childIndex;
            nextNode = childNode;
        }
        return nextNode;
    }

    private <T> List<T> fetchChildren(String extensionId, String objectId) {
        ExtensionInfo ei = this.getExtensionInfo(extensionId);
        Validate.notNull((Object)ei, (String)("Extension '" + extensionId + "' not found."), (Object[])new Object[0]);
        if (ei.getHostedPointsIds() == null || ei.getHostedPointsIds().length == 0) {
            return Collections.emptyList();
        }
        Map<String, Object> filterContext = this.createFilterContext(objectId);
        ArrayList result = new ArrayList();
        for (String pointId : ei.getHostedPointsIds()) {
            if (this.isSummaryPortlet(pointId)) continue;
            result.addAll(this._extensionService.getExtensionObjects(pointId, filterContext, true));
        }
        return result;
    }

    private boolean isSummaryPortlet(String pointId) {
        return pointId != null && pointId.endsWith("summarySectionViews");
    }

    private ExtensionInfo getExtensionInfo(String extensionId) {
        ExtensionInfo ei = null;
        try {
            ei = this._extensionService.getExtensionInfo(extensionId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        assert (ei != null);
        return ei;
    }

    private boolean objectExists(Object ref) {
        if (ref == null) {
            return true;
        }
        QueryService queryService = this._queryServiceFactory.getQueryService();
        String refType = this._objRefService.getResourceObjectType(ref);
        ResultSet result = queryService.select(new String[0]).withTotalCount().from(new String[]{refType}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, ref).limit(0).opId(this._opId + ref).fetch();
        return result.getTotalCount() != 0;
    }

    private Map<String, Object> createFilterContext(String objectId) {
        Object ref;
        HashMap<String, Object> filterContext = new HashMap<String, Object>();
        if (objectId != null && (ref = this._objRefService.getReference(objectId, true)) != null) {
            filterContext.put("contextObjects", new Object[]{ref});
            filterContext.put(ONLY_LOCAL_FILTERS, true);
        }
        return filterContext;
    }

    private List<ExtensionInfo> excludePluginExtensions(List<ExtensionInfo> extInfos, String objectId, String extensionId) {
        ArrayList<ExtensionInfo> result = new ArrayList<ExtensionInfo>();
        Object objRef = this._objRefService.getReference(objectId, true);
        String objType = this._objRefService.getResourceObjectType(objRef);
        if (!VSPHERE_OBJECT_TYPES.contains(objType)) {
            return extInfos;
        }
        for (ExtensionInfo extInfo : extInfos) {
            String pckId;
            if (!NavigationServiceController.isConfigureOrMonitorView(extInfo)) {
                result.add(extInfo);
                continue;
            }
            Map metadata = extInfo.getMetadata();
            String string = pckId = metadata != null ? metadata.get("pluginPackageId") : "";
            if (pckId != null && StringUtils.isNotEmpty((CharSequence)pckId.toString()) && VALID_PLUGIN_PACKAGE_IDS.contains(pckId.toString())) {
                result.add(extInfo);
                continue;
            }
            if (!extensionId.equals(extInfo.getId())) continue;
            return extInfos;
        }
        return result;
    }

    private static boolean isConfigureOrMonitorView(ExtensionInfo extInfo) {
        String[] extendedPoints = extInfo.getExtendedPointIds();
        if (extendedPoints == null) {
            return false;
        }
        for (String extPoint : extendedPoints) {
            Matcher m = CONFIG_OR_MONITOR_EXT_ID.matcher(extPoint);
            if (!m.matches()) continue;
            return true;
        }
        return false;
    }

    private static class PathResult {
        public boolean isDesiredExtension;
        public NavigationNode navigationNode;

        public PathResult(boolean isDesiredExtension, NavigationNode navigationNode) {
            this.isDesiredExtension = isDesiredExtension;
            this.navigationNode = navigationNode;
        }
    }
}

