/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.mvc.model.ObjectTypeSpec;
import com.vmware.vise.mvc.objecttypes.ObjectTypesManager;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/objectTypes"}, method={RequestMethod.GET})
public class ObjectTypesManagerController {
    private final ObjectTypesManager _ObjectTypesManager;

    @Autowired
    public ObjectTypesManagerController(@Qualifier(value="objectTypesManager") ObjectTypesManager objectTypesManager) {
        this._ObjectTypesManager = objectTypesManager;
    }

    @RequestMapping(value={"/{objectType}"})
    @ResponseBody
    public ObjectTypeSpec getObjectTypeSpec(@PathVariable(value="objectType") String objectType) {
        ObjectTypeSpec objectTypeSpec = this._ObjectTypesManager.getObjectTypeSpec(objectType);
        return objectTypeSpec;
    }

    @RequestMapping(value={"/"})
    @ResponseBody
    public Map<String, ObjectTypeSpec> getObjectTypeSpecs() {
        Map<String, ObjectTypeSpec> objectTypeSpecs = this._ObjectTypesManager.getAllObjectTypeSpecs();
        return objectTypeSpecs;
    }
}

