/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.store.OperationResult;
import com.vmware.vise.store.PersistenceException;
import com.vmware.vise.store.PersistenceService;
import com.vmware.vise.store.SearchCondition;
import com.vmware.vise.store.SearchCriteria;
import com.vmware.vise.store.UserData;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/persistence"})
public class PersistenceServiceController {
    private final PersistenceService _persistenceService;

    @Autowired
    public PersistenceServiceController(PersistenceService persistenceService) {
        this._persistenceService = persistenceService;
    }

    @RequestMapping(value={"/metadata"})
    @ResponseBody
    public Object getMetaData(@RequestParam(value="key") String key, @RequestParam(value="value") String value, @RequestParam(value="op") String op, @RequestParam(value="path") String path) throws Exception {
        String validPath = this.getValidatedPath(path);
        SearchCondition sc = this.createSearchCondition(key, value, op);
        SearchCriteria criteria = new SearchCriteria();
        criteria.conditions = new SearchCondition[]{sc};
        OperationResult opResult = this._persistenceService.queryMetadata(validPath, criteria, null);
        Object result = this.getResultfromOperationResult(opResult);
        return result;
    }

    @RequestMapping(value={"/data"})
    @ResponseBody
    public Object getData(@RequestParam(value="key") String key, @RequestParam(value="value") String value, @RequestParam(value="op") String op, @RequestParam(value="path") String path) throws Exception {
        String validPath = this.getValidatedPath(path);
        SearchCondition sc = this.createSearchCondition(key, value, op);
        SearchCriteria criteria = new SearchCriteria();
        criteria.conditions = new SearchCondition[]{sc};
        OperationResult opResult = this._persistenceService.queryUserData(validPath, criteria, null);
        Object result = this.getResultfromOperationResult(opResult);
        return result;
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> saveData(@RequestBody(required=false) UserData userData) throws Exception {
        this.validateUserData(userData);
        OperationResult opResult = this._persistenceService.setUserData(userData, false, null);
        this.validateOperationResult(opResult);
        return ResponseEntity.noContent().build();
    }

    @RequestMapping(value={"/remove"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void removeData(@RequestParam(value="uid") String[] uids) throws Exception {
        Validate.notEmpty((Object[])uids, (String)"uids cannot be empty null when removing the data.", (Object[])new Object[0]);
        OperationResult[] opResults = this._persistenceService.removeUserData(uids, null, null);
        for (int i = 0; i < opResults.length; ++i) {
            this.getResultfromOperationResult(opResults[i]);
        }
    }

    @RequestMapping(value={"/reset"}, method={RequestMethod.DELETE})
    @ResponseBody
    public Object reset() throws Exception {
        OperationResult opResult = this._persistenceService.reset();
        Object result = this.getResultfromOperationResult(opResult);
        return result;
    }

    private SearchCondition createSearchCondition(String key, String value, String op) throws Exception {
        Validate.notEmpty((CharSequence)key);
        Validate.notEmpty((CharSequence)value);
        Validate.notEmpty((CharSequence)op);
        SearchCondition sc = new SearchCondition();
        sc.key = key;
        sc.value = value;
        sc.op = op;
        return sc;
    }

    private Object getResultfromOperationResult(OperationResult opResult) throws Exception {
        this.validateOperationResult(opResult);
        return opResult.result;
    }

    private void validateOperationResult(OperationResult opResult) throws Exception {
        if (opResult == null) {
            throw new PersistenceException("Operation result obtained is null");
        }
        if (opResult.error != null) {
            throw new PersistenceException("Operation result has error." + opResult.error);
        }
    }

    private String getValidatedPath(String path) {
        if (StringUtils.isEmpty((CharSequence)path) || path.equals("undefined")) {
            return null;
        }
        return path;
    }

    private void validateUserData(UserData data) {
        Validate.notNull((Object)data);
        Validate.notNull((Object)data.value);
        Validate.notNull((Object)data.metadata);
        Validate.notEmpty((CharSequence)data.metadata.uid);
    }
}

