/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.mvc.relateditems.RelatedItemsManager;
import com.vmware.vise.mvc.relateditems.model.RelatedItemSummary;
import com.vmware.vise.mvc.relateditems.model.SimpleRelatedItemResult;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/relateditems"})
public class RelatedItemsController {
    private final RelatedItemsManager _relatedItemsManager;
    private final ObjectReferenceService _objectReferenceService;

    @Autowired
    public RelatedItemsController(RelatedItemsManager relatedItemsManager, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService) {
        this._relatedItemsManager = relatedItemsManager;
        this._objectReferenceService = objectReferenceService;
    }

    @RequestMapping(value={"/summary/{objectId:.*}"})
    @ResponseBody
    public RelatedItemSummary[] getRelatedItemsSummary(@PathVariable(value="objectId") String objectId, @RequestParam(value="relationId", required=false) String relationId, @RequestParam(value="onlyFavorites", defaultValue="true") boolean onlyFavorites, @RequestParam(value="fetchCount", defaultValue="true") boolean fetchCount) throws Exception {
        Object ref = this._objectReferenceService.getReference(objectId, true);
        RelatedItemSummary[] result = this.getRelatedItemsFromManager(ref, relationId, onlyFavorites, fetchCount);
        return result;
    }

    @RequestMapping(value={"/summary"})
    @ResponseBody
    public RelatedItemSummary[] getRelatedItemsSummaryByType(@RequestParam(value="objectType", required=true) String objectType, @RequestParam(value="relationId", required=false) String relationId, @RequestParam(value="onlyFavorites", defaultValue="true") boolean onlyFavorites, @RequestParam(value="fetchCount", defaultValue="true") boolean fetchCount) throws Exception {
        URI ref = DefaultUriSchemeUtil.createUri((String)objectType, (String)objectType);
        RelatedItemSummary[] result = this.getRelatedItemsFromManager(ref, relationId, onlyFavorites, fetchCount);
        return result;
    }

    @RequestMapping(value={"/list/{objectId:.*}"})
    @ResponseBody
    public RelatedItemSummary[] getRelatedItemsList(@PathVariable(value="objectId") String objectId, @RequestParam(value="relationsViewId", defaultValue="null") String relationsViewId, @RequestParam(value="onlyFavorites", defaultValue="false") boolean onlyFavorites) throws Exception {
        Object ref = this._objectReferenceService.getReference(objectId, true);
        RelatedItemSummary[] result = this._relatedItemsManager.getRelatedItemsSummary(ref, null, onlyFavorites, false, relationsViewId);
        return result;
    }

    @RequestMapping(value={"/listspec/{objectType:.*}"})
    @ResponseBody
    public RelatedItemSummary[] getRelatedItemsListSpecByType(@PathVariable(value="objectType") String objectType, @RequestParam(value="relationsViewId", required=true) String relationsViewId, @RequestParam(value="onlyFavorites", defaultValue="false") boolean onlyFavorites) throws Exception {
        URI ref = DefaultUriSchemeUtil.createUri((String)objectType, (String)objectType);
        RelatedItemSummary[] result = this._relatedItemsManager.getRelatedItemsSummary(ref, null, onlyFavorites, false, relationsViewId);
        return result;
    }

    @RequestMapping(value={"/{relationId}/{objectId:.*}"})
    @ResponseBody
    public List<Map<String, Object>> getRelatedItemsByRelationId(@PathVariable(value="relationId") String relationId, @PathVariable(value="objectId") String objectId, @RequestParam(value="defaultProperties", defaultValue="false") boolean defaultProperties) throws Exception {
        Object ref = this._objectReferenceService.getReference(objectId, true);
        List<Map<String, Object>> result = this.getRelatedItemsByRelationIdFromManager(ref, relationId, defaultProperties);
        return result;
    }

    @RequestMapping(value={"/{relationId}"})
    @ResponseBody
    public List<Map<String, Object>> getRelatedItemsByRelationIdAndType(@PathVariable(value="relationId") String relationId, @RequestParam(value="objectType", required=true) String objectType, @RequestParam(value="defaultProperties", defaultValue="false") boolean defaultProperties) throws Exception {
        URI ref = DefaultUriSchemeUtil.createUri((String)objectType, (String)objectType);
        List<Map<String, Object>> result = this.getRelatedItemsByRelationIdFromManager(ref, relationId, defaultProperties);
        return result;
    }

    @RequestMapping(value={"/simple/{objectId:.*}"})
    @ResponseBody
    public List<SimpleRelatedItemResult> getSimpleRelatedItems(@PathVariable(value="objectId") String objectId) throws Exception {
        Object ref = this._objectReferenceService.getReference(objectId, true);
        List<SimpleRelatedItemResult> result = this._relatedItemsManager.getSimpleRelatedItems(ref);
        return result;
    }

    @RequestMapping(value={"/relateditem/{objectId}"})
    @ResponseBody
    public RelatedItemSummary getRelatedItemSummary(@PathVariable(value="objectId") String objectId, @RequestParam(value="listViewId", required=true) String listViewId, @RequestParam(value="targetType", required=true) String targetType) throws Exception {
        Object ref = this._objectReferenceService.getReference(objectId, true);
        RelatedItemSummary result = this._relatedItemsManager.getRelatedItemSummary(ref, listViewId, targetType);
        return result;
    }

    private List<Map<String, Object>> getRelatedItemsByRelationIdFromManager(Object ref, String relationId, boolean defaultProperties) {
        if (defaultProperties) {
            return this._relatedItemsManager.getRelatedItems(ref, relationId, RelatedItemsManager.DEFAULT_PROPERTIES);
        }
        return this._relatedItemsManager.getRelatedItems(ref, relationId, null);
    }

    private RelatedItemSummary[] getRelatedItemsFromManager(Object ref, String relationId, boolean onlyFavorites, boolean fetchCount) throws Exception {
        return this._relatedItemsManager.getRelatedItemsSummary(ref, relationId, onlyFavorites, fetchCount, null);
    }
}

