/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.exception;

import com.vmware.vise.data.query.DataException;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final String ERROR_STACK_TRACE_FLAG = "error.stackTrace.show";
    private static final Log _logger = LogFactory.getLog(GlobalExceptionHandler.class);
    private ConfigurationService _configurationService;

    @Autowired
    void setConfigurationService(ConfigurationService configurationService) {
        this._configurationService = configurationService;
    }

    @ExceptionHandler
    @ResponseStatus
    @ResponseBody
    public Map<String, Object> handle(Throwable throwable, HttpServletRequest request) {
        String[] rootCauseStack;
        HashMap<String, Object> errorMap = new HashMap<String, Object>();
        errorMap.put("message", throwable.getMessage());
        if (throwable.getCause() != null) {
            Throwable cause = throwable.getCause();
            if (cause.getCause() != null) {
                cause = cause.getCause();
            }
            errorMap.put("cause", cause.toString());
        }
        if ((rootCauseStack = ExceptionUtils.getRootCauseStackTrace((Throwable)throwable)).length > 0) {
            String queryString = request.getQueryString();
            queryString = queryString == null ? "" : "?" + queryString;
            _logger.error((Object)String.format("Exception handled while processing request for %s: ", request.getRequestURI() + queryString), throwable);
            String flag = this._configurationService.getProperty(ERROR_STACK_TRACE_FLAG);
            if (Boolean.parseBoolean(flag)) {
                StringBuilder stackTrace = new StringBuilder(rootCauseStack[0]);
                for (int i = 1; i < rootCauseStack.length; ++i) {
                    stackTrace.append('\n');
                    stackTrace.append(rootCauseStack[i]);
                }
                errorMap.put("stackTrace", stackTrace.toString());
            }
        }
        if (throwable instanceof DataException) {
            DataException de = (DataException)throwable;
            if (!ArrayUtil.isNullOrEmpty((Object[])de.objects)) {
                errorMap.put("de_objects", de.objects);
            }
            if (!ArrayUtil.isNullOrEmpty((Object[])de.properties)) {
                errorMap.put("de_properties", de.properties);
            }
        }
        return errorMap;
    }
}

