/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.extensionfw.RemotePluginRegistry;
import com.vmware.vise.extensionfw.impl.remote.VcInfo;
import com.vmware.vise.mvc.filters.PluginExtensionFilter;
import com.vmware.vise.util.IdVersionPair;
import java.util.Map;
import java.util.Set;

public class RemotePluginExtensionFilter
extends PluginExtensionFilter {
    private final RemotePluginRegistry _remotePluginRegistry;

    public RemotePluginExtensionFilter(ExtensionService extensionService, RemotePluginRegistry remotePluginRegistry) {
        super(extensionService);
        this._remotePluginRegistry = remotePluginRegistry;
    }

    @Override
    protected boolean isValidExtension(ExtensionInfo ei, IdVersionPair pluginRef, PluginPackageInfo pluginPackageInfo, String ctxObjectString) {
        if (!pluginPackageInfo.isRemotePluginPackage()) {
            return true;
        }
        Map instancesPerVc = this._remotePluginRegistry.getRemotePluginInstancesPerVc(pluginRef);
        Set vcInfos = instancesPerVc.keySet();
        for (VcInfo vcInfo : vcInfos) {
            String serverGuid = vcInfo.vcGuid;
            if (!ctxObjectString.contains(serverGuid)) continue;
            return true;
        }
        return false;
    }
}

