/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.model;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.actionsfw.ActionMenuItemSpec;
import com.vmware.vise.actionsfw.ActionSpec;
import com.vmware.vise.extensionfw.ExtensionObjectFactory;
import com.vmware.vise.extensionfw.ExtensionObjectGenerator;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.ExtensionSpec;
import com.vmware.vise.extensionfw.PluginInfo;
import com.vmware.vise.extensionfw.PluginLocalizationManager;
import com.vmware.vise.extensionfw.PluginStyleManager;
import com.vmware.vise.extensionfw.RemotePluginExtensionIdService;
import com.vmware.vise.extensionfw.RemotePluginRegistry;
import com.vmware.vise.extensionfw.RemotePluginReverseProxyService;
import com.vmware.vise.extensionfw.impl.plugin.util.comparator.IdVersionPairComparator;
import com.vmware.vise.extensionfw.impl.plugin.util.comparator.RemotePluginInstanceComparator;
import com.vmware.vise.extensionfw.impl.remote.RemotePluginInstance;
import com.vmware.vise.extensionfw.impl.remote.RemotePluginMultiInstanceExtensionContext;
import com.vmware.vise.extensionfw.impl.remote.RemotePluginServerInfo;
import com.vmware.vise.extensionfw.impl.remote.RemotePluginServerUrl;
import com.vmware.vise.extensionfw.impl.remote.RemotePluginSingleInstanceExtensionContext;
import com.vmware.vise.extensionfw.impl.remote.VcInfo;
import com.vmware.vise.mvc.model.CategorySpec;
import com.vmware.vise.mvc.model.GlobalViewSpec;
import com.vmware.vise.mvc.model.ObjectSpec;
import com.vmware.vise.mvc.model.ViewSpec;
import com.vmware.vise.mvc.objectnavigator.model.ObjectNavigatorNodeSpec;
import com.vmware.vise.plugin.manifest.model.PluginData;
import com.vmware.vise.plugin.manifest.model.icon.IconRenderingContext;
import com.vmware.vise.plugin.manifest.model.object.menu.Action;
import com.vmware.vise.plugin.manifest.model.object.menu.Menu;
import com.vmware.vise.plugin.manifest.model.object.menu.Modal;
import com.vmware.vise.plugin.manifest.model.object.menu.Operation;
import com.vmware.vise.plugin.manifest.model.object.summary.Portlet;
import com.vmware.vise.plugin.manifest.model.object.view.Category;
import com.vmware.vise.plugin.manifest.model.object.view.ObjectView;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.ValidationUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PluginExtensionObjectFactory
implements ExtensionObjectFactory {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final String PLUGIN_SELECTOR_VIEW_URL = "resources/ui/views/plugins/remotePluginExtensionContextSelector.html";
    private final ExtensionService _extensionService;
    private final RemotePluginRegistry _remotePluginRegistry;
    private final RemotePluginReverseProxyService _remotePluginRpxService;
    private final RemotePluginExtensionIdService _extensionIdService;
    private final PluginStyleManager _pluginStyleManager;
    private final PluginLocalizationManager _pluginLocalizationManager;

    public PluginExtensionObjectFactory(ExtensionService extensionService, RemotePluginRegistry remotePluginRegistry, RemotePluginReverseProxyService remotePluginReverseProxyService, RemotePluginExtensionIdService extensionIdService, PluginStyleManager pluginStyleManager, PluginLocalizationManager pluginLocalizationManager) {
        this._extensionService = extensionService;
        this._remotePluginRegistry = remotePluginRegistry;
        this._remotePluginRpxService = remotePluginReverseProxyService;
        this._extensionIdService = extensionIdService;
        this._pluginStyleManager = pluginStyleManager;
        this._pluginLocalizationManager = pluginLocalizationManager;
    }

    public ExtensionSpec createHomeViewSpec(String id, Map<IdVersionPair, PluginData> pluginRefToPluginData, Map<IdVersionPair, String> pluginRefToHomeViewId) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{id, pluginRefToPluginData, pluginRefToHomeViewId});
        Map<IdVersionPair, PluginData> activePluginRefToData = this.filterActivePlugins(pluginRefToPluginData);
        boolean navigationVisible = true;
        HashMap<IdVersionPair, String> pluginRefToGlobalViewUri = new HashMap<IdVersionPair, String>();
        for (Map.Entry<IdVersionPair, PluginData> activePluginEntry : activePluginRefToData.entrySet()) {
            PluginData pluginData = activePluginEntry.getValue();
            IdVersionPair idVersionPair = activePluginEntry.getKey();
            if (navigationVisible) {
                navigationVisible = pluginData.getHomeScope().getView().isNavigationVisible();
            }
            String homeViewUrl = pluginData.getHomeScope().getView().uri;
            pluginRefToGlobalViewUri.put(idVersionPair, homeViewUrl);
        }
        return this.createGlobalViewSpec(id, navigationVisible, activePluginRefToData, pluginRefToHomeViewId, pluginRefToGlobalViewUri);
    }

    public ExtensionSpec createDeploymentViewSpec(String id, Map<IdVersionPair, PluginData> pluginRefToPluginData, Map<IdVersionPair, String> pluginRefToDeploymentViewId) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{id, pluginRefToPluginData, pluginRefToDeploymentViewId});
        Map<IdVersionPair, PluginData> activePluginRefToData = this.filterActivePlugins(pluginRefToPluginData);
        HashMap<IdVersionPair, String> pluginRefToGlobalViewUri = new HashMap<IdVersionPair, String>();
        for (IdVersionPair pluginRef : activePluginRefToData.keySet()) {
            String deploymentViewUri = activePluginRefToData.get(pluginRef).getDeploymentScope().getView().getUri();
            pluginRefToGlobalViewUri.put(pluginRef, deploymentViewUri);
        }
        return this.createGlobalViewSpec(id, true, activePluginRefToData, pluginRefToDeploymentViewId, pluginRefToGlobalViewUri);
    }

    public ExtensionSpec createNavigationSpec(String id, String targetId, String parentNodeId, Map<IdVersionPair, PluginData> pluginRefToPluginData) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{id, targetId, parentNodeId, pluginRefToPluginData});
        Map<IdVersionPair, PluginData> activePluginRefToData = this.filterActivePlugins(pluginRefToPluginData);
        String title = this.getLatestPluginName(activePluginRefToData);
        String icon = this.getLatestPluginIcon(activePluginRefToData);
        ObjectNavigatorNodeSpec spec = new ObjectNavigatorNodeSpec();
        spec.setUid(id);
        spec.navigationTargetUid = targetId;
        spec.title = title;
        spec.icon = icon;
        spec.parentUid = parentNodeId;
        spec.remotePluginExtensionContext = null;
        return spec;
    }

    public ExtensionSpec createViewSpec(String id, String categoryId, ObjectView view, IdVersionPair pluginRef, ExtensionObjectGenerator.ExtensionObjectGeneratorContext context) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{id, view});
        ViewSpec viewSpec = new ViewSpec();
        viewSpec.setUid(id);
        viewSpec.name = this._pluginLocalizationManager.getLocalizedString(pluginRef, view.getLabelKey());
        viewSpec.categoryUid = categoryId;
        viewSpec.contentSpec = new ObjectSpec();
        viewSpec.contentSpec.sandbox = true;
        viewSpec.contentSpec.url = this.adjustUrlForRemotePlugins(view.getUri(), pluginRef, context);
        viewSpec.remotePluginExtensionContext = this.createSingleInstanceExtensionContext(pluginRef, context);
        return viewSpec;
    }

    public ExtensionSpec createPortletSpec(String id, Portlet portlet, IdVersionPair pluginRef, ExtensionObjectGenerator.ExtensionObjectGeneratorContext context) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{id, portlet});
        ViewSpec viewSpec = new ViewSpec();
        viewSpec.setUid(id);
        viewSpec.name = this._pluginLocalizationManager.getLocalizedString(pluginRef, portlet.getTitleKey());
        viewSpec.icon = this._pluginStyleManager.getIconCssClassNames(pluginRef, portlet.getIcon(), IconRenderingContext.PORTLET);
        viewSpec.contentSpec = new ObjectSpec();
        viewSpec.contentSpec.sandbox = true;
        viewSpec.contentSpec.url = this.adjustUrlForRemotePlugins(portlet.getUri(), pluginRef, context);
        viewSpec.contentSpec.metadata = new HashMap();
        if (portlet.getSize() != null) {
            viewSpec.contentSpec.metadata.put("size", portlet.getSize().format());
        }
        viewSpec.remotePluginExtensionContext = this.createSingleInstanceExtensionContext(pluginRef, context);
        return viewSpec;
    }

    public ExtensionSpec createCategorySpec(String id, Category category, IdVersionPair pluginRef, ExtensionObjectGenerator.ExtensionObjectGeneratorContext context) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{id, category});
        CategorySpec categorySpec = new CategorySpec();
        categorySpec.setUid(id);
        categorySpec.label = this._pluginLocalizationManager.getLocalizedString(pluginRef, category.getLabelKey());
        categorySpec.remotePluginExtensionContext = this.createSingleInstanceExtensionContext(pluginRef, context);
        return categorySpec;
    }

    public ExtensionSpec createMenuSpec(String id, Menu menu, String[] actionIds, IdVersionPair pluginRef, ExtensionObjectGenerator.ExtensionObjectGeneratorContext context) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{id, menu, actionIds});
        ActionMenuItemSpec menuItemSpec = new ActionMenuItemSpec();
        menuItemSpec.setUid(id);
        menuItemSpec.type = "MENU";
        menuItemSpec.label = this._pluginLocalizationManager.getLocalizedString(pluginRef, menu.getLabelKey());
        menuItemSpec.icon = this._pluginStyleManager.getIconCssClassNames(pluginRef, menu.getIcon(), IconRenderingContext.MENU);
        menuItemSpec.children = new ArrayList();
        for (String actionId : actionIds) {
            ActionMenuItemSpec actionMenuItemSpec = new ActionMenuItemSpec();
            actionMenuItemSpec.setUid(actionId);
            actionMenuItemSpec.type = "ACTION";
            actionMenuItemSpec.remotePluginExtensionContext = this.createSingleInstanceExtensionContext(pluginRef, context);
            menuItemSpec.children.add(actionMenuItemSpec);
        }
        menuItemSpec.remotePluginExtensionContext = this.createSingleInstanceExtensionContext(pluginRef, context);
        return menuItemSpec;
    }

    public ExtensionSpec createModalActionSpec(String id, Action<Modal> modalAction, IdVersionPair pluginRef, ExtensionObjectGenerator.ExtensionObjectGeneratorContext context) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{id, modalAction, pluginRef});
        ValidationUtil.notNull((Object)modalAction.getTrigger());
        Modal modal = (Modal)modalAction.getTrigger();
        HashMap<String, String> pluginData = new HashMap<String, String>();
        pluginData.put("url", this.adjustUrlForRemotePlugins(modal.getUri(), pluginRef, context));
        if (modal.getSize() != null) {
            pluginData.put("size", modal.getSize().format());
        }
        pluginData.put("title", this._pluginLocalizationManager.getLocalizedString(pluginRef, modal.getTitleKey()));
        pluginData.put("closable", String.valueOf(modal.getClosable()));
        pluginData.put("headless", "false");
        return this.createActionSpec(id, modalAction, pluginData, pluginRef, context);
    }

    public ExtensionSpec createOperationActionSpec(String id, Action<Operation> operationAction, IdVersionPair pluginRef, ExtensionObjectGenerator.ExtensionObjectGeneratorContext context) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{id, operationAction, pluginRef});
        ValidationUtil.notNull((Object)operationAction.getTrigger());
        Operation operation = (Operation)operationAction.getTrigger();
        HashMap<String, String> pluginData = new HashMap<String, String>();
        pluginData.put("url", this.adjustUrlForRemotePlugins(operation.getUri(), pluginRef, context));
        pluginData.put("headless", "true");
        return this.createActionSpec(id, operationAction, pluginData, pluginRef, context);
    }

    private ExtensionSpec createActionSpec(String id, Action<?> action, Map<String, String> pluginData, IdVersionPair pluginRef, ExtensionObjectGenerator.ExtensionObjectGeneratorContext context) {
        ActionSpec actionSpec = new ActionSpec();
        actionSpec.setUid(id);
        actionSpec.label = this._pluginLocalizationManager.getLocalizedString(pluginRef, action.getLabelKey());
        actionSpec.icon = this._pluginStyleManager.getIconCssClassNames(pluginRef, action.getIcon(), IconRenderingContext.ACTION);
        actionSpec.pluginData = pluginData;
        actionSpec.invoker = "com.vmware.vsphere.client.pluginActions";
        actionSpec.remotePluginExtensionContext = this.createSingleInstanceExtensionContext(pluginRef, context);
        return actionSpec;
    }

    GlobalViewSpec createGlobalViewSpec(String id, boolean navigationVisible, Map<IdVersionPair, PluginData> pluginRefToPluginData, Map<IdVersionPair, String> pluginRefToGlobalViewId, Map<IdVersionPair, String> pluginRefToGlobalViewUri) {
        GlobalViewSpec globalViewSpec = new GlobalViewSpec();
        globalViewSpec.setUid(id);
        globalViewSpec.applyDefaultChrome = false;
        globalViewSpec.contentSpec = new ObjectSpec();
        globalViewSpec.contentSpec.sandbox = false;
        globalViewSpec.contentSpec.url = PLUGIN_SELECTOR_VIEW_URL;
        globalViewSpec.navigationVisible = navigationVisible;
        String globalViewTitle = this.getLatestPluginName(pluginRefToPluginData);
        globalViewSpec.remotePluginExtensionContext = this.createGlobalViewMultiInstanceExtensionContext(globalViewTitle, pluginRefToPluginData.keySet(), pluginRefToGlobalViewId, pluginRefToGlobalViewUri);
        return globalViewSpec;
    }

    private String adjustUrlForRemotePlugins(String originalUrl, IdVersionPair pluginRef, ExtensionObjectGenerator.ExtensionObjectGeneratorContext context) {
        RemotePluginInstance pluginInstance = this.getPluginInstance(pluginRef, context);
        if (pluginInstance == null) {
            return null;
        }
        return this._remotePluginRpxService.getProxiedUrlForInstance(pluginInstance, originalUrl);
    }

    private RemotePluginSingleInstanceExtensionContext createSingleInstanceExtensionContext(IdVersionPair pluginRef, ExtensionObjectGenerator.ExtensionObjectGeneratorContext context) {
        RemotePluginInstance pluginInstance = this.getPluginInstance(pluginRef, context);
        if (pluginInstance == null) {
            return null;
        }
        return this.createSingleInstanceExtensionContext(pluginRef, pluginInstance);
    }

    private RemotePluginSingleInstanceExtensionContext createSingleInstanceExtensionContext(IdVersionPair pluginRef, RemotePluginInstance pluginInstance) {
        String pluginInstanceRef = this._remotePluginRegistry.getPluginInstanceRef(pluginInstance);
        String pluginNavigableExtensionIdsPrefix = this._extensionIdService.getNavigableExtensionIdsPrefix(pluginRef);
        RemotePluginSingleInstanceExtensionContext result = new RemotePluginSingleInstanceExtensionContext();
        result.contextId = pluginInstanceRef;
        result.fullyQualifiedPluginInstanceId = pluginInstanceRef;
        result.pluginNavigableExtensionIdsPrefix = pluginNavigableExtensionIdsPrefix;
        return result;
    }

    RemotePluginMultiInstanceExtensionContext createGlobalViewMultiInstanceExtensionContext(String title, Set<IdVersionPair> pluginsRefs, Map<IdVersionPair, String> pluginRefToGlobalViewId, Map<IdVersionPair, String> pluginRefToGlobalViewUrl) {
        TreeSet<IdVersionPair> sortedPluginRefToPluginData = new TreeSet<IdVersionPair>((Comparator<IdVersionPair>)IdVersionPairComparator.INSTANCE);
        sortedPluginRefToPluginData.addAll(pluginsRefs);
        RemotePluginMultiInstanceExtensionContext result = new RemotePluginMultiInstanceExtensionContext();
        result.label = title;
        result.descriptors = new ArrayList();
        for (IdVersionPair pluginRef : sortedPluginRefToPluginData.descendingSet()) {
            TreeMap sortedPluginInstances = new TreeMap(RemotePluginInstanceComparator.INSTANCE);
            sortedPluginInstances.putAll(this._remotePluginRegistry.getRemotePluginInstances(pluginRef));
            Map<RemotePluginInstance, String> instanceToInstanceLabel = this.getInstanceToInstanceLabel(new ArrayList<RemotePluginInstance>(sortedPluginInstances.keySet()));
            for (Map.Entry instanceAndVcs : sortedPluginInstances.entrySet()) {
                RemotePluginInstance instance = (RemotePluginInstance)instanceAndVcs.getKey();
                Set vcsForInstance = (Set)instanceAndVcs.getValue();
                RemotePluginMultiInstanceExtensionContext.RemotePluginSingleInstanceExtensionDescriptor descriptor = new RemotePluginMultiInstanceExtensionContext.RemotePluginSingleInstanceExtensionDescriptor();
                descriptor.pluginRef = pluginRef;
                descriptor.extensionId = pluginRefToGlobalViewId.get(pluginRef);
                descriptor.extensionContext = this.createSingleInstanceExtensionContext(pluginRef, instance);
                descriptor.url = this._remotePluginRpxService.getProxiedUrlForInstance(instance, pluginRefToGlobalViewUrl.get(pluginRef));
                descriptor.instanceLabel = instanceToInstanceLabel.get(instance);
                descriptor.instanceUrl = instance.getPluginManifestServerInfo().url.toString();
                descriptor.versionLabel = this.getVersionLabel(pluginRef);
                for (VcInfo vcForInstance : vcsForInstance) {
                    descriptor.vCenterNames.add(vcForInstance.vcName);
                }
                Collections.sort(descriptor.vCenterNames);
                result.descriptors.add(descriptor);
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    Map<RemotePluginInstance, String> getInstanceToInstanceLabel(List<RemotePluginInstance> instances) {
        void var6_10;
        ArrayList<List<String>> splitPaths = new ArrayList<List<String>>(instances.size());
        for (RemotePluginInstance instance : instances) {
            String urlPath = instance.getPluginManifestServerInfo().url.getPath();
            if (urlPath.isEmpty()) {
                splitPaths.add(Collections.singletonList(this.getInstanceLabel(instance)));
                continue;
            }
            List<String> list = Arrays.asList(StringUtils.splitByWholeSeparatorPreserveAllTokens((String)urlPath, (String)"/", (int)-1));
            list.set(0, this.getInstanceLabel(instance));
            splitPaths.add(list);
        }
        List<List<String>> splitUniquePrefixes = PluginExtensionObjectFactory.getUniquePrefixes(splitPaths);
        ArrayList<String> uniquePrefixes = new ArrayList<String>(splitUniquePrefixes.size());
        for (List list : splitUniquePrefixes) {
            uniquePrefixes.add(StringUtils.join((Collection)list, (String)"/"));
        }
        HashMap<RemotePluginInstance, String> instanceLabelByInstance = new HashMap<RemotePluginInstance, String>(instances.size());
        boolean bl = false;
        while (var6_10 < instances.size()) {
            instanceLabelByInstance.put(instances.get((int)var6_10), (String)uniquePrefixes.get((int)var6_10));
            ++var6_10;
        }
        return instanceLabelByInstance;
    }

    static List<List<String>> getUniquePrefixes(List<List<String>> input) {
        ArrayList<List<String>> result = new ArrayList<List<String>>(input.size());
        for (List<String> obj : input) {
            int maxPrefix = 0;
            for (List<String> other : input) {
                if (obj == other) continue;
                int prefixLen = PluginExtensionObjectFactory.getNumberOfEqualPrefixElements(obj, other);
                if (prefixLen == obj.size() && prefixLen == other.size()) {
                    throw new IllegalArgumentException("Could not determine unique prefixes of equal strings!");
                }
                maxPrefix = Math.max(maxPrefix, prefixLen);
            }
            if (maxPrefix < obj.size()) {
                result.add(obj.subList(0, maxPrefix + 1));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    static int getNumberOfEqualPrefixElements(List<String> source, List<String> other) {
        int prefixLength = 0;
        for (int i = 0; i < Math.min(source.size(), other.size()) && source.get(i).equals(other.get(i)); ++i) {
            ++prefixLength;
        }
        return prefixLength;
    }

    private String getInstanceLabel(RemotePluginInstance instance) {
        RemotePluginServerInfo pluginXmlServerInfo = instance.getPluginManifestServerInfo();
        RemotePluginServerUrl pluginXmlUrl = pluginXmlServerInfo.url;
        return String.format("%s:%s", pluginXmlUrl.getHost(), pluginXmlUrl.getPort());
    }

    private String getVersionLabel(IdVersionPair pluginRef) {
        return pluginRef.getVersion();
    }

    private RemotePluginInstance getPluginInstance(IdVersionPair pluginRef, ExtensionObjectGenerator.ExtensionObjectGeneratorContext context) {
        if (context.contextObject == null) {
            return null;
        }
        if (!(context.contextObject instanceof ManagedObjectReference)) {
            _logger.error((Object)String.format("Unsupported context object: '%s' with type: '%s'", context.contextObject.toString(), context.contextObject.getClass().getName()));
            return null;
        }
        ManagedObjectReference contextObject = (ManagedObjectReference)context.contextObject;
        String vcGuid = contextObject.getServerGuid();
        RemotePluginInstance pluginInstance = this._remotePluginRegistry.getPluginInstanceForVc(pluginRef, vcGuid);
        if (pluginInstance == null) {
            _logger.warn((Object)String.format("No instances of remote plugin %s were found for context object: %s", pluginRef, context.contextObject));
        }
        return pluginInstance;
    }

    private Pair<IdVersionPair, PluginData> getLatestPluginData(Map<IdVersionPair, PluginData> pluginRefToPluginData) {
        if (pluginRefToPluginData.isEmpty()) {
            return null;
        }
        IdVersionPair latestPluginRef = Collections.max(pluginRefToPluginData.keySet(), IdVersionPairComparator.INSTANCE);
        PluginData latestPluginData = pluginRefToPluginData.get(latestPluginRef);
        return new ImmutablePair((Object)latestPluginRef, (Object)latestPluginData);
    }

    String getLatestPluginName(Map<IdVersionPair, PluginData> pluginRefToPluginData) {
        Pair<IdVersionPair, PluginData> latestPluginRefAndData = this.getLatestPluginData(pluginRefToPluginData);
        if (latestPluginRefAndData == null) {
            return null;
        }
        return this._pluginLocalizationManager.getLocalizedString((IdVersionPair)latestPluginRefAndData.getKey(), ((PluginData)latestPluginRefAndData.getValue()).getConfiguration().getNameKey());
    }

    String getLatestPluginIcon(Map<IdVersionPair, PluginData> pluginRefToPluginData) {
        Pair<IdVersionPair, PluginData> latestPluginRefAndData = this.getLatestPluginData(pluginRefToPluginData);
        if (latestPluginRefAndData == null) {
            return null;
        }
        return this._pluginStyleManager.getIconCssClassNames((IdVersionPair)latestPluginRefAndData.getKey(), ((PluginData)latestPluginRefAndData.getValue()).getConfiguration().getIcon(), IconRenderingContext.NAVIGATION);
    }

    Map<IdVersionPair, PluginData> filterActivePlugins(Map<IdVersionPair, PluginData> pluginRefToPluginData) {
        PluginInfo[] activePluginInfos;
        HashSet<IdVersionPair> activePluginRefs = new HashSet<IdVersionPair>();
        for (PluginInfo activePluginInfo : activePluginInfos = this._extensionService.getPluginInfos()) {
            activePluginRefs.add(activePluginInfo.getPluginRef());
        }
        HashMap<IdVersionPair, PluginData> activePluginRefToPluginData = new HashMap<IdVersionPair, PluginData>();
        for (Map.Entry<IdVersionPair, PluginData> pluginRefAndData : pluginRefToPluginData.entrySet()) {
            IdVersionPair pluginRef = pluginRefAndData.getKey();
            PluginData pluginData = pluginRefAndData.getValue();
            if (!activePluginRefs.contains(pluginRef)) continue;
            activePluginRefToPluginData.put(pluginRef, pluginData);
        }
        return activePluginRefToPluginData;
    }
}

