/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.model.data;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.vise.core.model.annotation.Dto;
import com.vmware.vise.mvc.model.data.PropertyPredicateSpec;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;

@Dto
public class FilterSpec {
    private List<PropertyPredicateSpec> criteria;
    private FilterLogicalOperator operator;

    public List<PropertyPredicateSpec> getCriteria() {
        return this.criteria;
    }

    public FilterLogicalOperator getOperator() {
        return this.operator;
    }

    public FilterSpec() {
    }

    public FilterSpec(List<PropertyPredicateSpec> criteria, FilterLogicalOperator operator) {
        Validate.notEmpty(criteria, (String)"Argument 'criteria'  must not be null or empty.");
        Validate.notNull((Object)((Object)operator), (String)"Argument 'operator'  must not be null.");
        this.criteria = criteria;
        this.operator = operator;
    }

    public Filter buildFilterFromSpec() {
        Validate.notEmpty(this.criteria);
        Validate.notNull((Object)((Object)this.operator));
        List<PropertyPredicate> predicateProperties = this.getPredicateProperties();
        LogicalOperator logicalOperator = this.getLogicalOperator();
        return new Filter(predicateProperties, logicalOperator);
    }

    private List<PropertyPredicate> getPredicateProperties() {
        ArrayList<PropertyPredicate> predicateProperties = new ArrayList<PropertyPredicate>();
        for (PropertyPredicateSpec propertyPredicateSpec : this.criteria) {
            predicateProperties.add(propertyPredicateSpec.buildPropertyPredicateFromSpec());
        }
        return predicateProperties;
    }

    private LogicalOperator getLogicalOperator() {
        return LogicalOperator.values()[this.operator.ordinal()];
    }

    @Dto
    public static enum FilterLogicalOperator {
        AND,
        OR;

    }
}

