/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.objectnavigator;

import com.google.common.base.Throwables;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.impl.Filterer;
import com.vmware.vise.mvc.objectnavigator.ObjectNavigatorManager;
import com.vmware.vise.mvc.objectnavigator.model.CategoryNode;
import com.vmware.vise.mvc.objectnavigator.model.ObjectNavigatorNodeSpec;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ObjectNavigatorManagerImpl
implements ObjectNavigatorManager {
    private static final Log _logger = LogFactory.getLog(ObjectNavigatorManagerImpl.class);
    private static final String OBJECT_NAVIGATOR_EXT_POINT = "vise.navigator.nodespecs";
    private final ExtensionService _extensionService;
    private final ServiceRegistry _serviceRegistry;
    private static final int MAX_LEVELS = 2;

    public ObjectNavigatorManagerImpl(ExtensionService extensionService, ServiceRegistry serviceRegistry) {
        this._extensionService = extensionService;
        this._serviceRegistry = serviceRegistry;
    }

    @Override
    public CategoryNode getCategoryNode(String nodeId, List<ObjectNavigatorNodeSpec> nodeSpecs) {
        if (StringUtil.isNullOrEmpty((String)nodeId)) {
            _logger.warn((Object)"getCategoryNode(): nodeId is empty");
            return null;
        }
        ObjectNavigatorNodeSpec nodeSpec = this.getNodeSpecById(nodeId, nodeSpecs);
        if (nodeSpec == null) {
            _logger.warn((Object)("getCategoryNode(): ObjectNavigatorSpec not found for nodeId=" + nodeId));
            return null;
        }
        CategoryNode rootCategoryNode = this.transformObjectSpecsToCategoryNode(nodeSpec);
        this.populateCategoryNode(rootCategoryNode, nodeSpecs);
        return rootCategoryNode;
    }

    @Override
    public CategoryNode getRoot(List<ObjectNavigatorNodeSpec> nodeSpecs) {
        return this.transformObjectSpecsToCategoryNode(this.getRootNode(nodeSpecs));
    }

    @Override
    public ObjectNavigatorNodeSpec getNodeByNavigationTargetUid(String navigationTargetUid, List<ObjectNavigatorNodeSpec> nodeSpecs) {
        if (StringUtil.isNullOrEmpty((String)navigationTargetUid)) {
            _logger.warn((Object)"getNodeByNavigationTargetUid(): navigationTargetUid is null");
            return null;
        }
        List<ObjectNavigatorNodeSpec> sortedNodeSpecs = ObjectNavigatorManagerImpl.sortNodeSpecs(nodeSpecs);
        for (ObjectNavigatorNodeSpec node : sortedNodeSpecs) {
            if (!navigationTargetUid.equals(node.navigationTargetUid)) continue;
            return node;
        }
        return null;
    }

    private static List<ObjectNavigatorNodeSpec> sortNodeSpecs(List<ObjectNavigatorNodeSpec> nodeSpecs) {
        LinkedList<ObjectNavigatorNodeSpec> sortedNodeSpecs = new LinkedList<ObjectNavigatorNodeSpec>();
        HashMap<String, ObjectNavigatorNodeSpec> nodeSpecByParentUid = new HashMap<String, ObjectNavigatorNodeSpec>();
        for (ObjectNavigatorNodeSpec node : nodeSpecs) {
            if (node.parentUid == null) {
                sortedNodeSpecs.add(node);
                continue;
            }
            nodeSpecByParentUid.put(node.parentUid, node);
        }
        for (int i = 0; i < nodeSpecByParentUid.size(); ++i) {
            ObjectNavigatorNodeSpec child = (ObjectNavigatorNodeSpec)((Object)nodeSpecByParentUid.get(sortedNodeSpecs.getFirst().getUid()));
            if (child != null) {
                sortedNodeSpecs.addFirst(child);
                continue;
            }
            _logger.error((Object)("Incorrect extension detected for vise.navigator.nodespecs extension point. There are multiple extensions with the same navigationTargetUid: " + sortedNodeSpecs.getFirst().navigationTargetUid + ", but from different parent chains."));
        }
        return sortedNodeSpecs;
    }

    @Override
    public ObjectNavigatorNodeSpec getClosestAncestorNodeThatCanBeFocused(String id, List<ObjectNavigatorNodeSpec> nodeSpecs) {
        if (StringUtil.isNullOrEmpty((String)id)) {
            _logger.warn((Object)"getClosestAncestorNodeThatCanBeFocused(): id is not set");
            return null;
        }
        ObjectNavigatorNodeSpec node = this.getNodeSpecById(id, nodeSpecs);
        if (node != null && node.isFocusable.booleanValue()) {
            return node;
        }
        if (node == null) {
            return null;
        }
        ObjectNavigatorNodeSpec ancestorNode = this.getNodeSpecById(node.parentUid, nodeSpecs);
        while (ancestorNode != null) {
            if (ancestorNode.isFocusable.booleanValue()) {
                return ancestorNode;
            }
            ancestorNode = this.getNodeSpecById(ancestorNode.parentUid, nodeSpecs);
        }
        return null;
    }

    private void populateCategoryNode(CategoryNode rootCategoryNode, List<ObjectNavigatorNodeSpec> nodeSpecs) {
        ArrayList<CategoryNode> idsYetToBeProcessed = new ArrayList<CategoryNode>();
        idsYetToBeProcessed.add(rootCategoryNode);
        for (int levelsDone = 0; levelsDone != 2; ++levelsDone) {
            ArrayList<CategoryNode> newIdsYetToBeProcessed = new ArrayList<CategoryNode>();
            for (CategoryNode node : idsYetToBeProcessed) {
                this.retrieveAndAddChildren(node, newIdsYetToBeProcessed, nodeSpecs);
            }
            idsYetToBeProcessed = newIdsYetToBeProcessed;
        }
    }

    private void retrieveAndAddChildren(CategoryNode parentNode, List<CategoryNode> childIdsYetToBeProcessed, List<ObjectNavigatorNodeSpec> nodeSpecs) {
        List<ObjectNavigatorNodeSpec> children = this.getChildrenNodeSpecsByParentId(parentNode.uid, nodeSpecs);
        if (children.isEmpty()) {
            return;
        }
        if (parentNode.children == null) {
            parentNode.children = new ArrayList<CategoryNode>();
        }
        for (ObjectNavigatorNodeSpec childNodeSpec : children) {
            CategoryNode treeNode = this.transformObjectSpecsToCategoryNode(childNodeSpec);
            parentNode.children.add(treeNode);
            childIdsYetToBeProcessed.add(treeNode);
        }
    }

    private CategoryNode transformObjectSpecsToCategoryNode(ObjectNavigatorNodeSpec objectNavigatorNodeSpec) {
        CategoryNode categoryNode = null;
        if (objectNavigatorNodeSpec != null) {
            categoryNode = new CategoryNode(objectNavigatorNodeSpec.getUid());
            categoryNode.title = objectNavigatorNodeSpec.title;
            categoryNode.icon = objectNavigatorNodeSpec.icon;
            categoryNode.viewOpenedUponFocus = objectNavigatorNodeSpec.getViewOpenedUponFocus();
            if (categoryNode.viewOpenedUponFocus != null) {
                categoryNode.viewOpenedUponFocus.setUid(objectNavigatorNodeSpec.getUid());
            }
            categoryNode.navigationTargetUid = objectNavigatorNodeSpec.navigationTargetUid;
            categoryNode.nodeObjectType = objectNavigatorNodeSpec.nodeObjectType;
        }
        return categoryNode;
    }

    private ObjectNavigatorNodeSpec getNodeSpecById(String id, List<ObjectNavigatorNodeSpec> nodeSpecs) {
        if (id == null) {
            return null;
        }
        for (ObjectNavigatorNodeSpec navNode : nodeSpecs) {
            if (!id.equals(navNode.getUid())) continue;
            return navNode;
        }
        return null;
    }

    private ObjectNavigatorNodeSpec getRootNode(List<ObjectNavigatorNodeSpec> nodeSpecs) {
        for (ObjectNavigatorNodeSpec navNode : nodeSpecs) {
            if (navNode.parentUid != null) continue;
            return navNode;
        }
        return null;
    }

    private List<ObjectNavigatorNodeSpec> getChildrenNodeSpecsByParentId(String id, List<ObjectNavigatorNodeSpec> nodeSpecs) {
        if (id == null) {
            return Collections.emptyList();
        }
        ArrayList<ObjectNavigatorNodeSpec> children = new ArrayList<ObjectNavigatorNodeSpec>();
        for (ObjectNavigatorNodeSpec navNode : nodeSpecs) {
            if (!id.equals(navNode.parentUid)) continue;
            children.add(navNode);
        }
        return children;
    }

    @Override
    public List<ObjectNavigatorNodeSpec> getNodeSpecs() {
        HashMap<String, Boolean> filterContext = new HashMap<String, Boolean>();
        filterContext.put("onlyLocalFilters", true);
        return this._extensionService.getExtensionObjects(OBJECT_NAVIGATOR_EXT_POINT, filterContext, false);
    }

    @Override
    public List<ObjectNavigatorNodeSpec> getNavigableNodeSpecsAndAncestors(String nodeId, List<ObjectNavigatorNodeSpec> nodeSpecs) {
        if (StringUtil.isNullOrEmpty((String)nodeId) || nodeSpecs == null || nodeSpecs.isEmpty()) {
            return Collections.emptyList();
        }
        List<ObjectNavigatorNodeSpec> navigationNodeSpecs = this.getNodeSpecsByNavigationTargetUid(nodeId, nodeSpecs);
        this.addNodeSpecAncestors(navigationNodeSpecs, nodeSpecs);
        navigationNodeSpecs = this.filterNodeSpecs(navigationNodeSpecs);
        return navigationNodeSpecs;
    }

    @Override
    public Set<String> getValidExtensionUids(CategoryNode categoryNode) {
        if (categoryNode == null) {
            return Collections.emptySet();
        }
        List<ExtensionInfo> extensionInfos = this.getCategoryExtensionInfos(categoryNode);
        return this.runRemoteFilters(extensionInfos);
    }

    private List<ExtensionInfo> getCategoryExtensionInfos(CategoryNode rootCategoryNode) {
        ArrayList<ExtensionInfo> extensionInfos = new ArrayList<ExtensionInfo>();
        extensionInfos.add(this.getExtensionInfo(rootCategoryNode.uid));
        List<CategoryNode> categoryNodes = rootCategoryNode.children;
        if (categoryNodes == null) {
            return extensionInfos;
        }
        while (!categoryNodes.isEmpty()) {
            ArrayList<CategoryNode> nodesToProcess = new ArrayList<CategoryNode>();
            for (CategoryNode categoryNode : categoryNodes) {
                extensionInfos.add(this.getExtensionInfo(categoryNode.uid));
                if (categoryNode.children == null || categoryNode.children.isEmpty()) continue;
                nodesToProcess.addAll(categoryNode.children);
            }
            categoryNodes = nodesToProcess;
        }
        return extensionInfos;
    }

    private List<ObjectNavigatorNodeSpec> filterNodeSpecs(List<ObjectNavigatorNodeSpec> nodeSpecs) {
        if (nodeSpecs.isEmpty()) {
            return nodeSpecs;
        }
        List<ExtensionInfo> extensionInfos = this.getExtensionInfos(nodeSpecs);
        Set<String> validUids = this.runRemoteFilters(extensionInfos);
        ArrayList<ObjectNavigatorNodeSpec> validNodeSpecs = new ArrayList<ObjectNavigatorNodeSpec>();
        for (ObjectNavigatorNodeSpec node : nodeSpecs) {
            if (!validUids.contains(node.getUid())) continue;
            validNodeSpecs.add(node);
        }
        return validNodeSpecs;
    }

    private List<ObjectNavigatorNodeSpec> getNodeSpecsByNavigationTargetUid(String navigationTargetUid, List<ObjectNavigatorNodeSpec> nodeSpecs) {
        ArrayList<ObjectNavigatorNodeSpec> navigationNodeSpecs = new ArrayList<ObjectNavigatorNodeSpec>();
        if (StringUtil.isNullOrEmpty((String)navigationTargetUid)) {
            _logger.warn((Object)"getNodeSpecsByNavigationTargetUid(): navigationTargetUid is null");
            return navigationNodeSpecs;
        }
        for (ObjectNavigatorNodeSpec node : nodeSpecs) {
            if (!navigationTargetUid.equals(node.navigationTargetUid)) continue;
            navigationNodeSpecs.add(node);
        }
        return navigationNodeSpecs;
    }

    private void addNodeSpecAncestors(List<ObjectNavigatorNodeSpec> navigationNodeSpecs, List<ObjectNavigatorNodeSpec> allNodeSpecs) {
        if (navigationNodeSpecs.isEmpty()) {
            _logger.warn((Object)"addNodeSpecAncestors(): navigationNodeSpecs is empty");
            return;
        }
        HashMap<String, ObjectNavigatorNodeSpec> nodeSpecByUid = new HashMap<String, ObjectNavigatorNodeSpec>();
        for (ObjectNavigatorNodeSpec node : allNodeSpecs) {
            nodeSpecByUid.put(node.getUid(), node);
        }
        ListIterator<ObjectNavigatorNodeSpec> it = navigationNodeSpecs.listIterator();
        while (it.hasNext()) {
            ObjectNavigatorNodeSpec currentNode = it.next();
            ObjectNavigatorNodeSpec ancestorNode = (ObjectNavigatorNodeSpec)((Object)nodeSpecByUid.get(currentNode.parentUid));
            nodeSpecByUid.remove(currentNode.getUid());
            while (ancestorNode != null) {
                if (!navigationNodeSpecs.contains((Object)ancestorNode)) {
                    it.add(ancestorNode);
                }
                nodeSpecByUid.remove(ancestorNode.getUid());
                ancestorNode = (ObjectNavigatorNodeSpec)((Object)nodeSpecByUid.get(ancestorNode.parentUid));
            }
        }
    }

    private Set<String> runRemoteFilters(List<ExtensionInfo> extensionInfos) {
        HashSet<String> validUids = new HashSet<String>();
        if (extensionInfos.isEmpty()) {
            return validUids;
        }
        Filterer filterer = new Filterer(false);
        HashMap filterContext = new HashMap();
        List filters = this._serviceRegistry.getServices(ExtensionObjectFilter.class.getName());
        Filterer.FilterResult filterResult = filterer.filterExtensions(extensionInfos, filterContext, filters);
        for (ExtensionInfo ei : filterResult.extensionInfos) {
            validUids.add(ei.getId());
        }
        return validUids;
    }

    private List<ExtensionInfo> getExtensionInfos(List<ObjectNavigatorNodeSpec> nodes) {
        ArrayList<ExtensionInfo> extensionInfos = new ArrayList<ExtensionInfo>();
        for (ObjectNavigatorNodeSpec childCategoryNode : nodes) {
            ExtensionInfo ei = this.getExtensionInfo(childCategoryNode.getUid());
            if (ei == null) continue;
            extensionInfos.add(ei);
        }
        return extensionInfos;
    }

    private ExtensionInfo getExtensionInfo(String extensionId) {
        ExtensionInfo ei = null;
        try {
            ei = this._extensionService.getExtensionInfo(extensionId);
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        assert (ei != null);
        return ei;
    }
}

