/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.objecttypes;

import com.vmware.vise.extensionfw.ExtensionListener;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginPackageEvent;
import com.vmware.vise.mvc.model.ObjectTypeSpec;
import com.vmware.vise.mvc.objecttypes.ObjectTypesManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ObjectTypesManagerImpl
implements ExtensionListener,
ObjectTypesManager {
    private static final Log _logger = LogFactory.getLog(ObjectTypesManagerImpl.class);
    private static final String OBJECT_TYPES_EXT_POINT = "vsphere.core.objectTypes";
    private final ExtensionService _extensionService;
    @GuardedBy(value="_readWriteLock")
    private final Map<String, ObjectTypeSpec> _objectTypeSpecsByType;
    private final ReadWriteLock _readWriteLock = new ReentrantReadWriteLock();
    private final Lock _readLock = this._readWriteLock.readLock();
    private final Lock _writeLock = this._readWriteLock.writeLock();

    @Autowired
    public ObjectTypesManagerImpl(ExtensionService extensionService) throws Exception {
        this._extensionService = extensionService;
        this._objectTypeSpecsByType = new HashMap<String, ObjectTypeSpec>();
        if (this._extensionService != null && this._extensionService.getExtensionPointInfo(OBJECT_TYPES_EXT_POINT) != null) {
            this.loadObjectTypeSpecs();
        }
    }

    public void handleEvent(PluginPackageEvent event) throws Exception {
        if (!event.isSuccessfulDeploymentEvent()) {
            return;
        }
        this.loadObjectTypeSpecs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectTypeSpec getObjectTypeSpec(String objectType) {
        try {
            ObjectTypeSpec spec;
            this._readLock.lock();
            ObjectTypeSpec objectTypeSpec = spec = this._objectTypeSpecsByType.get(objectType);
            return objectTypeSpec;
        }
        finally {
            this._readLock.unlock();
        }
    }

    @Override
    public Map<String, ObjectTypeSpec> getAllObjectTypeSpecs() {
        try {
            this._readLock.lock();
            Map<String, ObjectTypeSpec> map = Collections.unmodifiableMap(this._objectTypeSpecsByType);
            return map;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadObjectTypeSpecs() {
        try {
            this._writeLock.lock();
            this._objectTypeSpecsByType.clear();
            List objectTypeSpecs = this._extensionService.getAllExtensionObjects(OBJECT_TYPES_EXT_POINT);
            for (ObjectTypeSpec spec : objectTypeSpecs) {
                if (spec.types == null || spec.types.length == 0) continue;
                for (String type2 : spec.types) {
                    this._objectTypeSpecsByType.put(type2, spec);
                }
            }
        }
        finally {
            this._writeLock.unlock();
        }
    }
}

