/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.relateditems;

import com.google.common.base.Optional;
import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.SortType;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.extensionfw.ExtensionListener;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginPackageEvent;
import com.vmware.vise.mvc.lists.util.ListUtil;
import com.vmware.vise.mvc.model.ComponentSpec;
import com.vmware.vise.mvc.relateditems.RelatedItemsManager;
import com.vmware.vise.mvc.relateditems.model.ObjectRelationSetSpec;
import com.vmware.vise.mvc.relateditems.model.ObjectSimpleRelationSetSpec;
import com.vmware.vise.mvc.relateditems.model.RelatedItemSummary;
import com.vmware.vise.mvc.relateditems.model.RelationSpec;
import com.vmware.vise.mvc.relateditems.model.SimpleRelatedItemResult;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class RelatedItemsManagerImpl
implements ExtensionListener,
RelatedItemsManager {
    private static final Log _logger = LogFactory.getLog(RelatedItemsManagerImpl.class);
    private static final String RELATED_ITEMS_EXT_POINT = "vise.relateditems.specs";
    private static final String SIMPLE_RELATED_ITEMS_EXT_POINT = "vsphere.relatedobjects.summary.specs";
    private static final String LIST_EXT_POINT = "vise.inventory.lists";
    private static final String NO_CONDITION_KEY = "noCondition";
    private static final String OBJECT_ID = "id";
    private static final String INVERSE_SUFFIX = "/@deprecatedInverse";
    private final ExtensionService _extensionService;
    private final ObjectReferenceService _objRefService;
    private final DataService _dataService;
    @GuardedBy(value="_readWriteLock")
    private final Map<String, Map<String, Map<String, List<RelationSpec>>>> _relationSpecsByViewByConditionByType;
    @GuardedBy(value="_readWriteLock")
    private final Map<String, ComponentSpec> _listComponentSpecById;
    @GuardedBy(value="_readWriteLock")
    private final Map<String, List<RelationSpec>> _simpleRelationSpecsByType;
    private final ReadWriteLock _readWriteLock = new ReentrantReadWriteLock();
    private final Lock _readLock = this._readWriteLock.readLock();
    private final Lock _writeLock = this._readWriteLock.writeLock();
    private final List<ObjectRelationSetSpec> _objectRelationSetSpecs;
    private final QueryExecutor _queryExecutor;

    @Autowired
    public RelatedItemsManagerImpl(ExtensionService extensionService, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService, DataService dataService, QueryExecutor queryExecutor) throws Exception {
        this._extensionService = extensionService;
        this._objRefService = objectReferenceService;
        this._dataService = dataService;
        this._queryExecutor = queryExecutor;
        this._relationSpecsByViewByConditionByType = new HashMap<String, Map<String, Map<String, List<RelationSpec>>>>();
        this._listComponentSpecById = new HashMap<String, ComponentSpec>();
        this._simpleRelationSpecsByType = new HashMap<String, List<RelationSpec>>();
        this._objectRelationSetSpecs = new ArrayList<ObjectRelationSetSpec>();
        if (this._extensionService.getExtensionPointInfo(RELATED_ITEMS_EXT_POINT) != null) {
            this.loadSpecs();
        }
    }

    public void handleEvent(PluginPackageEvent event) throws Exception {
        if (!event.isSuccessfulDeploymentEvent()) {
            return;
        }
        this.loadSpecs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RelatedItemSummary[] getRelatedItemsSummary(Object reference, String relationId, boolean onlyFavorites, boolean fetchCount, String relationsViewId) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{reference});
        try {
            RelatedItemSummary[] list;
            RequestSpec requestSpec;
            List<Object> relationSpecs;
            this._readLock.lock();
            if (StringUtil.isNullOrEmpty((String)relationId)) {
                relationSpecs = this.getRelationSpecs(reference, onlyFavorites, relationsViewId);
            } else {
                relationSpecs = new ArrayList();
                RelationSpec rs = this.getRelationSpec(reference, relationId, relationsViewId);
                if (rs != null) {
                    relationSpecs.add(rs);
                }
            }
            Response response = null;
            if (fetchCount && ((response = this._dataService.getData(requestSpec = this.transformRelationSpecToQuery(relationSpecs, reference, new String[0], true))) == null || response.resultSet == null)) {
                RelatedItemSummary[] relatedItemSummaryArray = new RelatedItemSummary[]{};
                return relatedItemSummaryArray;
            }
            RelatedItemSummary[] relatedItemSummaryArray = list = this.transformRelationDataToSummary(reference, response, relationSpecs, fetchCount, relationsViewId != null);
            return relatedItemSummaryArray;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RelatedItemSummary getRelatedItemSummary(Object reference, String listViewId, String targetType) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{reference, listViewId, targetType});
        try {
            this._readLock.lock();
            Optional<ObjectRelationSetSpec> opt = this.findOrss(reference, listViewId, targetType);
            if (!opt.isPresent()) {
                throw new IllegalArgumentException("ORSS not found for listViewId: " + listViewId);
            }
            ObjectRelationSetSpec orss = (ObjectRelationSetSpec)opt.get();
            RelationSpec relationSpec = null;
            for (RelationSpec rs : orss.relationSpecs) {
                if (!rs.listViewId.equals(listViewId)) continue;
                relationSpec = rs;
                break;
            }
            if (relationSpec == null) {
                throw new IllegalStateException("RelationSpec not found for listViewId: " + listViewId);
            }
            Object[] summaries = this.transformRelationDataToSummary(reference, null, Arrays.asList(relationSpec), false, false);
            if (ArrayUtil.isNullOrEmpty((Object[])summaries)) {
                throw new IllegalStateException("Empty summary for: " + orss.relationsViewId);
            }
            if (summaries.length > 1) {
                throw new IllegalStateException("Summary size bigger than expected for: " + orss.relationsViewId + ". Expected size of 1, got: " + summaries.length);
            }
            Object object = summaries[0];
            return object;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> getRelatedItems(Object reference, String relationId, String[] properties) {
        try {
            List<Map<String, Object>> result;
            this._readLock.lock();
            RelationSpec rs = this.getRelationSpec(reference, relationId, null);
            if (rs == null) {
                throw new IllegalArgumentException("No matching RelationSpec found for relation id - " + relationId);
            }
            if (properties == null) {
                properties = ListUtil.getPropertiesToFetch(this._extensionService, rs.listViewId);
            }
            ArrayList<RelationSpec> specs = new ArrayList<RelationSpec>();
            specs.add(rs);
            RequestSpec requestSpec = this.transformRelationSpecToQuery(specs, reference, properties, false);
            Response response = this._dataService.getData(requestSpec);
            if (response == null || response.resultSet == null) {
                List<Map<String, Object>> list = null;
                return list;
            }
            List<Map<String, Object>> list = result = this.transformRelationDataToMap(response.resultSet[0]);
            return list;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SimpleRelatedItemResult> getSimpleRelatedItems(Object reference) {
        try {
            this._readLock.lock();
            String type2 = this._objRefService.getResourceObjectType(reference);
            List<RelationSpec> relationSpecs = this._simpleRelationSpecsByType.get(type2);
            ArrayList<SimpleRelatedItemResult> result = new ArrayList<SimpleRelatedItemResult>();
            if (relationSpecs == null) {
                ArrayList<SimpleRelatedItemResult> arrayList = result;
                return arrayList;
            }
            RequestSpec requestSpec = this.transformRelationSpecToQuery(relationSpecs, reference, RelatedItemsManager.DEFAULT_PROPERTIES, false);
            Response response = this._dataService.getData(requestSpec);
            if (response == null || response.resultSet == null) {
                ArrayList<SimpleRelatedItemResult> arrayList = result;
                return arrayList;
            }
            for (int i = 0; i < response.resultSet.length; ++i) {
                if (response.resultSet[i].items.length <= 0) continue;
                SimpleRelatedItemResult resultBySpec = new SimpleRelatedItemResult();
                resultBySpec.label = relationSpecs.get((int)i).label;
                resultBySpec.relatedItems = this.transformRelationDataToMap(response.resultSet[i]);
                result.add(resultBySpec);
            }
            ArrayList<SimpleRelatedItemResult> arrayList = result;
            return arrayList;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Filter> getFilterByRelationId(Object reference, String relationId) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{reference, relationId});
        try {
            this._readLock.lock();
            String targetType = this._objRefService.getResourceObjectType(reference);
            if (targetType == null) {
                Optional optional2 = Optional.absent();
                return optional2;
            }
            for (ObjectRelationSetSpec relationSpecSet : this._objectRelationSetSpecs) {
                if (!targetType.equals(relationSpecSet.type)) continue;
                for (RelationSpec relationSpec : relationSpecSet.relationSpecs) {
                    if (!relationId.equals(relationSpec.id)) continue;
                    Optional<Filter> optional3 = this.getRelatedItemFilter(relationSpec, reference);
                    return optional3;
                }
            }
            Optional optional4 = Optional.absent();
            return optional4;
        }
        finally {
            this._readLock.unlock();
        }
    }

    private Optional<Filter> getRelatedItemFilter(RelationSpec relationSpec, Object resource) {
        ArrayList<PropertyPredicate> result = new ArrayList<PropertyPredicate>();
        if (!StringUtil.isNullOrEmpty((String)relationSpec.inverseRelation)) {
            result.add(new PropertyPredicate(relationSpec.inverseRelation, PropertyPredicate.ComparisonOperator.EQUAL, resource));
        } else if (!StringUtil.isNullOrEmpty((String)relationSpec.relation)) {
            String forwardRelation = relationSpec.relation + INVERSE_SUFFIX;
            result.add(new PropertyPredicate(forwardRelation, PropertyPredicate.ComparisonOperator.EQUAL, resource));
        }
        if (!StringUtil.isNullOrEmpty((String)relationSpec.conditionalProperty)) {
            String propName = relationSpec.conditionalProperty;
            boolean propVal = true;
            if (relationSpec.conditionalProperty.charAt(0) == '!') {
                propVal = false;
                propName = relationSpec.conditionalProperty.substring(1);
            }
            result.add(new PropertyPredicate(propName, PropertyPredicate.ComparisonOperator.EQUAL, (Object)propVal));
        }
        if (result.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)new Filter(result));
    }

    private boolean isValidRelationSpec(RelationSpec rs, String listViewId, String targetType) {
        return rs.listViewId != null && rs.targetType != null && rs.listViewId.equals(listViewId) && rs.targetType.equals(targetType);
    }

    private Optional<ObjectRelationSetSpec> findOrss(Object reference, String listViewId, String targetType) throws Exception {
        ArrayList<ObjectRelationSetSpec> specs = new ArrayList<ObjectRelationSetSpec>();
        String refType = this._objRefService.getResourceObjectType(reference);
        if (refType == null) {
            throw new IllegalArgumentException("Invalid REF?! " + reference);
        }
        HashMap<Property, ObjectRelationSetSpec> orssByCondProp = new HashMap<Property, ObjectRelationSetSpec>();
        for (ObjectRelationSetSpec objectRelationSetSpec : this._objectRelationSetSpecs) {
            if (!objectRelationSetSpec.type.equals(refType)) continue;
            for (RelationSpec relationSpec : objectRelationSetSpec.relationSpecs) {
                if (!this.isValidRelationSpec(relationSpec, listViewId, targetType)) continue;
                if (objectRelationSetSpec.conditionalProperty != null) {
                    Property p = objectRelationSetSpec.conditionalProperty.charAt(0) == '!' ? new Property(this.cleanPropertyName(objectRelationSetSpec.conditionalProperty), 2) : new Property(objectRelationSetSpec.conditionalProperty, 1);
                    orssByCondProp.put(p, objectRelationSetSpec);
                }
                specs.add(objectRelationSetSpec);
            }
        }
        if (specs.isEmpty()) {
            return Optional.absent();
        }
        if (orssByCondProp.isEmpty()) {
            if (specs.size() > 1) {
                _logger.error((Object)("Got multiple specs for listViewId: " + listViewId));
                return Optional.absent();
            }
            return Optional.of(specs.get(0));
        }
        ArrayList<String> conditionalProperties = new ArrayList<String>();
        for (Property p : orssByCondProp.keySet()) {
            conditionalProperties.add(p.getName());
        }
        PropertyValue[] propertyValueArray = this._queryExecutor.getProperties(reference, conditionalProperties.toArray(new String[0]));
        for (RelationSpec relationSpec : propertyValueArray) {
            boolean propVal = (Boolean)((PropertyValue)relationSpec).value;
            String name = ((PropertyValue)relationSpec).propertyName;
            for (Property p : orssByCondProp.keySet()) {
                if (!this.isConditionMatched(propVal, name, p)) continue;
                ObjectRelationSetSpec orss = (ObjectRelationSetSpec)orssByCondProp.get(p);
                if (orss == null) {
                    throw new IllegalStateException("Got a null ORSS, this should never happen!");
                }
                return Optional.of((Object)orss);
            }
        }
        return Optional.absent();
    }

    private boolean isConditionMatched(boolean propVal, String name, Property p) {
        return !p.isNegated() && p.getName().equals(name) && propVal || p.isNegated() && p.getName().equals(name) && !propVal;
    }

    private RelationSpec getRelationSpec(Object reference, String relationid, String relationsViewId) {
        List<RelationSpec> relationSpecs = this.getRelationSpecs(reference, false, relationsViewId);
        for (RelationSpec rs : relationSpecs) {
            if (!rs.id.equals(relationid)) continue;
            return rs;
        }
        return null;
    }

    private List<RelationSpec> getRelationSpecs(Object reference, boolean onlyFavorites, String relationsViewId) {
        String type2 = this._objRefService.getResourceObjectType(reference);
        Map<String, Map<String, List<RelationSpec>>> relationSpecsByViewByCondition = !StringUtil.isNullOrEmpty((String)relationsViewId) ? this.getRelevantRelationsForRelationsViewId(type2, onlyFavorites, relationsViewId) : this._relationSpecsByViewByConditionByType.get(type2);
        String[] properties = this.getConditionalPropertyNames(relationSpecsByViewByCondition, onlyFavorites);
        Map<String, Object> propertiesMap = null;
        if (properties != null && properties.length > 0) {
            propertiesMap = this.getProperties(reference, properties);
        }
        return this.getFilteredRelationSpecs(relationSpecsByViewByCondition, onlyFavorites, propertiesMap, relationsViewId);
    }

    private Map<String, Map<String, List<RelationSpec>>> getRelevantRelationsForRelationsViewId(String type2, boolean onlyFavorites, String relationsViewId) {
        HashMap<String, Map<String, List<RelationSpec>>> relevantSpecsByViewByCondition = new HashMap<String, Map<String, List<RelationSpec>>>();
        Map<String, Map<String, List<RelationSpec>>> relationSpecsByViewByCondition = this._relationSpecsByViewByConditionByType.get(type2);
        if (relationSpecsByViewByCondition == null) {
            return relevantSpecsByViewByCondition;
        }
        for (Map.Entry<String, Map<String, List<RelationSpec>>> relationSpecByViewSet : relationSpecsByViewByCondition.entrySet()) {
            String prop = relationSpecByViewSet.getKey();
            List<RelationSpec> specs = relationSpecByViewSet.getValue().get(relationsViewId);
            if (specs == null) continue;
            ArrayList<RelationSpec> relevantSpecs = new ArrayList<RelationSpec>();
            this.concatenateAndFilterFavorites(relevantSpecs, specs, onlyFavorites);
            HashMap<String, ArrayList<RelationSpec>> relevantSpecsByView = new HashMap<String, ArrayList<RelationSpec>>();
            relevantSpecsByView.put(relationsViewId, relevantSpecs);
            relevantSpecsByViewByCondition.put(prop, relevantSpecsByView);
        }
        return relevantSpecsByViewByCondition;
    }

    private RequestSpec transformRelationSpecToQuery(List<RelationSpec> relationSpecs, Object reference, String[] properties, boolean countOnly) {
        QuerySpec[] queries = new QuerySpec[relationSpecs.size()];
        int index = 0;
        for (RelationSpec spec : relationSpecs) {
            Constraint constraint = this.getRelatedItemConstraint(spec, reference);
            QuerySpec query = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])properties);
            ResultSpec rs = new ResultSpec();
            if (countOnly) {
                rs.maxResultCount = 0;
            } else {
                rs.order = RelatedItemsManagerImpl.getOrderingCriteria(constraint.targetType);
            }
            query.resultSpec = rs;
            queries[index++] = query;
        }
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = queries;
        return requestSpec;
    }

    private RelatedItemSummary[] transformRelationDataToSummary(Object reference, Response response, List<RelationSpec> relationSpecs, boolean fetchCount, boolean fetchListSpec) throws Exception {
        ArrayList<RelatedItemSummary> list = new ArrayList<RelatedItemSummary>();
        int i = 0;
        for (RelationSpec spec : relationSpecs) {
            if (fetchListSpec && !this._listComponentSpecById.containsKey(spec.listViewId)) {
                _logger.warn((Object)("No list spec found for relation - " + spec.id));
                continue;
            }
            RelatedItemSummary ri = new RelatedItemSummary();
            ri.icon = spec.icon;
            ri.type = spec.targetType;
            ri.label = spec.label;
            ri.relationId = spec.id;
            ri.inverseRelation = spec.inverseRelation;
            if (fetchCount) {
                ri.count = this.extractRelatedItemCount(response, i);
            }
            if (fetchListSpec) {
                ri.listSpec = this._listComponentSpecById.get(spec.listViewId);
            }
            list.add(i++, ri);
        }
        return list.toArray(new RelatedItemSummary[0]);
    }

    private List<Map<String, Object>> transformRelationDataToMap(ResultSet rs) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (ResultItem ri : rs.items) {
            HashMap<String, Object> itemData = new HashMap<String, Object>();
            String objectId = this._objRefService.getUid(ri.resourceObject, true);
            itemData.put(OBJECT_ID, objectId);
            for (PropertyValue pv : ri.properties) {
                itemData.put(pv.propertyName, pv.value);
            }
            result.add(itemData);
        }
        return result;
    }

    private Integer extractRelatedItemCount(Response response, int resultIndex) {
        ResultSet result = response.resultSet[resultIndex];
        if (result == null) {
            return null;
        }
        if (result.error != null) {
            _logger.warn((Object)("Error when fetching related items data - " + result.error.getMessage()));
        }
        if (result.totalMatchedObjectCount == null) {
            return null;
        }
        return result.totalMatchedObjectCount;
    }

    private Map<String, Object> getProperties(Object reference, String[] properties) {
        HashMap<String, Object> propertiesMap = null;
        try {
            PropertyValue[] propValues = this._queryExecutor.getProperties(reference, properties);
            propertiesMap = new HashMap<String, Object>();
            for (PropertyValue pv : propValues) {
                propertiesMap.put(pv.propertyName, pv.value);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Error when fetching conditional properties.", (Throwable)e);
        }
        return propertiesMap;
    }

    private List<RelationSpec> getFilteredRelationSpecs(Map<String, Map<String, List<RelationSpec>>> relationSpecsByViewByCondition, boolean onlyFavorites, Map<String, Object> propertiesMap, String relationsViewId) {
        ArrayList<RelationSpec> resultSpecs = new ArrayList<RelationSpec>();
        if (relationSpecsByViewByCondition == null) {
            return resultSpecs;
        }
        for (Map.Entry<String, Map<String, List<RelationSpec>>> relationSpecByViewSet : relationSpecsByViewByCondition.entrySet()) {
            String prop = relationSpecByViewSet.getKey();
            boolean isOK = false;
            isOK = prop.equals(NO_CONDITION_KEY) ? true : propertiesMap != null && this.valueSatisfiesProperty(prop, propertiesMap.get(this.cleanPropertyName(prop)));
            for (Map.Entry<String, List<RelationSpec>> propRelationSpecSet : relationSpecByViewSet.getValue().entrySet()) {
                boolean addSpecForView;
                String relViewId = propRelationSpecSet.getKey();
                boolean bl = addSpecForView = relationsViewId == null || relViewId.equals(relationsViewId);
                if (!isOK || !addSpecForView) continue;
                List<RelationSpec> specs = propRelationSpecSet.getValue();
                this.concatenateAndFilterFavorites(resultSpecs, specs, onlyFavorites);
            }
        }
        return resultSpecs;
    }

    private String[] getConditionalPropertyNames(Map<String, Map<String, List<RelationSpec>>> relationSpecsByViewByCondition, boolean onlyFavorites) {
        ArrayList<String> conditionalProperties = new ArrayList<String>();
        if (relationSpecsByViewByCondition == null) {
            return new String[0];
        }
        for (Map.Entry<String, Map<String, List<RelationSpec>>> relationSpecsByViewSet : relationSpecsByViewByCondition.entrySet()) {
            String conditionalProp = relationSpecsByViewSet.getKey();
            if (conditionalProp.equals(NO_CONDITION_KEY)) continue;
            String cleanProp = this.cleanPropertyName(conditionalProp);
            if (onlyFavorites) {
                for (Map.Entry<String, List<RelationSpec>> propRelationSpecSet : relationSpecsByViewSet.getValue().entrySet()) {
                    List<RelationSpec> rSpecs = propRelationSpecSet.getValue();
                    if (!this.hasFavorites(rSpecs)) continue;
                    conditionalProperties.add(cleanProp);
                }
                continue;
            }
            conditionalProperties.add(cleanProp);
        }
        return conditionalProperties.toArray(new String[0]);
    }

    private Constraint getRelatedItemConstraint(RelationSpec relationSpec, Object resource) {
        if (relationSpec.constraint != null) {
            return relationSpec.constraint;
        }
        boolean hasRelConstraint = relationSpec.relation != null;
        Constraint relConstraint = null;
        boolean hasPropConstraint = !StringUtil.isNullOrEmpty((String)relationSpec.conditionalProperty);
        PropertyConstraint propConstraint = null;
        Constraint resultConstraint = null;
        if (hasRelConstraint) {
            resultConstraint = relConstraint = QueryUtil.createConstraintForRelationship((Object)resource, (String)relationSpec.relation, (String)relationSpec.targetType);
        }
        if (hasPropConstraint) {
            String propName = relationSpec.conditionalProperty;
            boolean propBVal = true;
            if (relationSpec.conditionalProperty.charAt(0) == '!') {
                propBVal = false;
                propName = relationSpec.conditionalProperty.substring(1);
            }
            propConstraint = QueryUtil.createPropertyConstraint((String)relationSpec.targetType, (String)propName, (Comparator)Comparator.EQUALS, (Object)propBVal);
            resultConstraint = propConstraint;
        }
        if (hasRelConstraint && hasPropConstraint) {
            resultConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relConstraint, propConstraint}, (Conjoiner)Conjoiner.AND);
        }
        if (resultConstraint != null && resultConstraint.targetType == null) {
            resultConstraint.targetType = relationSpec.targetType;
        }
        if (resultConstraint == null && relationSpec.targetType != null) {
            resultConstraint = new Constraint();
            resultConstraint.targetType = relationSpec.targetType;
        }
        return resultConstraint;
    }

    private String cleanPropertyName(String prop) {
        if (prop.charAt(0) == '!') {
            return prop.substring(1);
        }
        return prop;
    }

    private boolean hasFavorites(List<RelationSpec> relationSpecs) {
        for (RelationSpec rs : relationSpecs) {
            if (!rs.isFavorite) continue;
            return true;
        }
        return false;
    }

    private boolean valueSatisfiesProperty(String prop, Object value) {
        if (value == null || !(value instanceof Boolean)) {
            return false;
        }
        Boolean bValue = (Boolean)value;
        return bValue == (prop.charAt(0) != '!');
    }

    private void concatenateAndFilterFavorites(List<RelationSpec> dest, List<RelationSpec> src, boolean onlyFavorites) {
        for (RelationSpec rs : src) {
            if (!rs.isFavorite && onlyFavorites) continue;
            dest.add(rs);
        }
    }

    private static OrderingCriteria getOrderingCriteria(String targetType) {
        OrderingPropertySpec orderingPropSpec = new OrderingPropertySpec();
        orderingPropSpec.propertyNames = new String[]{"name"};
        orderingPropSpec.orderingType = SortType.ASCENDING;
        orderingPropSpec.type = StringUtil.isNullOrEmpty((String)targetType) ? "Object" : targetType;
        OrderingCriteria oc = new OrderingCriteria();
        oc.orderingProperties = new OrderingPropertySpec[]{orderingPropSpec};
        return oc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSpecs() {
        try {
            this._writeLock.lock();
            this._relationSpecsByViewByConditionByType.clear();
            this._listComponentSpecById.clear();
            this._simpleRelationSpecsByType.clear();
            this._objectRelationSetSpecs.clear();
            List relationSetSpecs = this._extensionService.getAllExtensionObjects(RELATED_ITEMS_EXT_POINT);
            for (Object orss : relationSetSpecs) {
                this._objectRelationSetSpecs.add((ObjectRelationSetSpec)orss);
                this.processObjectRelationSetSpecForRelationSpecs((ObjectRelationSetSpec)orss);
            }
            List listComponentSpecs = this._extensionService.getAllExtensionObjects(LIST_EXT_POINT);
            for (ComponentSpec listSpec : listComponentSpecs) {
                this._listComponentSpecById.put(listSpec.getUid(), listSpec);
            }
            List basicRelationSetSpecs = this._extensionService.getAllExtensionObjects(SIMPLE_RELATED_ITEMS_EXT_POINT);
            for (ObjectSimpleRelationSetSpec obrss : basicRelationSetSpecs) {
                this.addSimpleRelationSpecsToDictionary(obrss.type, Arrays.asList(obrss.relationSpecs));
            }
        }
        finally {
            this._writeLock.unlock();
        }
    }

    private void processObjectRelationSetSpecForRelationSpecs(ObjectRelationSetSpec ri) {
        if (!RelatedItemsManagerImpl.validateRelationSpecs(ri)) {
            return;
        }
        Map<String, Map<String, List<RelationSpec>>> relationSpecsByViewByCondition = this._relationSpecsByViewByConditionByType.get(ri.type);
        if (relationSpecsByViewByCondition == null) {
            relationSpecsByViewByCondition = new HashMap<String, Map<String, List<RelationSpec>>>();
            this._relationSpecsByViewByConditionByType.put(ri.type, relationSpecsByViewByCondition);
        }
        this.processObjectRelationSetSpecByViewByCondition(relationSpecsByViewByCondition, ri);
    }

    private void processObjectRelationSetSpecByViewByCondition(Map<String, Map<String, List<RelationSpec>>> map, ObjectRelationSetSpec ri) {
        Map<String, List<RelationSpec>> relationSpecsByView;
        String realKey = ri.conditionalProperty;
        if (StringUtil.isNullOrEmpty((String)ri.conditionalProperty)) {
            realKey = NO_CONDITION_KEY;
        }
        if ((relationSpecsByView = map.get(realKey)) == null) {
            relationSpecsByView = new HashMap<String, List<RelationSpec>>();
            map.put(realKey, relationSpecsByView);
        }
        this.addRelationSpecsByViewToDictionary(relationSpecsByView, ri);
    }

    private void addRelationSpecsByViewToDictionary(Map<String, List<RelationSpec>> map, ObjectRelationSetSpec ri) {
        List<Object> specs;
        if (StringUtil.isNullOrEmpty((String)ri.relationsViewId)) {
            _logger.warn((Object)String.format("Skipping processing of ObjectRelationSetSpec for type %s, since relationsViewId is null", ri.type));
            return;
        }
        String key = ri.relationsViewId.trim();
        if (!map.containsKey(key)) {
            specs = new ArrayList();
            map.put(key, specs);
        } else {
            specs = map.get(key);
        }
        for (RelationSpec spec : ri.relationSpecs) {
            if (StringUtil.isNullOrWhitespace((String)spec.id)) continue;
            specs.add(spec);
        }
    }

    private void addSimpleRelationSpecsToDictionary(String type2, List<RelationSpec> rs) {
        List<RelationSpec> allSpecs;
        if (StringUtil.isNullOrEmpty((String)type2) || rs == null) {
            return;
        }
        if (this._simpleRelationSpecsByType.containsKey(type2)) {
            List<RelationSpec> existingSpecs = this._simpleRelationSpecsByType.get(type2);
            allSpecs = new ArrayList<RelationSpec>(existingSpecs);
            allSpecs.addAll(rs);
        } else {
            allSpecs = rs;
        }
        this._simpleRelationSpecsByType.put(type2, allSpecs);
    }

    private static boolean validateRelationSpecs(ObjectRelationSetSpec orss) {
        if (orss.relationSpecs == null) {
            _logger.error((Object)String.format("Skipping processing of ObjectRelationSetSpec : (%s, %s, %s), since there are not valid RelationSpecs", orss.type, orss.relationsViewId, orss.conditionalProperty));
            return false;
        }
        for (RelationSpec rs : orss.relationSpecs) {
            if (StringUtil.isNullOrWhitespace((String)rs.id)) continue;
            return true;
        }
        _logger.error((Object)String.format("Skipping processing of ObjectRelationSetSpec : (%s, %s, %s), since there are not valid RelationSpecs", orss.type, orss.relationsViewId, orss.conditionalProperty));
        return false;
    }

    private static class Property {
        public static final int REGULAR = 1;
        public static final int NEGATED = 2;
        private final String _name;
        private final int _state;

        public Property(String name, int state) {
            this._name = name;
            this._state = state;
        }

        public String getName() {
            return this._name;
        }

        public boolean isNegated() {
            return this._state == 2;
        }
    }
}

