/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.search.formatter;

import com.vmware.cis.data.api.ResourceItem;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.ext.ManagedByInfo;
import com.vmware.vise.mvc.search.SearchManager;
import com.vmware.vise.mvc.search.formatter.ISearchableTypeFormatter;
import com.vmware.vise.mvc.util.CommonUtils;

public class VmFormatter
implements ISearchableTypeFormatter {
    private static final String VM_TEMPLATE_TYPE = "VirtualMachineTemplate";
    private static final String VM_TYPE = VirtualMachine.class.getSimpleName();
    private static final String PLACEHOLDER_VM = "placeholderVm";

    public VmFormatter(SearchManager searchManager) {
        if (searchManager != null) {
            searchManager.registerSearchableTypeFormatter(this);
        }
    }

    @Override
    public String getObjectType() {
        return VM_TYPE;
    }

    @Override
    public String getName(ResourceItem data) {
        Object ftPrimaryVm;
        String name = (String)data.get("name");
        ManagedByInfo managedBy = (ManagedByInfo)data.get("config/managedBy");
        if (managedBy != null && PLACEHOLDER_VM.equals(managedBy.getType())) {
            name = CommonUtils.text("placeholderVmFormat", name);
        }
        if ((ftPrimaryVm = data.get("config/ftInfo/primaryVM")) != null) {
            name = CommonUtils.text("secondaryVmFormat", name);
        }
        return name;
    }

    @Override
    public String getRuntimeType(ResourceItem data) {
        Boolean isTemplate = (Boolean)data.get("config/template");
        if (isTemplate != null && isTemplate.booleanValue()) {
            return VM_TEMPLATE_TYPE;
        }
        return VM_TYPE;
    }

    @Override
    public Object getNavigationEntity(ResourceItem data) {
        if (data == null) {
            return null;
        }
        Object ftPrimaryVm = data.get("config/ftInfo/primaryVM");
        if (ftPrimaryVm != null) {
            return ftPrimaryVm;
        }
        return data.getKey();
    }
}

