/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.search.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.vmware.vise.mvc.search.model.FilterCriteria;
import com.vmware.vise.util.ObjectUtil;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SearchCriteria {
    public QueryModel queryModel;
    public FilterCriteria[] filters;
    public String[] properties;
    public Integer maxResults;

    public boolean equals(Object object) {
        SearchCriteria searchCriteria = (SearchCriteria)object;
        boolean queryModelEquality = this.queryModel.equals((Object)searchCriteria.queryModel);
        int filterCriteriaIndex = 0;
        for (FilterCriteria filterCriteria : searchCriteria.filters) {
            if (filterCriteriaIndex >= this.filters.length || !this.filters[filterCriteriaIndex].equals(filterCriteria)) {
                return false;
            }
            ++filterCriteriaIndex;
        }
        boolean propertiesEquality = this.properties == searchCriteria.properties || this.properties.equals(searchCriteria.properties);
        boolean maxResultsEquality = this.maxResults == searchCriteria.maxResults || this.maxResults.equals(searchCriteria.maxResults);
        return queryModelEquality && propertiesEquality && maxResultsEquality;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ObjectUtil.getHashCode((Object)((Object)this.queryModel));
        result += 31 * ObjectUtil.getHashCode((Object)this.filters);
        result += 31 * ObjectUtil.getHashCode((Object)this.properties);
        return result += 31 * ObjectUtil.getHashCode((Object)this.maxResults);
    }

    public static enum QueryModel {
        QUICK_SEARCH{

            public String toString() {
                return "QuickSearch";
            }
        }
        ,
        VIRTUAL_MACHINE{

            public String toString() {
                return "VirtualMachine";
            }
        }
        ,
        HOST_SYSTEM{

            public String toString() {
                return "HostSystem";
            }
        }
        ,
        CLUSTER_COMPUTE_RESOURCE{

            public String toString() {
                return "ClusterComputeResource";
            }
        }
        ,
        DATACENTER{

            public String toString() {
                return "Datacenter";
            }
        }
        ,
        INVENTORY_SERVICE_TAG{

            public String toString() {
                return "inventoryservice:InventoryServiceTag";
            }
        };

    }
}

