/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.search.util;

import com.vmware.vise.metadata.Descriptor;
import com.vmware.vise.metadata.PropertyDescriptor;
import com.vmware.vise.metadata.TypeDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchUtil {
    private static final String USER_SEARCHABLE_OPTION = "userSearchable";
    private static final String TEXT_SEARCH_TARGET_OPTION = "textSearchTarget";

    public static boolean isUserSearchableDescriptor(Descriptor descriptor) {
        return descriptor.tags != null && descriptor.tags.containsKey(USER_SEARCHABLE_OPTION) && ((String)descriptor.tags.get(USER_SEARCHABLE_OPTION)).equalsIgnoreCase("true");
    }

    public static Map<String, List<String>> getSearchableProperties(List<TypeDescriptor> typeDescriptors, List<PropertyDescriptor> propertyDescriptors) {
        HashMap<String, List<String>> searchableDescriptors = new HashMap<String, List<String>>();
        for (TypeDescriptor typeDescriptor : typeDescriptors) {
            if (!SearchUtil.isUserSearchableDescriptor((Descriptor)typeDescriptor)) continue;
            searchableDescriptors.put(typeDescriptor.name, new ArrayList());
        }
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (!SearchUtil.isUserSearchableDescriptor((Descriptor)propertyDescriptor) || !propertyDescriptor.valueTypeName.equalsIgnoreCase("string") || !SearchUtil.isTextSearchTargetProperty(propertyDescriptor) || !searchableDescriptors.containsKey(propertyDescriptor.providerName)) continue;
            ((List)searchableDescriptors.get(propertyDescriptor.providerName)).add(propertyDescriptor.name);
        }
        return searchableDescriptors;
    }

    public static boolean isTextSearchTargetProperty(PropertyDescriptor property) {
        boolean isTextSearchTargetProperty = property.tags == null || !property.tags.containsKey(TEXT_SEARCH_TARGET_OPTION) || ((String)property.tags.get(TEXT_SEARCH_TARGET_OPTION)).equalsIgnoreCase("true");
        return isTextSearchTargetProperty;
    }
}

