/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.telemetry;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.vim.binding.vim.fault.InvalidName;
import com.vmware.vim.binding.vim.option.OptionManager;
import com.vmware.vim.binding.vim.option.OptionValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vise.mvc.telemetry.DataCollectionConfigurator;
import com.vmware.vise.util.serialization.JsonObjectMapper;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataCollectionConfiguratorImpl
implements DataCollectionConfigurator {
    private static final Log _logger = LogFactory.getLog(DataCollectionConfiguratorImpl.class);
    private static final String COLLECTION_ENABLED_KEY = "VirtualCenter.DataCollector.ConsentData";
    private final ObjectMapper _objectMapper = new JsonObjectMapper();
    private final boolean _shouldSkipVcCheck = Boolean.parseBoolean(System.getProperty("isFling"));

    @Override
    public boolean isCeipEnabled() {
        if (this._shouldSkipVcCheck) {
            return true;
        }
        VcService vcService = this.getVcService();
        if (vcService == null) {
            return false;
        }
        String consentData = this.getConsentData(vcService);
        if (consentData == null) {
            return false;
        }
        boolean value = this.parseConsentData(consentData);
        return value;
    }

    private VcService getVcService() {
        List<VcService> vcServices = this.getSessionVcServices();
        VcService vcService = this.getFirstCompatibleVc(vcServices);
        return vcService;
    }

    private List<VcService> getSessionVcServices() {
        ArrayList<VcService> resultVcServices = new ArrayList<VcService>();
        LinkedVcGroupRegistry vcRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        if (vcRegistry == null) {
            return resultVcServices;
        }
        LinkedVcGroup[] linkedVcGroups = vcRegistry.getLinkedVcGroups();
        if (linkedVcGroups == null) {
            return resultVcServices;
        }
        for (LinkedVcGroup linkedVcGroup : linkedVcGroups) {
            resultVcServices.addAll(linkedVcGroup.getVcServices());
        }
        return resultVcServices;
    }

    private VcService getFirstCompatibleVc(List<VcService> vcServices) {
        VcService vc60OrLater = null;
        for (VcService vc : vcServices) {
            if (!VcServiceUtil.is60VcOrLaterByVersion((String)vc.getServiceVersion())) continue;
            if (vc.getSsoDomain().isLocal()) {
                return vc;
            }
            vc60OrLater = vc;
        }
        return vc60OrLater;
    }

    private String getConsentData(VcService vcService) {
        OptionValue[] result;
        OptionManager optionManager = this.getOptionManager(vcService);
        try {
            result = optionManager.queryView(COLLECTION_ENABLED_KEY);
        }
        catch (InvalidName e) {
            _logger.error((Object)"Wrong option name. There is no option called VirtualCenter.DataCollector.ConsentData");
            return null;
        }
        catch (RuntimeFault e) {
            _logger.error((Object)"Could not retrieve information for setting VirtualCenter.DataCollector.ConsentData");
            return null;
        }
        String firstResult = result.length > 0 ? (String)result[0].getValue() : null;
        return firstResult;
    }

    private OptionManager getOptionManager(VcService vcService) {
        ManagedObjectReference vcSettingsId = vcService.getServiceInstanceContent().getSetting();
        OptionManager optionManager = (OptionManager)vcService.getManagedObject(vcSettingsId);
        return optionManager;
    }

    private boolean parseConsentData(String consentData) {
        boolean isCeipEnabled = false;
        try {
            JsonNode consentDataAsJson = this._objectMapper.readTree(consentData);
            JsonNode consentAccepted = consentDataAsJson.findValue("consentAccepted");
            isCeipEnabled = consentAccepted.booleanValue();
        }
        catch (IOException e) {
            _logger.error((Object)"Could not parse consent data. Unexpected data format.Disabling telemetry as a fallback option.");
        }
        return isCeipEnabled;
    }
}

