/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.util;

import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommonUtils {
    private static final Log _logger = LogFactory.getLog(CommonUtils.class);
    public static final String RESOURCE_BUNDLE = "CommonMvc";
    public static final String RESOURCE_BUNDLE_COMMON = "Common";
    public static final String SEMICOLON = ";";
    public static final String COLON = ":";

    public static String text(String key) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE, (String)key, (ClassLoader)CommonUtils.class.getClassLoader());
    }

    public static String text(String key, String ... parameters) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE, (String)key, (String[])parameters, (ClassLoader)CommonUtils.class.getClassLoader());
    }

    public static String getTaggingLabel(String labelIdsStr, Map<String, Map<String, String>> resourceMapByBundle, String delimiter, String defaultBundle) {
        String[] labelIds;
        ValidationUtil.paramsNotNull((Object[])new Object[]{resourceMapByBundle});
        if (StringUtil.isNullOrEmpty((String)labelIdsStr)) {
            return null;
        }
        if (StringUtil.isNullOrEmpty((String)delimiter)) {
            delimiter = ", ";
        }
        if (StringUtil.isNullOrEmpty((String)defaultBundle)) {
            defaultBundle = RESOURCE_BUNDLE_COMMON;
        }
        String loopDelimiter = "";
        StringBuilder labels = new StringBuilder();
        for (String labelId : labelIds = labelIdsStr.split(SEMICOLON)) {
            if (StringUtil.isNullOrEmpty((String)labelId)) continue;
            Map<String, String> resourceMap = null;
            String[] tokens = labelId.split(COLON);
            String labelKey = null;
            String label = null;
            if (tokens.length == 2) {
                resourceMap = resourceMapByBundle.get(tokens[0]);
                labelKey = tokens[1];
            } else if (tokens.length == 1) {
                resourceMap = resourceMapByBundle.get(defaultBundle);
                labelKey = tokens[0];
            }
            if (resourceMap != null) {
                label = resourceMap.get(labelKey);
            } else {
                _logger.warn((Object)String.format("resourceMap is null for [labelId=%s]", labelId));
            }
            if (label == null) {
                label = labelId;
            }
            labels.append(loopDelimiter);
            labels.append(label);
            loopDelimiter = delimiter;
        }
        String result = null;
        if (labels.length() > 0) {
            result = " (" + labels.toString() + ")";
        }
        return result;
    }
}

