/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.util;

import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.mvc.model.data.ParamSpec;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.serialization.ObjectSerializer;
import com.vmware.vise.util.service.ClassLoaderService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParameterSpecHelper {
    private ParamSpec[] _parameterSpecs;
    private ClassLoaderService _classLoaderService;
    private ObjectSerializer _objectMapper;

    public ParameterSpecHelper(ClassLoaderService classLoaderService, ObjectSerializer objectMapper, ParamSpec[] parameterSpecs) {
        this._classLoaderService = classLoaderService;
        this._objectMapper = objectMapper;
        this._parameterSpecs = parameterSpecs;
    }

    public Map<String, List<ParameterSpec>> getParameterSpecs() throws ClassNotFoundException, IOException {
        HashMap<String, List<ParameterSpec>> paramSpecsByPropertyName = new HashMap<String, List<ParameterSpec>>();
        if (this._parameterSpecs == null || this._parameterSpecs.length == 0) {
            return paramSpecsByPropertyName;
        }
        for (ParamSpec spec : this._parameterSpecs) {
            String propertyName = spec.propertyName;
            if (propertyName == null || propertyName.trim().equals("")) continue;
            ArrayList<ParameterSpec> paramObjects = (ArrayList<ParameterSpec>)paramSpecsByPropertyName.get(propertyName);
            if (ArrayUtil.isNullOrEmpty((List)paramObjects)) {
                paramObjects = new ArrayList<ParameterSpec>();
                paramSpecsByPropertyName.put(propertyName, paramObjects);
            }
            ParameterSpec paramSpec = new ParameterSpec();
            paramSpec.propertyName = propertyName;
            Class clazz = this._classLoaderService.loadClass(spec.parameterType);
            paramSpec.parameter = this._objectMapper.readValue(this._objectMapper.writeValueAsString(spec.parameter), clazz);
            paramObjects.add(paramSpec);
        }
        return paramSpecsByPropertyName;
    }
}

